/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen.side;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.luko.bestia.Bestia;
import net.luko.bestia.client.ClientConfigStore;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.data.buff.special.SpecialBuff;
import net.luko.bestia.data.buff.special.SpecialBuffRegistry;
import net.luko.bestia.network.ClearPointsPacket;
import net.luko.bestia.network.ModPackets;
import net.luko.bestia.network.RequestLeaderboardPacket;
import net.luko.bestia.network.SpendPointPacket;
import net.luko.bestia.screen.BestiaryScreen;
import net.luko.bestia.screen.BestiaryTooltip;
import net.luko.bestia.screen.side.BestiaryEntryScreenComponent;
import net.luko.bestia.screen.side.BestiarySideScreenComponent;
import net.luko.bestia.screen.widget.CustomButton;
import net.luko.bestia.util.ResourceUtil;
import net.luko.bestia.util.RomanUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;

public class FocusedBestiaryEntryScreenComponent
extends BestiarySideScreenComponent {
    protected final ResourceLocation mobId;
    protected BestiaryData data;
    protected final EntityType<?> entityType;
    protected final int levelsPerPoint;
    protected static final ResourceLocation LEVEL_BAR_COMPLETED_TEXTURE = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/level_completed_light.png");
    protected static final ResourceLocation LEVEL_BAR_BACKGROUND_TEXTURE = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/level_background_light.png");
    protected static final int LEVEL_BAR_WIDTH = 212;
    protected static final int LEVEL_BAR_LEFT_BLIT = 8;
    protected static final int LEVEL_BAR_RIGHT_BLIT = 8;
    protected static final int LEVEL_BAR_MIDDLE_BLIT = 196;
    protected static final int LEVEL_BAR_HEIGHT = 8;
    protected final BestiaryEntryScreenComponent entry;
    protected final int BUTTON_UV_DIMENSIONS = 12;
    protected final int BUTTON_BLIT_DIMENSIONS = 24;
    protected final float BUTTON_SCALE = 2.0f;
    protected final float BUFF_TITLE_SCALE = 2.0f;
    protected Map<SpecialBuff<?>, CustomButton> specialBuffButtons = new HashMap();
    protected ResourceLocation DEFAULT_BUFF_ICON_UNHOVERED = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/buff/default.png");
    protected ResourceLocation DEFAULT_BUFF_ICON_HOVERED = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/buff/default_hovered.png");
    protected Map<SpecialBuff<?>, Integer> orderedBuffs;
    protected static final int EXTRA_BUTTONS_HEIGHT = 14;
    protected CustomButton clearPointsButton;
    protected CustomButton leaderboardButton;
    protected boolean enableSpecialBuffs = false;

    public FocusedBestiaryEntryScreenComponent(int x, int y, int width, BestiaryScreen parentScreen, ResourceLocation mobId, BestiaryData data) {
        super(x, y, width, parentScreen);
        this.mobId = mobId;
        this.data = data;
        this.entry = new BestiaryEntryScreenComponent(this.mobId, this.data, null, true);
        this.entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(mobId);
        this.levelsPerPoint = ClientConfigStore.INSTANCE.levelsPerSpecialBuffPoint;
        if (ClientConfigStore.INSTANCE.enableSpecialBuffs) {
            this.enableSpecialBuffs = true;
        }
        this.initializeBuffs();
        this.finalizeLayout();
        this.initializeButtons();
    }

    public void initializeButtons() {
        if (this.data.level() >= this.levelsPerPoint) {
            for (Map.Entry<SpecialBuff<?>, Integer> buff : this.orderedBuffs.entrySet()) {
                ResourceLocation buffId = buff.getKey().getId();
                ResourceLocation iconUnhoveredTexture = ResourceUtil.fromNamespaceAndPath(buffId.m_135827_(), "textures/gui/bestiary/buff/" + buffId.m_135815_() + ".png");
                ResourceLocation iconHoveredTexture = ResourceUtil.fromNamespaceAndPath(buffId.m_135827_(), "textures/gui/bestiary/buff/" + buffId.m_135815_() + "_hovered.png");
                if (Minecraft.m_91087_().m_91098_().m_213713_(iconUnhoveredTexture).isEmpty() || Minecraft.m_91087_().m_91098_().m_213713_(iconHoveredTexture).isEmpty()) {
                    Bestia.LOGGER.warn("Missing texture for special buff: {}", (Object)buffId);
                    iconUnhoveredTexture = this.DEFAULT_BUFF_ICON_UNHOVERED;
                    iconHoveredTexture = this.DEFAULT_BUFF_ICON_HOVERED;
                }
                this.specialBuffButtons.put(buff.getKey(), new CustomButton(0, 0, 24, 24, btn -> ModPackets.CHANNEL.sendToServer((Object)new SpendPointPacket(this.mobId, ((SpecialBuff)buff.getKey()).getId())), iconUnhoveredTexture, iconHoveredTexture, 2.0f));
            }
            this.clearPointsButton = new CustomButton(0, 0, 72, 14, (Component)Component.m_237113_((String)"Clear points"), btn -> ModPackets.CHANNEL.sendToServer((Object)new ClearPointsPacket(this.mobId)));
        }
        this.leaderboardButton = new CustomButton(0, 0, 72, 14, (Component)Component.m_237113_((String)"Leaderboard"), btn -> ModPackets.CHANNEL.sendToServer((Object)new RequestLeaderboardPacket(this.mobId)));
    }

    public void refresh(BestiaryData newData) {
        this.data = newData;
        this.refreshBuffs();
        this.specialBuffButtons.clear();
        this.initializeButtons();
    }

    private void initializeBuffs() {
        LinkedHashMap existingBuffs = new LinkedHashMap();
        for (Map.Entry<ResourceLocation, Integer> entry2 : this.data.spentPoints().entrySet()) {
            SpecialBuff<?> buff = SpecialBuffRegistry.get(entry2.getKey());
            if (buff == null) continue;
            existingBuffs.put(buff, entry2.getValue());
        }
        LinkedHashMap allOrderedBuffs = new LinkedHashMap(existingBuffs.entrySet().stream().filter(entry -> ((SpecialBuff)entry.getKey()).getMaxLevel() > 0).sorted((a, b) -> (Integer)b.getValue() - (Integer)a.getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)));
        for (SpecialBuff<?> registered : SpecialBuffRegistry.all()) {
            if (allOrderedBuffs.containsKey(registered) || registered.getMaxLevel() <= 0) continue;
            allOrderedBuffs.put(registered, 0);
        }
        this.orderedBuffs = allOrderedBuffs;
    }

    private void refreshBuffs() {
        LinkedHashMap newBuffs = new LinkedHashMap();
        for (Map.Entry<SpecialBuff<?>, Integer> entry : this.orderedBuffs.entrySet()) {
            newBuffs.put(entry.getKey(), this.data.spentPoints().getOrDefault(entry.getKey().getId(), 0));
        }
        this.orderedBuffs = newBuffs;
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int adjustedX = this.x + 9 + 4;
        int nextY = this.y + 9 + 4;
        float headerScale = (float)this.availableWidth / 212.0f;
        poseStack.m_85836_();
        poseStack.m_85841_(headerScale, headerScale, 1.0f);
        this.entry.render(guiGraphics, this.scaled(adjustedX, headerScale) + 1, this.scaled(nextY, headerScale));
        poseStack.m_85849_();
        nextY += (int)(69.0f * headerScale);
        for (BestiaryTooltip tooltip : this.entry.getTooltips()) {
            this.tooltips.add(tooltip.scale(headerScale, this.scrollAmount));
        }
        this.leaderboardButton.m_252865_(adjustedX + 6);
        this.leaderboardButton.m_253211_(nextY + 6 - (int)this.scrollAmount);
        nextY += 22;
        if (this.enableSpecialBuffs) {
            this.renderPointSection(guiGraphics, adjustedX, nextY, mouseX, mouseY);
        }
    }

    private int renderPointSection(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int rightX = x + this.availableWidth;
        int nextY = y;
        if (this.data.level() >= this.levelsPerPoint) {
            this.clearPointsButton.m_252865_(x + 6);
            this.clearPointsButton.m_253211_(nextY + 6 - (int)this.scrollAmount);
            nextY = this.drawCenteredComponentWrapped(guiGraphics, (FormattedText)Component.m_237113_((String)String.format("%d point%s to spend", this.data.remainingPoints(), this.data.remainingPoints() == 1 ? "" : "s")), x, rightX, nextY, this.data.remainingPoints() == 0 ? 0xAAAAAA : 0xFFAAAA);
            nextY += 4;
            for (Map.Entry<SpecialBuff<?>, Integer> entry : this.orderedBuffs.entrySet()) {
                PoseStack poseStack = guiGraphics.m_280168_();
                CustomButton button = this.specialBuffButtons.get(entry.getKey());
                button.m_252865_(x + 2);
                button.m_253211_(nextY + 14 - (int)this.scrollAmount);
                poseStack.m_85836_();
                poseStack.m_85841_(2.0f, 2.0f, 1.0f);
                int wrapY = this.drawComponentWrapped(guiGraphics, (FormattedText)Component.m_237113_((String)String.format("%s %s", entry.getKey().getDisplayName(), RomanUtil.toRoman(entry.getValue()))), this.scaled(x + 30, 2.0f), this.scaled(rightX, 2.0f), this.scaled(nextY, 2.0f));
                nextY = Math.max(nextY + 24 + 4, this.scaled(wrapY, 2.0f));
                nextY += 4;
                poseStack.m_85849_();
                nextY = this.drawComponentWrapped(guiGraphics, (FormattedText)Component.m_237113_((String)entry.getKey().getInfo(entry.getValue())), x, rightX, nextY, 0xAAAAAA);
            }
            nextY += 12;
        }
        int lastPointLevel = Mth.m_14143_((float)((float)this.data.level() / (float)this.levelsPerPoint)) * this.levelsPerPoint;
        int nextPointLevel = lastPointLevel + this.levelsPerPoint;
        int lastPointWidth = FONT.m_92895_(String.valueOf(lastPointLevel));
        guiGraphics.m_280488_(FONT, String.valueOf(lastPointLevel), x, nextY += 4, 0xFFFFFF);
        int nextPointWidth = FONT.m_92895_(String.valueOf(nextPointLevel));
        guiGraphics.m_280488_(FONT, String.valueOf(nextPointLevel), rightX - nextPointWidth, nextY, 0xFFFFFF);
        int acquiredKillsForNextPoint = this.data.kills() - BestiaryData.totalNeededForLevel(lastPointLevel);
        int neededKillsForNextPoint = BestiaryData.totalNeededForLevel(nextPointLevel) - BestiaryData.totalNeededForLevel(lastPointLevel);
        float splitFactor = (float)acquiredKillsForNextPoint / (float)neededKillsForNextPoint;
        int prevY = nextY;
        nextY = this.drawLevelBar(guiGraphics, x + lastPointWidth + 2, rightX - nextPointWidth - 2, nextY, splitFactor);
        this.tooltips.add(new BestiaryTooltip(x + lastPointWidth + 2, rightX - nextPointWidth - 2, prevY - (int)this.scrollAmount, nextY - (int)this.scrollAmount, List.of(Component.m_237113_((String)(this.data.level() >= ClientConfigStore.INSTANCE.maxLevel ? "MAX LEVEL!" : String.format("%.1f%% (%d/%d kills)", Float.valueOf(splitFactor * 100.0f), acquiredKillsForNextPoint, neededKillsForNextPoint))))));
        return nextY;
    }

    @Override
    public void renderContentButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.leaderboardButton.setYClip(this.y + 3, this.y + this.height - 3);
        this.leaderboardButton.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        if (!this.enableSpecialBuffs) {
            return;
        }
        if (this.clearPointsButton != null) {
            this.clearPointsButton.setYClip(this.y + 3, this.y + this.height - 3);
            this.clearPointsButton.setActive(this.data.remainingPoints() != this.data.totalPoints());
            this.clearPointsButton.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        }
        for (Map.Entry<SpecialBuff<?>, CustomButton> entry : this.specialBuffButtons.entrySet()) {
            MutableComponent tooltip = null;
            CustomButton button = entry.getValue();
            button.setYClip(this.y + 3, this.y + this.height - 3);
            button.setActive(true);
            if (this.data.spentPoints().getOrDefault(entry.getKey().getId(), 0) >= entry.getKey().getMaxLevel()) {
                button.setActive(false);
                tooltip = Component.m_237113_((String)"Already max level");
            }
            if (this.data.remainingPoints() <= 0) {
                button.setActive(false);
                tooltip = Component.m_237113_((String)"No points to spend");
            }
            button.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
            if (button.f_93623_ && this.data.remainingPoints() == this.data.totalPoints()) {
                tooltip = Component.m_237113_((String)"Click to spend point");
            }
            if (tooltip == null) continue;
            this.tooltips.add(new BestiaryTooltip(button.m_252754_(), button.m_252754_() + button.m_5711_() - 1, Math.max(button.m_252907_(), this.y + 3), Math.min(button.m_252907_() + button.m_93694_(), this.y + this.height - 3), List.of(tooltip)));
        }
    }

    @Override
    public Set<BestiaryTooltip> getTooltips() {
        return this.tooltips;
    }

    public Collection<CustomButton> getButtons() {
        return this.specialBuffButtons.values();
    }

    private int scaled(int coordinate, float scale) {
        return (int)((float)coordinate / scale);
    }

    private int drawCenteredComponentWrapped(GuiGraphics guiGraphics, FormattedText text, int minX, int maxX, int y) {
        List wrappedText = FONT.m_92923_(text, maxX - minX);
        int nextY = y;
        for (FormattedCharSequence line : wrappedText) {
            int n = (minX + maxX) / 2;
            Objects.requireNonNull(FONT);
            guiGraphics.m_280364_(FONT, line, n, nextY += 9, 0xFFFFFF);
        }
        return nextY + 2;
    }

    private int drawCenteredComponentWrapped(GuiGraphics guiGraphics, FormattedText text, int minX, int maxX, int y, int color) {
        List wrappedText = FONT.m_92923_(text, maxX - minX);
        int nextY = y;
        for (FormattedCharSequence line : wrappedText) {
            int n = (minX + maxX) / 2;
            Objects.requireNonNull(FONT);
            guiGraphics.m_280364_(FONT, line, n, nextY += 9, color);
        }
        return nextY + 2;
    }

    private int drawComponentWrapped(GuiGraphics guiGraphics, FormattedText text, int minX, int maxX, int y) {
        List wrappedText = FONT.m_92923_(text, maxX - minX);
        int nextY = y;
        for (FormattedCharSequence line : wrappedText) {
            Objects.requireNonNull(FONT);
            guiGraphics.m_280648_(FONT, line, minX, nextY += 9, 0xFFFFFF);
        }
        return nextY + 2;
    }

    private int drawComponentWrapped(GuiGraphics guiGraphics, FormattedText text, int minX, int maxX, int y, int color) {
        List wrappedText = FONT.m_92923_(text, maxX - minX);
        int nextY = y;
        for (FormattedCharSequence line : wrappedText) {
            Objects.requireNonNull(FONT);
            guiGraphics.m_280648_(FONT, line, minX, nextY += 9, color);
        }
        return nextY + 2;
    }

    private int getComponentWrappedHeight(FormattedText text, int width, float scale) {
        List wrappedText = FONT.m_92923_(text, (int)((float)width / scale));
        int n = wrappedText.size();
        Objects.requireNonNull(FONT);
        return (int)((float)(n * 9 + 2) * scale);
    }

    private int drawLevelBar(GuiGraphics guiGraphics, int x1, int x2, int y, float splitFactor) {
        int leftMiddleBlit = x1 + 8;
        int rightMiddleBlit = x2 - 8;
        int barWidth = x2 - x1;
        int blitSplit = x1 + Math.round((float)barWidth * splitFactor);
        int uvSplit = Math.round((float)(blitSplit - x1) / (float)barWidth * 212.0f);
        if (blitSplit < leftMiddleBlit) {
            guiGraphics.m_280163_(LEVEL_BAR_COMPLETED_TEXTURE, x1, y, 0.0f, 0.0f, uvSplit + 3, 8, 212, 8);
            guiGraphics.m_280163_(LEVEL_BAR_BACKGROUND_TEXTURE, blitSplit - 1, y, blitSplit <= x1 + 1 ? 0.0f : (float)uvSplit, 0.0f, leftMiddleBlit - blitSplit + 1, 8, 212, 8);
            guiGraphics.blitRepeating(LEVEL_BAR_BACKGROUND_TEXTURE, leftMiddleBlit, y, rightMiddleBlit - leftMiddleBlit, 8, 8, 0, 196, 8, 212, 8);
            guiGraphics.m_280163_(LEVEL_BAR_BACKGROUND_TEXTURE, rightMiddleBlit, y, 204.0f, 0.0f, 8, 8, 212, 8);
        } else if (blitSplit < rightMiddleBlit) {
            guiGraphics.m_280163_(LEVEL_BAR_COMPLETED_TEXTURE, x1, y, 0.0f, 0.0f, 8, 8, 212, 8);
            guiGraphics.blitRepeating(LEVEL_BAR_COMPLETED_TEXTURE, leftMiddleBlit, y, blitSplit - leftMiddleBlit, 8, 8, 0, 196, 8, 212, 8);
            guiGraphics.blitRepeating(LEVEL_BAR_BACKGROUND_TEXTURE, blitSplit - 1, y, rightMiddleBlit - blitSplit + 1, 8, 8, 0, 196, 8, 212, 8);
            guiGraphics.m_280163_(LEVEL_BAR_BACKGROUND_TEXTURE, rightMiddleBlit, y, 204.0f, 0.0f, 8, 8, 212, 8);
        } else {
            guiGraphics.m_280163_(LEVEL_BAR_COMPLETED_TEXTURE, x1, y, 0.0f, 0.0f, 8, 8, 212, 8);
            guiGraphics.blitRepeating(LEVEL_BAR_COMPLETED_TEXTURE, leftMiddleBlit, y, rightMiddleBlit - leftMiddleBlit, 8, 8, 0, 196, 8, 212, 8);
            guiGraphics.m_280163_(LEVEL_BAR_COMPLETED_TEXTURE, rightMiddleBlit, y, 204.0f, 0.0f, blitSplit - rightMiddleBlit, 8, 212, 8);
            guiGraphics.m_280163_(LEVEL_BAR_BACKGROUND_TEXTURE, blitSplit - 1, y, (float)uvSplit, 0.0f, x2 - blitSplit + 1, 8, 212, 8);
        }
        return y + this.getLevelBarHeight();
    }

    private int getLevelBarHeight() {
        return 8;
    }

    @Override
    public int getNeededHeight() {
        int y = 0;
        y += (int)(69.0f * (float)this.availableWidth / 212.0f);
        y += 4;
        y += 14;
        if (this.enableSpecialBuffs) {
            if (this.data.level() >= this.levelsPerPoint) {
                y += this.getPointsSectionHeight();
            }
            y += 4;
            y += this.getLevelBarHeight();
        }
        return y + 1;
    }

    public int getPointsSectionHeight() {
        int y = 4;
        y += this.getComponentWrappedHeight((FormattedText)Component.m_237113_((String)String.format("%d point%s to spend", this.data.remainingPoints(), this.data.remainingPoints() == 1 ? "" : "s")), this.availableWidth, 1.0f);
        y += 4;
        for (Map.Entry<SpecialBuff<?>, Integer> entry : this.orderedBuffs.entrySet()) {
            y += Math.max(28, this.getComponentWrappedHeight((FormattedText)Component.m_237113_((String)String.format("%s %s", entry.getKey().getDisplayName(), RomanUtil.toRoman(entry.getValue()))), this.availableWidth, 2.0f));
            y += 4;
            y += this.getComponentWrappedHeight((FormattedText)Component.m_237113_((String)entry.getKey().getInfo(entry.getValue())), this.availableWidth, 1.0f);
        }
        return y += 12;
    }

    @Override
    public boolean handleContentClick(double mouseX, double mouseY, int button) {
        if (this.clearPointsButton != null && this.clearPointsButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.leaderboardButton != null && this.leaderboardButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (CustomButton btn : this.specialBuffButtons.values()) {
            if (!btn.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getMobId() {
        return this.mobId;
    }
}

