/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollBarWidget
extends AbstractWidget {
    private final int trackHeight;
    private int thumbHeight;
    private float scrollAmount;
    private boolean dragging = false;
    private boolean canDrag = true;
    private final Consumer<Float> onScrollChanged;
    private final int trackColor;
    private final int trackColorHovered;
    private final int thumbColor;
    private final int thumbColorHovered;

    public ScrollBarWidget(int x, int y, int width, int height, Component message, int thumbHeight, Consumer<Float> onScrollChanged, int trackColor, int trackColorHovered, int thumbColor, int thumbColorHovered) {
        super(x, y, width, height, message);
        this.trackHeight = height;
        this.thumbHeight = thumbHeight;
        this.scrollAmount = 0.0f;
        this.onScrollChanged = onScrollChanged;
        this.trackColor = trackColor;
        this.trackColorHovered = trackColorHovered;
        this.thumbColor = thumbColor;
        this.thumbColorHovered = thumbColorHovered;
    }

    public ScrollBarWidget(int x, int y, int width, int height, Component message, int thumbHeight, Consumer<Float> onScrollChanged) {
        super(x, y, width, height, message);
        this.trackHeight = height;
        this.thumbHeight = thumbHeight;
        this.scrollAmount = 0.0f;
        this.onScrollChanged = onScrollChanged;
        this.trackColor = 0;
        this.trackColorHovered = 0x44FFFFFF;
        this.thumbColor = -1996488705;
        this.thumbColorHovered = -570425345;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int youseY, float partialTick) {
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.f_93622_ || this.dragging ? this.trackColorHovered : this.trackColor);
        int thumbY = this.thumbTopY();
        guiGraphics.m_280509_(this.m_252754_(), thumbY, this.m_252754_() + this.f_93618_, thumbY + this.thumbHeight, this.f_93622_ || this.dragging ? this.thumbColorHovered : this.thumbColor);
    }

    public int thumbTopY() {
        return this.m_252907_() + (int)((float)(this.trackHeight - this.thumbHeight) * this.scrollAmount);
    }

    public int thumbBottomY() {
        return this.thumbTopY() + this.thumbHeight;
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public void setThumbHeight(int thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public void setScrollAmount(float normalized) {
        this.scrollAmount = Mth.m_14036_((float)normalized, (float)0.0f, (float)1.0f);
        this.onScrollChanged.accept(Float.valueOf(this.scrollAmount));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_) {
            return false;
        }
        if (this.m_5953_(mouseX, mouseY) && button == 0) {
            float perFrameStaticScroll = (float)this.thumbHeight / (float)this.trackHeight / 15.0f;
            if (mouseY > (double)this.thumbBottomY()) {
                this.setScrollAmount(this.scrollAmount + perFrameStaticScroll);
                this.canDrag = false;
            } else if (mouseY < (double)this.thumbTopY()) {
                this.setScrollAmount(this.scrollAmount - perFrameStaticScroll);
                this.canDrag = false;
            } else {
                this.dragging = true;
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_) {
            return false;
        }
        if (button == 0) {
            this.dragging = false;
            this.canDrag = true;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.f_93624_ || this.trackHeight == this.thumbHeight) {
            return false;
        }
        if (this.dragging && this.canDrag) {
            double normalizedDrag = dragY / (double)(this.trackHeight - this.thumbHeight);
            this.setScrollAmount(this.scrollAmount + (float)normalizedDrag);
            return true;
        }
        return false;
    }
}

