/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.luko.bestia.Bestia;

public class FormulaParser {
    public static String VAR = "L";

    public static double evaluate(String formula, double var) {
        List<String> tokens = FormulaParser.tokenize(formula);
        List<String> rpn = FormulaParser.toRPN(tokens);
        return FormulaParser.evalRPN(rpn, var);
    }

    private static List<String> tokenize(String formula) {
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 0;
        Object prevToken = null;
        while (i < formula.length()) {
            char c = formula.charAt(i);
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            Object token = null;
            if ("+-*/^()".indexOf(c) >= 0) {
                token = "" + c;
                ++i;
            } else if (Character.isDigit(c) || c == '.') {
                start = i;
                while (i < formula.length() && (Character.isDigit(formula.charAt(i)) || formula.charAt(i) == '.')) {
                    ++i;
                }
                token = formula.substring(start, i);
            } else if (Character.isLetter(c)) {
                start = i;
                while (i < formula.length() && Character.isLetter(formula.charAt(i))) {
                    ++i;
                }
                token = formula.substring(start, i);
            } else {
                FormulaParser.error("Unexpected character: " + c);
            }
            if (prevToken != null) {
                boolean currentIsValue;
                boolean prevIsValue = ((String)prevToken).matches("\\d+(\\.\\d+)?") || ((String)prevToken).matches("[a-zA-Z]+") || ((String)prevToken).equals(")");
                boolean bl = currentIsValue = ((String)token).matches("\\d+(\\.\\d+)?") || ((String)token).matches("[a-zA-Z]+") || ((String)token).equals("(");
                if (prevIsValue && currentIsValue) {
                    tokens.add("*");
                }
            }
            tokens.add((String)token);
            prevToken = token;
        }
        return tokens;
    }

    private static List<String> toRPN(List<String> tokens) {
        ArrayList<String> output = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        Map<String, Integer> precedence = Map.of("+", 1, "-", 1, "*", 2, "/", 2, "u-", 3, "^", 4);
        String prev = null;
        for (String token : tokens) {
            if (token.matches("\\d+(\\.\\d+)?") || token.equals(VAR)) {
                output.add(token);
            } else if (precedence.containsKey(token)) {
                if (token.equals("-") && (prev == null || precedence.containsKey(prev) || prev.equals("("))) {
                    token = "u-";
                }
                while (!stack.isEmpty() && precedence.containsKey(stack.peek()) && FormulaParser.shouldPop(token, (String)stack.peek(), precedence)) {
                    output.add((String)stack.pop());
                }
                stack.push(token);
            } else if (token.equals("(")) {
                stack.push(token);
            } else if (token.equals(")")) {
                while (!stack.isEmpty() && !((String)stack.peek()).equals("(")) {
                    output.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    FormulaParser.error("Mismatched parenthesis in formula: " + String.valueOf(tokens));
                }
                stack.pop();
            } else {
                FormulaParser.error("Unknown token in formula: " + token);
            }
            prev = token;
        }
        while (!stack.isEmpty()) {
            if (((String)stack.peek()).equals("(") || ((String)stack.peek()).equals(")")) {
                FormulaParser.error("Mismatched parenthesis in formula: " + String.valueOf(tokens));
            }
            output.add((String)stack.pop());
        }
        return output;
    }

    private static boolean shouldPop(String token, String top, Map<String, Integer> precedence) {
        if (token.equals("^") || token.equals("u-")) {
            return precedence.get(token) < precedence.get(top);
        }
        return precedence.get(token) <= precedence.get(top);
    }

    private static double evalRPN(List<String> rpn, double var) {
        Stack<Double> stack = new Stack<Double>();
        block14: for (String token : rpn) {
            if (token.matches("\\d+(\\.\\d+)?")) {
                stack.push(Double.parseDouble(token));
                continue;
            }
            if (token.equals(VAR)) {
                stack.push(var);
                continue;
            }
            if (token.equals("u-")) {
                if (stack.isEmpty()) {
                    FormulaParser.error("Invalid expression: unary minus without value");
                }
                double a = (Double)stack.pop();
                stack.push(-a);
                continue;
            }
            if (stack.size() < 2) {
                FormulaParser.error("Invalid expression: insufficient values for operator " + token);
            }
            double b = (Double)stack.pop();
            double a = (Double)stack.pop();
            switch (token) {
                case "+": {
                    stack.push(a + b);
                    continue block14;
                }
                case "-": {
                    stack.push(a - b);
                    continue block14;
                }
                case "*": {
                    stack.push(a * b);
                    continue block14;
                }
                case "/": {
                    stack.push(a / b);
                    continue block14;
                }
                case "^": {
                    stack.push(Math.pow(a, b));
                    continue block14;
                }
            }
            FormulaParser.error("Unknown operator: " + token);
        }
        if (stack.size() != 1) {
            FormulaParser.error("Invalid expression: leftover values in stack -> " + String.valueOf(stack));
        }
        return (Double)stack.pop();
    }

    private static void error(String e) {
        Bestia.LOGGER.error(e);
        throw new RuntimeException(e);
    }
}

