/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sillwd;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.sillwd.init.SillwdModBlocks;
import net.mcreator.sillwd.init.SillwdModEntities;
import net.mcreator.sillwd.init.SillwdModFluidTypes;
import net.mcreator.sillwd.init.SillwdModFluids;
import net.mcreator.sillwd.init.SillwdModItems;
import net.mcreator.sillwd.init.SillwdModMobEffects;
import net.mcreator.sillwd.init.SillwdModSounds;
import net.mcreator.sillwd.init.SillwdModTabs;
import net.mcreator.sillwd.init.SillwdModVillagerProfessions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sillwd")
public class SillwdMod {
    public static final Logger LOGGER = LogManager.getLogger(SillwdMod.class);
    public static final String MODID = "sillwd";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sillwd", "sillwd"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SillwdMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SillwdModSounds.REGISTRY.register(bus);
        SillwdModBlocks.REGISTRY.register(bus);
        SillwdModItems.REGISTRY.register(bus);
        SillwdModEntities.REGISTRY.register(bus);
        SillwdModTabs.REGISTRY.register(bus);
        SillwdModMobEffects.REGISTRY.register(bus);
        SillwdModVillagerProfessions.PROFESSIONS.register(bus);
        SillwdModFluids.REGISTRY.register(bus);
        SillwdModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

