/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pale_hound.entities.goals;

import de.cadentem.pale_hound.config.ServerConfig;
import de.cadentem.pale_hound.entities.PaleHoundEntity;
import de.cadentem.pale_hound.entities.goals.Roll;
import de.cadentem.pale_hound.util.Utils;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class PaleHoundChaseGoal
extends Goal {
    private final PaleHoundEntity paleHound;
    private final int maxSpeedReached;
    private final boolean followTargetEvenIfNotSeen;
    private LivingEntity previousTarget;
    private long lastGameTimeCheck;
    private int ticksUntilLeave;
    private int ticksUntilNextAttack;
    private int speedUp;

    public PaleHoundChaseGoal(PaleHoundEntity paleHound, boolean followTargetEvenIfNotSeen) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.paleHound = paleHound;
        this.followTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.ticksUntilLeave = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE_CHASE.get());
        this.maxSpeedReached = Utils.secondsToTicks(3);
    }

    public boolean m_8036_() {
        boolean canAttack;
        if (this.paleHound.m_20145_()) {
            return false;
        }
        if (this.paleHound.currentRoll != Roll.CHASE) {
            return false;
        }
        if (!this.paleHound.targetIsFacingMe) {
            return false;
        }
        long ticks = this.paleHound.f_19853_.m_46467_();
        if (ticks - this.lastGameTimeCheck < 20L) {
            return false;
        }
        this.lastGameTimeCheck = ticks;
        LivingEntity target = this.paleHound.m_5448_();
        if (!Utils.isValidTarget((Entity)target)) {
            return false;
        }
        Path path = this.paleHound.m_21573_().m_6570_((Entity)target, 0);
        if (path != null) {
            return true;
        }
        boolean bl = canAttack = this.getAttackReachSqr(target) >= this.paleHound.m_20280_((Entity)target);
        if (canAttack) {
            return true;
        }
        path = this.paleHound.m_21573_().m_6570_((Entity)target, 0);
        return path != null;
    }

    public boolean m_8045_() {
        LivingEntity target = this.paleHound.m_5448_();
        if (!Utils.isValidTarget((Entity)target)) {
            if (target == null && this.previousTarget instanceof Player) {
                this.paleHound.disappear();
            }
            return false;
        }
        this.previousTarget = target;
        if (!this.followTargetEvenIfNotSeen) {
            return !this.paleHound.m_21573_().m_26571_();
        }
        return this.paleHound.m_21444_(target.m_20183_());
    }

    public void m_8056_() {
        this.paleHound.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.paleHound.m_5448_();
        if (!Utils.isValidTarget((Entity)target)) {
            this.paleHound.m_6710_(null);
        }
        this.speedUp = 0;
        this.previousTarget = null;
        this.paleHound.m_21561_(false);
        this.paleHound.m_20088_().m_135381_(PaleHoundEntity.CRAWLING_ACCESSOR, (Object)false);
        this.paleHound.m_21573_().m_26573_();
        this.paleHound.m_6210_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean targetMoved;
        LivingEntity target;
        if (this.ticksUntilLeave <= 0 && !this.paleHound.targetIsFacingMe) {
            this.paleHound.disappear();
        }
        if (!Utils.isValidTarget((Entity)(target = this.paleHound.m_5448_()))) {
            return;
        }
        Path path = this.paleHound.m_21573_().m_26570_();
        this.fixPath(path);
        boolean bl = targetMoved = path != null && path.m_77395_() != null && path.m_77395_().m_164697_(target.m_20183_()) > 2.0f;
        if (path == null || this.paleHound.m_21573_().m_26577_() || targetMoved || path.m_77392_() && !this.shouldClimb(path) || this.paleHound.m_21573_().m_200903_(target.m_20183_()) && this.paleHound.f_19797_ % 20 == 0) {
            path = this.paleHound.m_21573_().m_6570_((Entity)target, 0);
            this.fixPath(path);
        }
        if (path != null && !path.m_77392_() && this.paleHound.m_142582_((Entity)target)) {
            this.paleHound.playChaseSound();
        }
        this.paleHound.m_21573_().m_26536_(path, this.paleHound.getSpeedModifier());
        if (!this.paleHound.isCrawling()) {
            if (this.paleHound.m_5912_()) {
                this.paleHound.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
            } else {
                this.paleHound.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        double distance = this.paleHound.m_20280_((Entity)target);
        this.checkAndPerformAttack(target, distance);
        --this.ticksUntilLeave;
        if (this.speedUp < this.maxSpeedReached) {
            ++this.speedUp;
        }
    }

    private void fixPath(Path path) {
        LivingEntity target = this.paleHound.m_5448_();
        if (target == null) {
            return;
        }
        if (this.shouldClimb(path) && (double)path.m_77375_(0).m_164697_(this.paleHound.m_5448_().m_20183_()) > 0.1) {
            path.m_77377_(0, path.m_77375_(0).m_77289_(target.m_20183_().m_123341_(), target.m_20183_().m_123342_(), target.m_20183_().m_123343_()));
        }
    }

    private boolean shouldClimb(Path path) {
        if (this.paleHound.m_5448_() == null) {
            return false;
        }
        return path != null && path.m_77398_() == 1 && (float)this.paleHound.m_5448_().m_20183_().m_123342_() > (float)this.paleHound.m_20183_().m_123342_() + this.paleHound.getStepHeight();
    }

    private void checkAndPerformAttack(LivingEntity target, double distanceToTarget) {
        double attackReach = this.getAttackReachSqr(target);
        if (distanceToTarget <= attackReach && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.paleHound.m_6674_(InteractionHand.MAIN_HAND);
            this.paleHound.m_7327_((Entity)target);
        }
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    private double getAttackReachSqr(LivingEntity target) {
        return this.paleHound.m_20205_() * 4.0f * this.paleHound.m_20205_() * 4.0f + target.m_20205_();
    }
}

