/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pale_hound.entities.goals;

import de.cadentem.pale_hound.entities.PaleHoundEntity;
import de.cadentem.pale_hound.entities.goals.Roll;
import de.cadentem.pale_hound.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class PaleHoundStareGoal
extends Goal {
    private final PaleHoundEntity paleHound;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public PaleHoundStareGoal(PaleHoundEntity paleHound) {
        this.paleHound = paleHound;
        this.lookedAtMax = paleHound.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.paleHound.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.paleHound.m_5448_())) {
            return false;
        }
        return this.paleHound.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.paleHound.m_5448_())) {
            return false;
        }
        return this.paleHound.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.paleHound.pleaseStopMoving = false;
        this.paleHound.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.paleHound.m_5448_();
        if (target == null) {
            this.paleHound.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.paleHound.targetIsFacingMe && target.m_142582_((Entity)this.paleHound);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.paleHound.m_217043_().m_188500_() < 0.1) {
                this.paleHound.disappear();
            } else if (this.paleHound.m_217043_().m_188500_() < 0.3) {
                this.paleHound.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.paleHound.pleaseStopMoving = false;
            this.paleHound.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.paleHound.pleaseStopMoving = true;
            this.paleHound.m_21573_().m_26573_();
            this.paleHound.m_20256_(Vec3.f_82478_);
        }
        this.paleHound.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

