/*
 * Decompiled with CFR 0.152.
 */
package com.plummetstudios.gatorcountry.block;

import com.plummetstudios.gatorcountry.block.custom.GatorEggBlock;
import com.plummetstudios.gatorcountry.block.custom.ModFlammableRotatedPillarBlock;
import com.plummetstudios.gatorcountry.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"gatorcountry");
    public static final RegistryObject<Block> GATOR_NEST_BLOCK = ModBlocks.registerBlock("gator_nest_block", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60918_(SoundType.f_154672_)), CreativeModeTab.f_40749_);
    public static final RegistryObject<Block> GATOR_EGG = ModBlocks.registerBlock("gator_egg", GatorEggBlock::new, CreativeModeTab.f_40753_);
    public static final RegistryObject<Block> GATOR_MEAT_BLOCK = ModBlocks.registerBlock("gator_meat_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.6f).m_60918_(SoundType.f_154660_)), CreativeModeTab.f_40753_);
    public static final RegistryObject<Block> GATOR_SLAB = ModBlocks.registerBlock("gator_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.6f).m_60918_(SoundType.f_154660_)), CreativeModeTab.f_40755_);

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

