/*
 * Decompiled with CFR 0.152.
 */
package com.plummetstudios.gatorcountry.entity.custom;

import com.plummetstudios.gatorcountry.block.ModBlocks;
import com.plummetstudios.gatorcountry.block.custom.GatorEggBlock;
import com.plummetstudios.gatorcountry.entity.custom.ai.BaskingGoal;
import com.plummetstudios.gatorcountry.item.ModItems;
import com.plummetstudios.gatorcountry.sound.ModSounds;
import com.plummetstudios.gatorcountry.tag.ModTags;
import java.util.Random;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class AlligatorEntity
extends Animal
implements IAnimatable {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(ModTags.ItemTags.ALLIGATOR_FOOD_ITEMS);
    private final Random rand = new Random();
    private int ticksSinceLastDecrement;
    UUID playerUUID;
    int baskingCooldownTimer;
    private int grabCooldown = 0;
    private static final ResourceLocation NORMAL_LOOT_TABLE = new ResourceLocation("gatorcountry:entities/alligator_normal");
    private static final ResourceLocation STRESSED_LOOT_TABLE = new ResourceLocation("gatorcountry:entities/alligator_stressed");
    private static final ResourceLocation HAPPY_LOOT_TABLE = new ResourceLocation("gatorcountry:entities/alligator_happy");
    private static final EntityDataAccessor<Boolean> basking = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TARGETING = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DIGGING = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> hunger = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> happinessMeter = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> attackMob = SynchedEntityData.m_135353_(AlligatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public AlligatorEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.setGatorTexture();
        this.setBaskingCooldownTimer(1000 + this.rand.nextInt(1000));
        this.setHappinessMeter(70);
    }

    public void setGatorTexture() {
        float changeVariant = this.m_217043_().m_188501_();
        if ((double)changeVariant < 0.03) {
            this.setVariant(2);
        } else if ((double)changeVariant < 0.35) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
    }

    public int getBaskingCooldownTimer() {
        return this.baskingCooldownTimer;
    }

    public void setBaskingCooldownTimer(int newTime) {
        this.baskingCooldownTimer = newTime;
        if (newTime <= 0) {
            // empty if block
        }
    }

    public int getHappinessMeter() {
        return (Integer)this.f_19804_.m_135370_(happinessMeter);
    }

    public void setHappinessMeter(int phappinessMeter) {
        this.f_19804_.m_135381_(happinessMeter, (Object)phappinessMeter);
    }

    public boolean getTargeting() {
        return (Boolean)this.f_19804_.m_135370_(TARGETING);
    }

    public void setTargeting(boolean pTargeting) {
        this.f_19804_.m_135381_(TARGETING, (Object)pTargeting);
    }

    public String getAttackMob() {
        return (String)this.f_19804_.m_135370_(attackMob);
    }

    public void setAttackMob(String pAttackMob) {
        this.f_19804_.m_135381_(attackMob, (Object)pAttackMob);
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(hunger);
    }

    public void setHunger(int phappinessMeter) {
        this.f_19804_.m_135381_(hunger, (Object)phappinessMeter);
    }

    public boolean getBasking() {
        return (Boolean)this.f_19804_.m_135370_(basking);
    }

    public void setBasking(boolean baskingState) {
        this.f_19804_.m_135381_(basking, (Object)baskingState);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.f_19804_.m_135381_(IS_DIGGING, (Object)isDigging);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(basking, (Object)false);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(IS_DIGGING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(happinessMeter, (Object)70);
        this.f_19804_.m_135372_(hunger, (Object)0);
        this.f_19804_.m_135372_(TARGETING, (Object)false);
        this.f_19804_.m_135372_(attackMob, (Object)"none");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        if (this.playerUUID != null) {
            compound.m_128362_("playerUUID", this.playerUUID);
        }
        compound.m_128405_("happinessMeter", this.getHappinessMeter());
        compound.m_128405_("ticksSinceLastDecrement", this.ticksSinceLastDecrement);
        compound.m_128405_("baskingCooldownTimer", this.getBaskingCooldownTimer());
        compound.m_128379_("HasEgg", this.hasEgg());
        compound.m_128379_("TARGETING", this.getTargeting());
        compound.m_128405_("hunger", this.getHunger());
        compound.m_128359_("attackMob", this.getAttackMob());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHappinessMeter(compound.m_128451_("happinessMeter"));
        this.setHunger(compound.m_128451_("hunger"));
        this.ticksSinceLastDecrement = compound.m_128451_("ticksSinceLastDecrement");
        this.setBaskingCooldownTimer(compound.m_128451_("baskingCooldownTimer"));
        this.setHasEgg(compound.m_128471_("HasEgg"));
        this.setTargeting(compound.m_128471_("TARGETING"));
        this.setVariant(compound.m_128451_("Variant"));
        this.setAttackMob(compound.m_128461_("attackMob"));
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 16.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, (double)0.9f).m_22268_(Attributes.f_22283_, 0.5).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    public float getStepHeight() {
        return 1.2f;
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(ModTags.ItemTags.ALLIGATOR_FOOD_ITEMS), false));
        this.f_21345_.m_25352_(1, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1){

            public boolean m_8036_() {
                return AlligatorEntity.this.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7){

            public boolean m_8036_() {
                return AlligatorEntity.this.m_20096_() && !AlligatorEntity.this.getBasking() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new BaskingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public void m_8056_() {
                super.m_8056_();
                AlligatorEntity.this.setTargeting(true);
            }

            public void m_8041_() {
                super.m_8041_();
                AlligatorEntity.this.setTargeting(false);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, entity -> !this.m_6162_() && entity.m_6095_().m_204039_(ModTags.EntityTypes.ALLIGATOR_PREY)){

            public boolean m_8036_() {
                return AlligatorEntity.this.getHunger() == 0 && super.m_8036_();
            }

            public void m_8041_() {
                super.m_8041_();
                Random rand = new Random();
                AlligatorEntity.this.setHappinessMeter(AlligatorEntity.this.getHappinessMeter() + 15);
                AlligatorEntity.this.setHunger(1000 + rand.nextInt(1000));
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Skeleton>((Mob)this, Skeleton.class, 10, true, false, entity -> !this.m_6162_()){

            public boolean m_8036_() {
                return AlligatorEntity.this.getAttackMob() == "skeleton" && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Zombie>((Mob)this, Zombie.class, 10, true, false, entity -> !this.m_6162_()){

            public boolean m_8036_() {
                return AlligatorEntity.this.getAttackMob() == "zombie" && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, 10, true, false, entity -> !this.m_6162_() && !entity.m_20148_().equals(this.playerUUID)){

            public boolean m_8036_() {
                return AlligatorEntity.this.getAttackMob() == "player" && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> !this.m_6162_() && entity.m_20069_()));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<WitherSkeleton>((Mob)this, WitherSkeleton.class, 10, true, false, entity -> !this.m_6162_()){

            public boolean m_8036_() {
                return AlligatorEntity.this.getAttackMob() == "wither_skeleton" && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Creeper>((Mob)this, Creeper.class, 10, true, false, entity -> !this.m_6162_()){

            public boolean m_8036_() {
                return AlligatorEntity.this.getAttackMob() == "creeper" && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, entity -> !this.m_6162_() && !entity.m_20148_().equals(this.playerUUID) && !(entity instanceof AlligatorEntity)){

            public boolean m_8036_() {
                return AlligatorEntity.this.getAttackMob() == "all" && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, entity -> !this.m_6162_() && !entity.m_20148_().equals(this.playerUUID)){

            public boolean m_8036_() {
                return AlligatorEntity.this.getHappinessMeter() == 0 && super.m_8036_();
            }
        });
    }

    public int gatorTexture() {
        return this.getVariant();
    }

    private boolean shouldUpdate(int interval) {
        if (this.ticksSinceLastDecrement >= interval) {
            this.ticksSinceLastDecrement = 0;
            return true;
        }
        ++this.ticksSinceLastDecrement;
        return false;
    }

    public void m_8119_() {
        boolean flag;
        super.m_8119_();
        if (this.grabCooldown > 0) {
            --this.grabCooldown;
        }
        if (this.m_5448_() != null && this.grabCooldown <= 0 && this.m_20270_((Entity)this.m_5448_()) < 3.5f && this.m_142582_((Entity)this.m_5448_()) && !(flag = this.m_5448_().m_21254_()) && this.m_5448_().m_20205_() < this.m_20205_() && this.m_20197_().isEmpty() && !this.m_5448_().m_6144_()) {
            this.m_5448_().m_7998_((Entity)this, true);
            this.grabCooldown = 75;
        }
        if (this.getBaskingCooldownTimer() > 0) {
            this.setBaskingCooldownTimer(this.getBaskingCooldownTimer() - 1);
        }
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
        if (this.shouldUpdate(400)) {
            this.updateHappiness();
        }
        if (!this.m_20197_().isEmpty()) {
            this.m_21573_().m_26573_();
        }
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20197_().isEmpty()) {
            this.f_20883_ = Mth.m_14177_((float)(this.m_146908_() - 180.0f));
        }
        if (this.m_20363_(passenger)) {
            float radius = 2.0f;
            double angleRadians = Math.toRadians(this.f_20883_);
            double extraX = 2.0 * Math.sin(Math.PI + angleRadians);
            double extraZ = 2.0 * Math.cos(angleRadians);
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + (double)0.1f, this.m_20189_() + extraZ);
        }
    }

    private void updateHappiness() {
        BlockPos blockPos = this.m_20183_();
        Biome biome = (Biome)this.f_19853_.m_204166_(blockPos).m_203334_();
        if (!this.f_19853_.m_45527_(blockPos)) {
            this.setHappinessMeter(this.getHappinessMeter() - 5);
        } else if (!this.isInWarmBiome()) {
            this.setHappinessMeter(this.getHappinessMeter() - 10);
        } else {
            this.setHappinessMeter(this.getHappinessMeter() + 10);
        }
    }

    protected ResourceLocation m_7582_() {
        if (this.getHappinessMeter() > 75) {
            return HAPPY_LOOT_TABLE;
        }
        if (this.getHappinessMeter() < 25) {
            return STRESSED_LOOT_TABLE;
        }
        return NORMAL_LOOT_TABLE;
    }

    private boolean isInWarmBiome() {
        int k;
        int j;
        int i = Mth.m_14107_((double)this.m_20185_());
        BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)this.m_20186_()), k = Mth.m_14107_((double)this.m_20189_()));
        Biome biome = (Biome)this.f_19853_.m_204166_(blockpos).m_203334_();
        return !biome.m_198904_(blockpos);
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "thrashingcontroller", 0.0f, this::thrashingpredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.getController().getCurrentAnimation() != null) {
            // empty if block
        }
        System.out.println(this.getTargeting());
        if (this.getTargeting() && event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.charge", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(1.6);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.m_20069_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.swimidle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                event.getController().setAnimationSpeed(1.6);
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                event.getController().setAnimationSpeed(1.6);
            }
            return PlayState.CONTINUE;
        }
        if (this.m_20069_() && !event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.getBasking() && !event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.basking_with_mouth_open", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState thrashingpredicate(AnimationEvent<E> event) {
        if (!this.m_20197_().isEmpty() && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.alligator.thrash", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().markNeedsReload();
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20197_().isEmpty()) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    protected void m_7625_(DamageSource source, boolean attackedRecently) {
        if (source.m_7639_() instanceof AlligatorEntity) {
            return;
        }
        super.m_7625_(source, attackedRecently);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_21120_(pHand).m_41720_() == ModItems.BANJO.get()) {
            double d2;
            double d1;
            double d0;
            int i;
            for (i = 0; i < this.getHappinessMeter() / 10; ++i) {
                d0 = this.f_19796_.m_188583_() * 0.02;
                d1 = this.f_19796_.m_188583_() * 0.02;
                d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 1.0 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
            this.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12171_, SoundSource.PLAYERS, 1.0f, 0.5f + this.rand.nextFloat());
            if (this.getHappinessMeter() < 100) {
                this.setHappinessMeter(this.getHappinessMeter() + 10);
                if (this.getHappinessMeter() >= 100) {
                    if (this.getHappinessMeter() <= 200) {
                        this.setHappinessMeter(this.getHappinessMeter() + 10);
                    }
                    for (i = 0; i < 10; ++i) {
                        d0 = this.f_19796_.m_188583_() * 0.02;
                        d1 = this.f_19796_.m_188583_() * 0.02;
                        d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 1.0 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42681_ && this.getHappinessMeter() >= 100) {
            this.setAttackMob("zombie");
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12603_, SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42678_ && this.getHappinessMeter() >= 100) {
            this.setAttackMob("skeleton");
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12424_, SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42682_ && this.getHappinessMeter() >= 100) {
            this.setAttackMob("creeper");
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11835_, SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42679_ && this.getHappinessMeter() >= 100) {
            this.setAttackMob("wither_skeleton");
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12560_, SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42680_ && this.getHappinessMeter() >= 100) {
            this.setAttackMob("player");
            this.playerUUID = pPlayer.m_20148_();
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12322_, SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() == Items.f_42683_ && this.getHappinessMeter() >= 100) {
            this.setAttackMob("all");
            this.playerUUID = pPlayer.m_20148_();
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(pPlayer.m_21120_(pHand))) {
            if (!this.m_27593_()) {
                this.m_27601_(600);
                if (!pPlayer.m_7500_()) {
                    pPlayer.m_21120_(pHand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (pPlayer.m_21120_(pHand).m_41720_() == ModItems.SLAB_OF_GATOR.get()) {
            this.setHappinessMeter(0);
            for (int i = 5; i < 10; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 1.0 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
            pPlayer.f_19853_.m_5594_(null, pPlayer.m_20183_(), (SoundEvent)ModSounds.ALLIGATOR_HURT.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6063_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ALLIGATOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.ALLIGATOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ALLIGATOR_HURT.get();
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public boolean isSwampy() {
        String name = this.m_7755_() != null ? this.m_7755_().getString() : "";
        return name != null && name.toLowerCase().contains("swampy");
    }

    static class MateGoal
    extends BreedGoal {
        private final AlligatorEntity crocodile;

        MateGoal(AlligatorEntity crocodile, double speedIn) {
            super((Animal)crocodile, speedIn);
            this.crocodile = crocodile;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.crocodile.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverplayerentity = this.f_25113_.m_27592_();
            if (serverplayerentity == null && this.f_25115_.m_27592_() != null) {
                serverplayerentity = this.f_25115_.m_27592_();
            }
            if (serverplayerentity != null) {
                serverplayerentity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayerentity, this.f_25113_, this.f_25115_, (AgeableMob)this.f_25113_);
            }
            this.crocodile.setHasEgg(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                RandomSource random = this.f_25113_.m_217043_();
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final AlligatorEntity turtle;
        private int digTime;

        LayEggGoal(AlligatorEntity turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public void m_8041_() {
            this.digTime = 0;
        }

        public boolean m_8036_() {
            return this.turtle.hasEgg() && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.turtle.hasEgg();
        }

        public double m_8052_() {
            return (double)this.turtle.m_20205_() + 0.5;
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.turtle.m_20069_() && this.m_25625_()) {
                BlockPos blockpos = this.turtle.m_20183_();
                Level world = this.turtle.f_19853_;
                this.turtle.m_146850_(GameEvent.f_157797_);
                world.m_5594_(null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.m_188501_() * 0.2f);
                world.m_7731_(this.f_25602_.m_7494_(), (BlockState)((Block)ModBlocks.GATOR_EGG.get()).m_49966_().m_61124_((Property)GatorEggBlock.EGGS, (Comparable)Integer.valueOf(this.turtle.f_19796_.m_188503_(1) + 1)), 3);
                this.turtle.setHasEgg(false);
                this.turtle.setDigging(false);
                this.turtle.m_27601_(600);
            }
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            return worldIn.m_46859_(pos.m_7494_()) && GatorEggBlock.isProperHabitat((BlockGetter)worldIn, pos);
        }
    }
}

