/*
 * Decompiled with CFR 0.152.
 */
package com.plummetstudios.gatorcountry.event;

import com.plummetstudios.gatorcountry.entity.ModEntityTypes;
import com.plummetstudios.gatorcountry.entity.custom.AlligatorEntity;
import com.plummetstudios.gatorcountry.item.ModItems;
import com.plummetstudios.gatorcountry.item.custom.GatorChow;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ModEvents {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35587_) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(5)).add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)ModItems.SLAB_OF_GATOR.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 15), 10, 8, 0.02f));
        }
    }

    @Mod.EventBusSubscriber(modid="gatorcountry", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class ModEventHandlers {
        @SubscribeEvent
        public static void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack stack = event.getItemStack();
            Random rand = new Random();
            if (target instanceof TamableAnimal && ((TamableAnimal)target).m_21826_() == player && !(target instanceof Parrot) && stack.m_41720_() instanceof GatorChow) {
                if (!target.f_19853_.f_46443_) {
                    ((TamableAnimal)target).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 6000, 0));
                    ((TamableAnimal)target).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000, 0));
                    ((TamableAnimal)target).m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 2));
                    ((TamableAnimal)target).f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11945_, SoundSource.PLAYERS, 1.0f, 0.5f + rand.nextFloat());
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        ItemStack bowl = new ItemStack((ItemLike)Items.f_42399_);
                        if (!player.m_36356_(bowl)) {
                            player.m_36176_(bowl, false);
                        }
                    }
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onLootLevelEvent(LootingLevelEvent event) {
            DamageSource src = event.getDamageSource();
            if (src != null && src.m_7639_() instanceof AlligatorEntity) {
                event.setLootingLevel(event.getLootingLevel() + 20);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="gatorcountry", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModEntityTypes.Alligator.get(), AlligatorEntity.setAttributes());
        }
    }
}

