/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.common;

import com.ael.viner.Viner;
import com.ael.viner.VinerPlayerData;
import com.ael.viner.client.ClientModEvents;
import com.ael.viner.gui.ConfigScreen;
import com.ael.viner.network.VinerPacketHandler;
import com.ael.viner.network.packets.ConfigSyncPacket;
import com.ael.viner.registry.VinerBlockRegistry;
import com.ael.viner.util.MiningUtils;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="viner", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonModEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        List vineableBlocks = VinerBlockRegistry.getVineableBlocks().stream().map(block -> Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).toString()).collect(Collectors.toList());
        ConfigSyncPacket vineableBlocksPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.BLOCK_LIST, vineableBlocks, "vineableBlocks"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)vineableBlocksPacket);
        List unvineableBlocks = VinerBlockRegistry.getUnvineableBlocks().stream().map(block -> Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).toString()).collect(Collectors.toList());
        ConfigSyncPacket unvineableBlocksPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.BLOCK_LIST, unvineableBlocks, "unvineableBlocks"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)unvineableBlocksPacket);
        boolean vineAllEnabled = VinerBlockRegistry.isVineAll();
        ConfigSyncPacket vineAllPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.BOOLEAN, vineAllEnabled, "vineAll"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)vineAllPacket);
        double exhaustionPerBlock = VinerBlockRegistry.getExhaustionPerBlock();
        ConfigSyncPacket exhaustionPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.DOUBLE, exhaustionPerBlock, "exhaustionPerBlock"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)exhaustionPacket);
        int vineableLimit = VinerBlockRegistry.getVineableLimit();
        ConfigSyncPacket vineableLimitPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.INT, vineableLimit, "vineableLimit"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)vineableLimitPacket);
        int heightAbove = VinerBlockRegistry.getHeightAbove();
        ConfigSyncPacket heightAbovePacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.INT, heightAbove, "heightAbove"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)heightAbovePacket);
        int heightBelow = VinerBlockRegistry.getHeightBelow();
        ConfigSyncPacket heightBelowPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.INT, heightBelow, "heightBelow"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)heightBelowPacket);
        int widthLeft = VinerBlockRegistry.getWidthLeft();
        ConfigSyncPacket widthLeftPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.INT, widthLeft, "widthLeft"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)widthLeftPacket);
        int widthRight = VinerBlockRegistry.getWidthRight();
        ConfigSyncPacket widthRightPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.INT, widthRight, "widthRight"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)widthRightPacket);
        int layerOffset = VinerBlockRegistry.getLayerOffset();
        ConfigSyncPacket layerOffsetPacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.INT, layerOffset, "layerOffset"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)layerOffsetPacket);
        Boolean shapeVine = VinerBlockRegistry.isShapeVine();
        ConfigSyncPacket shapeVinePacket = new ConfigSyncPacket(new ConfigSyncPacket.ConfigData(ConfigSyncPacket.ConfigType.BOOLEAN, shapeVine, "shapeVine"));
        VinerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)shapeVinePacket);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ == null && ClientModEvents.VINER_CONFIG_KEY_BINDING.m_90857_()) {
                mc.m_91152_((Screen)new ConfigScreen());
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        double scrollDelta = event.getScrollDelta();
        if (scrollDelta == 0.0 || ClientModEvents.VINE_KEY_BINDING.m_90857_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (!Viner.getInstance().getPlayerRegistry().getPlayerData((Player)player).isVineKeyPressed()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        Level level = (Level)levelAccessor;
        BlockPos pos = event.getPos();
        BlockState targetBlockState = level.m_8055_(pos);
        Block block = targetBlockState.m_60734_();
        VinerPlayerData playerConfig = Viner.getInstance().getPlayerRegistry().getPlayerData((Player)player);
        boolean isShapeVine = playerConfig.isShapeVine();
        int vineableLimit = playerConfig.getVineableLimit();
        int heightAbove = playerConfig.getHeightAbove();
        int heightBelow = playerConfig.getHeightBelow();
        int widthLeft = playerConfig.getWidthLeft();
        int widthRight = playerConfig.getWidthRight();
        int layerOffset = playerConfig.getLayerOffset();
        if (MiningUtils.isVineable(block, (Player)player) && targetBlockState.canHarvestBlock((BlockGetter)level, pos, (Player)player)) {
            List<BlockPos> connectedBlocks = MiningUtils.collectConnectedBlocks(level, pos, targetBlockState, player.m_6350_().m_122436_(), vineableLimit, isShapeVine, heightAbove, heightBelow, widthLeft, widthRight, layerOffset);
            MiningUtils.mineBlocks(player, connectedBlocks);
            double exhaustionPerBlock = playerConfig.getExhaustionPerBlock();
            player.m_36324_().m_38703_((float)(exhaustionPerBlock * (double)connectedBlocks.size()));
        }
    }
}

