/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.config;

import com.ael.viner.registry.VinerBlockRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="viner", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue SHAPE_VINE;
    public static final ForgeConfigSpec.IntValue VINEABLE_LIMIT;
    public static final ForgeConfigSpec.DoubleValue EXHAUSTION_PER_BLOCK;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> VINEABLE_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> UNVINEABLE_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> VINE_ALL;
    public static final ForgeConfigSpec.IntValue HEIGHT_ABOVE;
    public static final ForgeConfigSpec.IntValue HEIGHT_BELOW;
    public static final ForgeConfigSpec.IntValue WIDTH_LEFT;
    public static final ForgeConfigSpec.IntValue WIDTH_RIGHT;
    public static final ForgeConfigSpec.IntValue LAYER_OFFSET;

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
    }

    private static void upgradeConfig() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("viner/vineable_blocks.json");
        LOGGER.info("Checking for existing config at: {}", (Object)configPath);
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                LOGGER.info("Existing config found, starting upgrade...");
                String jsonConfig = new String(Files.readAllBytes(configPath));
                Gson gson = new Gson();
                JsonObject oldConfig = (JsonObject)gson.fromJson(jsonConfig, JsonObject.class);
                ArrayList mergedBlocks = new ArrayList((Collection)VINEABLE_BLOCKS.get());
                JsonArray oldBlocks = oldConfig.getAsJsonArray("vineable_blocks");
                for (JsonElement element : oldBlocks) {
                    String blockString = element.getAsString();
                    LOGGER.debug("Processing block: {}", (Object)blockString);
                    boolean isVeinmineable = false;
                    for (String tagString : (List)VINEABLE_BLOCKS.get()) {
                        LOGGER.debug("Processing tagString: {}", (Object)tagString);
                        TagKey<Block> tagKey = VinerBlockRegistry.getTagKeyEntry(tagString);
                        LOGGER.debug("Generated tagKey: {}", tagKey);
                        ITag tag = ForgeRegistries.BLOCKS.tags().getTag(tagKey);
                        LOGGER.debug("Retrieved tag: {}", (Object)tag);
                        Block block = (Block)ForgeRegistries.BLOCKS.getValue(VinerBlockRegistry.getResourceLocationFromEntry(blockString));
                        LOGGER.debug("Retrieved block: {}", (Object)block);
                        if (tag.contains((Object)block)) {
                            LOGGER.debug("Tag {} contains block {}", (Object)tag, (Object)block);
                            isVeinmineable = true;
                            break;
                        }
                        LOGGER.debug("Tag {} does not contain block {}", (Object)tag, (Object)block);
                    }
                    if (isVeinmineable) continue;
                    LOGGER.debug("Block {} is not currently veinmineable, adding to config", (Object)blockString);
                }
                VINEABLE_BLOCKS.set(mergedBlocks);
                VINEABLE_LIMIT.set((Object)Math.max((Integer)VINEABLE_LIMIT.get(), oldConfig.get("vineable_limit").getAsInt()));
                LOGGER.info("Config upgrade complete");
            }
            catch (IOException e) {
                LOGGER.error("Error upgrading config: {}", (Object)e.getMessage());
            }
        } else {
            LOGGER.info("No existing config found, skipping upgrade");
        }
    }

    static {
        BUILDER.push("viner");
        SHAPE_VINE = BUILDER.comment("A 'true' or 'false' field to enable Shape Vine Mode.").define("shapeVine", false);
        EXHAUSTION_PER_BLOCK = BUILDER.comment("Amount of hunger added per block mined with vein mining.").defineInRange("exhaustionPerBlock", 0.25, 0.0, 20.0);
        VINEABLE_LIMIT = BUILDER.comment("Maximum number of blocks to vein mine").defineInRange("vineableLimit", 5, 1, Integer.MAX_VALUE);
        VINEABLE_BLOCKS = BUILDER.comment("List of blocks/tags that can be vein mined. Tags must start with '#'").defineList("vineableBlocks", Arrays.asList("#minecraft:ores", "#minecraft:logs", "#minecraft:leaves", "#forge:ores", "minecraft:skulk"), obj -> obj instanceof String && ((String)obj).matches("^#?[a-z_]+:[a-z_]+$"));
        UNVINEABLE_BLOCKS = BUILDER.comment("List of blocks that will not vein mined. This will override blocks from tags in VINEABLE_BLOCKS").defineList("unvineableBlocks", ArrayList::new, obj -> obj instanceof String && ((String)obj).matches("^[a-z_]+:[a-z_]+$"));
        VINE_ALL = BUILDER.comment("A 'true' or 'false' field to allow Viner to mine any block.").define("vineAll", false);
        HEIGHT_ABOVE = BUILDER.comment("(Must have SHAPE_VINE enabled) The number of blocks to mine above the starting block. This value sets how far upwards the tool mines from the starting position. Minimum is 0 (no mining above), and there is no upper limit.").defineInRange("heightAbove", 1, 0, Integer.MAX_VALUE);
        HEIGHT_BELOW = BUILDER.comment("(Must have SHAPE_VINE enabled) The number of blocks to mine below the starting block. This value sets how far downwards the tool mines from the starting position. Minimum is 0 (no mining below), and there is no upper limit.").defineInRange("heightBelow", 1, 0, Integer.MAX_VALUE);
        WIDTH_LEFT = BUILDER.comment("(Must have SHAPE_VINE enabled) The number of blocks to mine to the left of the starting block. This value sets how far to the left (from the player's perspective) the tool mines. Minimum is 0 (no mining to the left), and there is no upper limit.").defineInRange("widthLeft", 0, 0, Integer.MAX_VALUE);
        WIDTH_RIGHT = BUILDER.comment("(Must have SHAPE_VINE enabled) The number of blocks to mine to the right of the starting block. This value sets how far to the right (from the player's perspective) the tool mines. Minimum is 0 (no mining to the right), and there is no upper limit.").defineInRange("widthRight", 0, 0, Integer.MAX_VALUE);
        LAYER_OFFSET = BUILDER.comment("(Must have SHAPE_VINE enabled) The number of blocks defining the vertical distance between consecutive layers mined. Allows for staircase mining.").defineInRange("layerOffset", 0, -64, 256);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

