/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.network.packets;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPacket<T> {
    private final T data;

    public AbstractPacket(T data) {
        this.data = data;
    }

    protected T getData() {
        return this.data;
    }

    public static <T> void encode(@NotNull AbstractPacket<T> msg, @NotNull FriendlyByteBuf buf) {
        Collection collection;
        if (msg.getData() instanceof Boolean) {
            buf.writeBoolean(((Boolean)msg.getData()).booleanValue());
        } else if (msg.getData() instanceof Double) {
            buf.writeDouble(((Double)msg.getData()).doubleValue());
        } else if (msg.getData() instanceof Collection && !(collection = (Collection)msg.getData()).isEmpty() && collection.iterator().next() instanceof BlockPos) {
            buf.m_236828_(collection, FriendlyByteBuf::m_130064_);
        }
    }

    public static <T extends AbstractPacket<?>> T decode(@NotNull FriendlyByteBuf buf, PacketFactory<T> factory) {
        return factory.create(buf);
    }

    public abstract void handle(AbstractPacket<T> var1, @NotNull Supplier<NetworkEvent.Context> var2);

    public static interface PacketFactory<T extends AbstractPacket<?>> {
        public T create(FriendlyByteBuf var1);
    }
}

