/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.registry;

import com.ael.viner.config.Config;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class VinerBlockRegistry {
    private static List<Block> vineableBlocks;
    private static List<Block> unvineableBlocks;
    private static List<TagKey<Block>> vineableTags;
    private static List<TagKey<Block>> unvineableTags;
    private static Double exhaustionPerBlock;
    private static Boolean vineAll;
    private static int vineableLimit;
    private static int heightAbove;
    private static int heightBelow;
    private static int widthLeft;
    private static int widthRight;
    private static int layerOffset;
    private static Boolean shapeVine;
    private static final Logger LOGGER;

    public static void setup() {
        vineableBlocks = VinerBlockRegistry.initializeVineableBlocks();
        unvineableBlocks = VinerBlockRegistry.initializeUnvineableBlocks();
        vineableTags = VinerBlockRegistry.initializeVineableTags();
        unvineableTags = VinerBlockRegistry.initializeUnvineableTags();
        exhaustionPerBlock = VinerBlockRegistry.initializeExhaustionPerBlock();
        vineAll = VinerBlockRegistry.initializeVineAll();
        vineableLimit = VinerBlockRegistry.initializeVineableLimit();
        heightAbove = VinerBlockRegistry.initializeHeightAbove();
        heightBelow = VinerBlockRegistry.initializeHeightBelow();
        widthLeft = VinerBlockRegistry.initializeWidthLeft();
        widthRight = VinerBlockRegistry.initializeWidthRight();
        layerOffset = VinerBlockRegistry.initializeLayerOffset();
        shapeVine = VinerBlockRegistry.initializeShapeVine();
    }

    private static List<Block> initializeVineableBlocks() {
        return VinerBlockRegistry.getBlocksFromConfigEntries((List)Config.VINEABLE_BLOCKS.get());
    }

    private static List<Block> initializeUnvineableBlocks() {
        return VinerBlockRegistry.getBlocksFromConfigEntries((List)Config.UNVINEABLE_BLOCKS.get());
    }

    private static List<TagKey<Block>> initializeVineableTags() {
        return VinerBlockRegistry.getTagsFromConfigEntries((List)Config.VINEABLE_BLOCKS.get());
    }

    private static List<TagKey<Block>> initializeUnvineableTags() {
        return VinerBlockRegistry.getTagsFromConfigEntries((List)Config.UNVINEABLE_BLOCKS.get());
    }

    private static Double initializeExhaustionPerBlock() {
        return (Double)Config.EXHAUSTION_PER_BLOCK.get();
    }

    private static boolean initializeVineAll() {
        return (Boolean)Config.VINE_ALL.get();
    }

    private static int initializeVineableLimit() {
        return (Integer)Config.VINEABLE_LIMIT.get();
    }

    private static int initializeHeightAbove() {
        return (Integer)Config.HEIGHT_ABOVE.get();
    }

    private static int initializeHeightBelow() {
        return (Integer)Config.HEIGHT_BELOW.get();
    }

    private static int initializeWidthLeft() {
        return (Integer)Config.WIDTH_LEFT.get();
    }

    private static int initializeWidthRight() {
        return (Integer)Config.WIDTH_RIGHT.get();
    }

    private static int initializeLayerOffset() {
        return (Integer)Config.LAYER_OFFSET.get();
    }

    private static boolean initializeShapeVine() {
        return (Boolean)Config.SHAPE_VINE.get();
    }

    public static List<Block> getVineableBlocks() {
        if (vineableBlocks == null) {
            VinerBlockRegistry.setup();
        }
        return vineableBlocks;
    }

    public static List<Block> getUnvineableBlocks() {
        if (unvineableBlocks == null) {
            VinerBlockRegistry.setup();
        }
        return unvineableBlocks;
    }

    public static List<TagKey<Block>> getVineableTags() {
        if (vineableTags == null) {
            VinerBlockRegistry.setup();
        }
        return vineableTags;
    }

    public static List<TagKey<Block>> getUnvineableTags() {
        if (unvineableTags == null) {
            VinerBlockRegistry.setup();
        }
        return unvineableTags;
    }

    public static Double getExhaustionPerBlock() {
        if (exhaustionPerBlock < 0.0) {
            VinerBlockRegistry.setup();
        }
        return exhaustionPerBlock;
    }

    public static Boolean isVineAll() {
        if (vineAll == null) {
            VinerBlockRegistry.setup();
        }
        return vineAll;
    }

    public static int getVineableLimit() {
        if (vineableLimit < 0) {
            VinerBlockRegistry.setup();
        }
        return vineableLimit;
    }

    public static int getHeightAbove() {
        if (heightAbove < 0) {
            VinerBlockRegistry.setup();
        }
        return heightAbove;
    }

    public static int getHeightBelow() {
        if (heightBelow < 0) {
            VinerBlockRegistry.setup();
        }
        return heightBelow;
    }

    public static int getWidthLeft() {
        if (widthLeft < 0) {
            VinerBlockRegistry.setup();
        }
        return widthLeft;
    }

    public static int getWidthRight() {
        if (widthRight < 0) {
            VinerBlockRegistry.setup();
        }
        return widthRight;
    }

    public static int getLayerOffset() {
        if (layerOffset < -64 || layerOffset > 256) {
            VinerBlockRegistry.setup();
        }
        return layerOffset;
    }

    public static boolean isShapeVine() {
        if (shapeVine == null) {
            VinerBlockRegistry.setup();
        }
        return shapeVine;
    }

    public static List<Block> getBlocksFromConfigEntries(List<String> entries) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String entry : entries) {
            if (entry.startsWith("#")) continue;
            blocks.add((Block)ForgeRegistries.BLOCKS.getValue(VinerBlockRegistry.getResourceLocationFromEntry(entry)));
        }
        return blocks;
    }

    public static List<TagKey<Block>> getTagsFromConfigEntries(List<String> entries) {
        ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
        for (String entry : entries) {
            if (!entry.startsWith("#")) continue;
            tags.add(VinerBlockRegistry.getTagKeyEntry(entry));
        }
        return tags;
    }

    public static ResourceLocation getResourceLocationFromEntry(String entry) {
        String[] splitName = entry.startsWith("#") ? entry.substring(1).split(":") : entry.split(":");
        return new ResourceLocation(splitName[0], splitName[1]);
    }

    public static TagKey<Block> getTagKeyEntry(String entry) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).createTagKey(VinerBlockRegistry.getResourceLocationFromEntry(entry));
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

