/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.doesntknowtheway.network;

import java.util.function.Supplier;
import net.mcreator.doesntknowtheway.DoesntknowthewayMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DoesntknowthewayModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DoesntknowthewayMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        DoesntknowthewayMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.mana = message.data.mana;
                    variables.mana_max = message.data.mana_max;
                    variables.max_mana_all = message.data.max_mana_all;
                    variables.ManaMaxHelmet = message.data.ManaMaxHelmet;
                    variables.ManaMaxChestplate = message.data.ManaMaxChestplate;
                    variables.ManaMaxLeggings = message.data.ManaMaxLeggings;
                    variables.ManaMaxBoots = message.data.ManaMaxBoots;
                    variables.stamina = message.data.stamina;
                    variables.stamina_max = message.data.stamina_max;
                    variables.stamina_max_all = message.data.stamina_max_all;
                    variables.StaminaMaxHelmet = message.data.StaminaMaxHelmet;
                    variables.StaminaMaxChestplate = message.data.StaminaMaxChestplate;
                    variables.StaminaMaxLeggings = message.data.StaminaMaxLeggings;
                    variables.StaminaMaxBoots = message.data.StaminaMaxBoots;
                    variables.cooldown = message.data.cooldown;
                    variables.level = message.data.level;
                    variables.points = message.data.points;
                    variables.xp = message.data.xp;
                    variables.xp_max = message.data.xp_max;
                    variables.Skill1 = message.data.Skill1;
                    variables.MinerActive = message.data.MinerActive;
                    variables.WarriorActive = message.data.WarriorActive;
                    variables.Skill2 = message.data.Skill2;
                    variables.MinerRoadActive = message.data.MinerRoadActive;
                    variables.time_a = message.data.time_a;
                    variables.time_b = message.data.time_b;
                    variables.time_c = message.data.time_c;
                    variables.MinerAuraActive = message.data.MinerAuraActive;
                    variables.Passive1 = message.data.Passive1;
                    variables.Passive2 = message.data.Passive2;
                    variables.MinerHomeActive = message.data.MinerHomeActive;
                    variables.AntiStoneActive = message.data.AntiStoneActive;
                    variables.MinerMadnessActive = message.data.MinerMadnessActive;
                    variables.TntActive = message.data.TntActive;
                    variables.TntRoadActive = message.data.TntRoadActive;
                    variables.DeathExplosion = message.data.DeathExplosion;
                    variables.NuclearBombActive = message.data.NuclearBombActive;
                    variables.ShieldAreaActive = message.data.ShieldAreaActive;
                    variables.PoisonedShieldActive = message.data.PoisonedShieldActive;
                    variables.FuriousDashActive = message.data.FuriousDashActive;
                    variables.stamina_max_tree = message.data.stamina_max_tree;
                    variables.mana_max_tree = message.data.mana_max_tree;
                    variables.MaxStaminaBoostActive = message.data.MaxStaminaBoostActive;
                    variables.FastStaminaActive = message.data.FastStaminaActive;
                    variables.KillAuraActive = message.data.KillAuraActive;
                    variables.Absorption = message.data.Absorption;
                    variables.SharpWindActive = message.data.SharpWindActive;
                    variables.BedrockRoom = message.data.BedrockRoom;
                    variables.DoubleHpActive = message.data.DoubleHpActive;
                    variables.InvincibilityActive = message.data.InvincibilityActive;
                    variables.ManaRegenActive = message.data.ManaRegenActive;
                    variables.InstantDamageActive = message.data.InstantDamageActive;
                    variables.InstantHealthActive = message.data.InstantHealthActive;
                    variables.MaxManaBoost = message.data.MaxManaBoost;
                    variables.FireActive = message.data.FireActive;
                    variables.FireBreathActive = message.data.FireBreathActive;
                    variables.FireBallActive = message.data.FireBallActive;
                    variables.MagicalFlightButton = message.data.MagicalFlightButton;
                    variables.MagicalFlightActive = message.data.MagicalFlightActive;
                    variables.GroundBreakingActive = message.data.GroundBreakingActive;
                    variables.IntangibilityActive = message.data.IntangibilityActive;
                    variables.SummoningActive = message.data.SummoningActive;
                    variables.SummoningEliteActive = message.data.SummoningEliteActive;
                    variables.AfterDeathSummoningActive = message.data.AfterDeathSummoningActive;
                    variables.ArmyActive = message.data.ArmyActive;
                    variables.TimeBomb = message.data.TimeBomb;
                    variables.ThunderAuraActive = message.data.ThunderAuraActive;
                    variables.SpeedActive = message.data.SpeedActive;
                    variables.SlownessActive = message.data.SlownessActive;
                    variables.StrengthActive = message.data.StrengthActive;
                    variables.WeaknessActive = message.data.WeaknessActive;
                    variables.ResistanceActive = message.data.ResistanceActive;
                    variables.PanaceaActive = message.data.PanaceaActive;
                    variables.RegenerationActive = message.data.RegenerationActive;
                    variables.PoisonActive = message.data.PoisonActive;
                    variables.WitherActive = message.data.WitherActive;
                    variables.AbsorptionAllActive = message.data.AbsorptionAllActive;
                    variables.LevitationActive = message.data.LevitationActive;
                    variables.AllDebaffsUseActive = message.data.AllDebaffsUseActive;
                    variables.GlowingActive = message.data.GlowingActive;
                    variables.StManaActive = message.data.StManaActive;
                    variables.cooldown_Item = message.data.cooldown_Item;
                    variables.IsVampire = message.data.IsVampire;
                    variables.IsFighting = message.data.IsFighting;
                    variables.ApponentWon1 = message.data.ApponentWon1;
                    variables.ApponentWon2 = message.data.ApponentWon2;
                    variables.ApponentWon3 = message.data.ApponentWon3;
                    variables.ApponentWon4 = message.data.ApponentWon4;
                    variables.ApponentWon5 = message.data.ApponentWon5;
                    variables.ApponentWon6 = message.data.ApponentWon6;
                    variables.ApponentWon7 = message.data.ApponentWon7;
                    variables.ApponentWon8 = message.data.ApponentWon8;
                    variables.ApponentWon9 = message.data.ApponentWon9;
                    variables.ApponentWon10 = message.data.ApponentWon10;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double mana = 30.0;
        public double mana_max = 30.0;
        public double max_mana_all = 30.0;
        public double ManaMaxHelmet = 0.0;
        public double ManaMaxChestplate = 0.0;
        public double ManaMaxLeggings = 0.0;
        public double ManaMaxBoots = 0.0;
        public double stamina = 30.0;
        public double stamina_max = 30.0;
        public double stamina_max_all = 30.0;
        public double StaminaMaxHelmet = 0.0;
        public double StaminaMaxChestplate = 0.0;
        public double StaminaMaxLeggings = 0.0;
        public double StaminaMaxBoots = 0.0;
        public double cooldown = 0.0;
        public double level = 1.0;
        public double points = 0.0;
        public double xp = 0.0;
        public double xp_max = 7.0;
        public String Skill1 = "";
        public boolean MinerActive = false;
        public boolean WarriorActive = false;
        public String Skill2 = "";
        public boolean MinerRoadActive = false;
        public double time_a = 0.0;
        public double time_b = 0.0;
        public double time_c = 0.0;
        public boolean MinerAuraActive = false;
        public String Passive1 = "";
        public String Passive2 = "\"\"";
        public boolean MinerHomeActive = false;
        public boolean AntiStoneActive = false;
        public boolean MinerMadnessActive = false;
        public boolean TntActive = false;
        public boolean TntRoadActive = false;
        public boolean DeathExplosion = false;
        public boolean NuclearBombActive = false;
        public boolean ShieldAreaActive = false;
        public boolean PoisonedShieldActive = false;
        public boolean FuriousDashActive = false;
        public double stamina_max_tree = 0.0;
        public double mana_max_tree = 0.0;
        public boolean MaxStaminaBoostActive = false;
        public boolean FastStaminaActive = false;
        public boolean KillAuraActive = false;
        public boolean Absorption = false;
        public boolean SharpWindActive = false;
        public boolean BedrockRoom = false;
        public boolean DoubleHpActive = false;
        public boolean InvincibilityActive = false;
        public boolean ManaRegenActive = false;
        public boolean InstantDamageActive = false;
        public boolean InstantHealthActive = false;
        public boolean MaxManaBoost = false;
        public boolean FireActive = false;
        public boolean FireBreathActive = false;
        public boolean FireBallActive = false;
        public boolean MagicalFlightButton = false;
        public boolean MagicalFlightActive = false;
        public boolean GroundBreakingActive = false;
        public boolean IntangibilityActive = false;
        public boolean SummoningActive = false;
        public boolean SummoningEliteActive = false;
        public boolean AfterDeathSummoningActive = false;
        public boolean ArmyActive = false;
        public boolean TimeBomb = false;
        public boolean ThunderAuraActive = false;
        public boolean SpeedActive = false;
        public boolean SlownessActive = false;
        public boolean StrengthActive = false;
        public boolean WeaknessActive = false;
        public boolean ResistanceActive = false;
        public boolean PanaceaActive = false;
        public boolean RegenerationActive = false;
        public boolean PoisonActive = false;
        public boolean WitherActive = false;
        public boolean AbsorptionAllActive = false;
        public boolean LevitationActive = false;
        public boolean AllDebaffsUseActive = false;
        public boolean GlowingActive = false;
        public boolean StManaActive = false;
        public double cooldown_Item = 0.0;
        public boolean IsVampire = false;
        public boolean IsFighting = false;
        public boolean ApponentWon1 = false;
        public boolean ApponentWon2 = false;
        public boolean ApponentWon3 = false;
        public boolean ApponentWon4 = false;
        public boolean ApponentWon5 = false;
        public boolean ApponentWon6 = false;
        public boolean ApponentWon7 = false;
        public boolean ApponentWon8 = false;
        public boolean ApponentWon9 = false;
        public boolean ApponentWon10 = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DoesntknowthewayMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("mana", this.mana);
            nbt.m_128347_("mana_max", this.mana_max);
            nbt.m_128347_("max_mana_all", this.max_mana_all);
            nbt.m_128347_("ManaMaxHelmet", this.ManaMaxHelmet);
            nbt.m_128347_("ManaMaxChestplate", this.ManaMaxChestplate);
            nbt.m_128347_("ManaMaxLeggings", this.ManaMaxLeggings);
            nbt.m_128347_("ManaMaxBoots", this.ManaMaxBoots);
            nbt.m_128347_("stamina", this.stamina);
            nbt.m_128347_("stamina_max", this.stamina_max);
            nbt.m_128347_("stamina_max_all", this.stamina_max_all);
            nbt.m_128347_("StaminaMaxHelmet", this.StaminaMaxHelmet);
            nbt.m_128347_("StaminaMaxChestplate", this.StaminaMaxChestplate);
            nbt.m_128347_("StaminaMaxLeggings", this.StaminaMaxLeggings);
            nbt.m_128347_("StaminaMaxBoots", this.StaminaMaxBoots);
            nbt.m_128347_("cooldown", this.cooldown);
            nbt.m_128347_("level", this.level);
            nbt.m_128347_("points", this.points);
            nbt.m_128347_("xp", this.xp);
            nbt.m_128347_("xp_max", this.xp_max);
            nbt.m_128359_("Skill1", this.Skill1);
            nbt.m_128379_("MinerActive", this.MinerActive);
            nbt.m_128379_("WarriorActive", this.WarriorActive);
            nbt.m_128359_("Skill2", this.Skill2);
            nbt.m_128379_("MinerRoadActive", this.MinerRoadActive);
            nbt.m_128347_("time_a", this.time_a);
            nbt.m_128347_("time_b", this.time_b);
            nbt.m_128347_("time_c", this.time_c);
            nbt.m_128379_("MinerAuraActive", this.MinerAuraActive);
            nbt.m_128359_("Passive1", this.Passive1);
            nbt.m_128359_("Passive2", this.Passive2);
            nbt.m_128379_("MinerHomeActive", this.MinerHomeActive);
            nbt.m_128379_("AntiStoneActive", this.AntiStoneActive);
            nbt.m_128379_("MinerMadnessActive", this.MinerMadnessActive);
            nbt.m_128379_("TntActive", this.TntActive);
            nbt.m_128379_("TntRoadActive", this.TntRoadActive);
            nbt.m_128379_("DeathExplosion", this.DeathExplosion);
            nbt.m_128379_("NuclearBombActive", this.NuclearBombActive);
            nbt.m_128379_("ShieldAreaActive", this.ShieldAreaActive);
            nbt.m_128379_("PoisonedShieldActive", this.PoisonedShieldActive);
            nbt.m_128379_("FuriousDashActive", this.FuriousDashActive);
            nbt.m_128347_("stamina_max_tree", this.stamina_max_tree);
            nbt.m_128347_("mana_max_tree", this.mana_max_tree);
            nbt.m_128379_("MaxStaminaBoostActive", this.MaxStaminaBoostActive);
            nbt.m_128379_("FastStaminaActive", this.FastStaminaActive);
            nbt.m_128379_("KillAuraActive", this.KillAuraActive);
            nbt.m_128379_("Absorption", this.Absorption);
            nbt.m_128379_("SharpWindActive", this.SharpWindActive);
            nbt.m_128379_("BedrockRoom", this.BedrockRoom);
            nbt.m_128379_("DoubleHpActive", this.DoubleHpActive);
            nbt.m_128379_("InvincibilityActive", this.InvincibilityActive);
            nbt.m_128379_("ManaRegenActive", this.ManaRegenActive);
            nbt.m_128379_("InstantDamageActive", this.InstantDamageActive);
            nbt.m_128379_("InstantHealthActive", this.InstantHealthActive);
            nbt.m_128379_("MaxManaBoost", this.MaxManaBoost);
            nbt.m_128379_("FireActive", this.FireActive);
            nbt.m_128379_("FireBreathActive", this.FireBreathActive);
            nbt.m_128379_("FireBallActive", this.FireBallActive);
            nbt.m_128379_("MagicalFlightButton", this.MagicalFlightButton);
            nbt.m_128379_("MagicalFlightActive", this.MagicalFlightActive);
            nbt.m_128379_("GroundBreakingActive", this.GroundBreakingActive);
            nbt.m_128379_("IntangibilityActive", this.IntangibilityActive);
            nbt.m_128379_("SummoningActive", this.SummoningActive);
            nbt.m_128379_("SummoningEliteActive", this.SummoningEliteActive);
            nbt.m_128379_("AfterDeathSummoningActive", this.AfterDeathSummoningActive);
            nbt.m_128379_("ArmyActive", this.ArmyActive);
            nbt.m_128379_("TimeBomb", this.TimeBomb);
            nbt.m_128379_("ThunderAuraActive", this.ThunderAuraActive);
            nbt.m_128379_("SpeedActive", this.SpeedActive);
            nbt.m_128379_("SlownessActive", this.SlownessActive);
            nbt.m_128379_("StrengthActive", this.StrengthActive);
            nbt.m_128379_("WeaknessActive", this.WeaknessActive);
            nbt.m_128379_("ResistanceActive", this.ResistanceActive);
            nbt.m_128379_("PanaceaActive", this.PanaceaActive);
            nbt.m_128379_("RegenerationActive", this.RegenerationActive);
            nbt.m_128379_("PoisonActive", this.PoisonActive);
            nbt.m_128379_("WitherActive", this.WitherActive);
            nbt.m_128379_("AbsorptionAllActive", this.AbsorptionAllActive);
            nbt.m_128379_("LevitationActive", this.LevitationActive);
            nbt.m_128379_("AllDebaffsUseActive", this.AllDebaffsUseActive);
            nbt.m_128379_("GlowingActive", this.GlowingActive);
            nbt.m_128379_("StManaActive", this.StManaActive);
            nbt.m_128347_("cooldown_Item", this.cooldown_Item);
            nbt.m_128379_("IsVampire", this.IsVampire);
            nbt.m_128379_("IsFighting", this.IsFighting);
            nbt.m_128379_("ApponentWon1", this.ApponentWon1);
            nbt.m_128379_("ApponentWon2", this.ApponentWon2);
            nbt.m_128379_("ApponentWon3", this.ApponentWon3);
            nbt.m_128379_("ApponentWon4", this.ApponentWon4);
            nbt.m_128379_("ApponentWon5", this.ApponentWon5);
            nbt.m_128379_("ApponentWon6", this.ApponentWon6);
            nbt.m_128379_("ApponentWon7", this.ApponentWon7);
            nbt.m_128379_("ApponentWon8", this.ApponentWon8);
            nbt.m_128379_("ApponentWon9", this.ApponentWon9);
            nbt.m_128379_("ApponentWon10", this.ApponentWon10);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.mana = nbt.m_128459_("mana");
            this.mana_max = nbt.m_128459_("mana_max");
            this.max_mana_all = nbt.m_128459_("max_mana_all");
            this.ManaMaxHelmet = nbt.m_128459_("ManaMaxHelmet");
            this.ManaMaxChestplate = nbt.m_128459_("ManaMaxChestplate");
            this.ManaMaxLeggings = nbt.m_128459_("ManaMaxLeggings");
            this.ManaMaxBoots = nbt.m_128459_("ManaMaxBoots");
            this.stamina = nbt.m_128459_("stamina");
            this.stamina_max = nbt.m_128459_("stamina_max");
            this.stamina_max_all = nbt.m_128459_("stamina_max_all");
            this.StaminaMaxHelmet = nbt.m_128459_("StaminaMaxHelmet");
            this.StaminaMaxChestplate = nbt.m_128459_("StaminaMaxChestplate");
            this.StaminaMaxLeggings = nbt.m_128459_("StaminaMaxLeggings");
            this.StaminaMaxBoots = nbt.m_128459_("StaminaMaxBoots");
            this.cooldown = nbt.m_128459_("cooldown");
            this.level = nbt.m_128459_("level");
            this.points = nbt.m_128459_("points");
            this.xp = nbt.m_128459_("xp");
            this.xp_max = nbt.m_128459_("xp_max");
            this.Skill1 = nbt.m_128461_("Skill1");
            this.MinerActive = nbt.m_128471_("MinerActive");
            this.WarriorActive = nbt.m_128471_("WarriorActive");
            this.Skill2 = nbt.m_128461_("Skill2");
            this.MinerRoadActive = nbt.m_128471_("MinerRoadActive");
            this.time_a = nbt.m_128459_("time_a");
            this.time_b = nbt.m_128459_("time_b");
            this.time_c = nbt.m_128459_("time_c");
            this.MinerAuraActive = nbt.m_128471_("MinerAuraActive");
            this.Passive1 = nbt.m_128461_("Passive1");
            this.Passive2 = nbt.m_128461_("Passive2");
            this.MinerHomeActive = nbt.m_128471_("MinerHomeActive");
            this.AntiStoneActive = nbt.m_128471_("AntiStoneActive");
            this.MinerMadnessActive = nbt.m_128471_("MinerMadnessActive");
            this.TntActive = nbt.m_128471_("TntActive");
            this.TntRoadActive = nbt.m_128471_("TntRoadActive");
            this.DeathExplosion = nbt.m_128471_("DeathExplosion");
            this.NuclearBombActive = nbt.m_128471_("NuclearBombActive");
            this.ShieldAreaActive = nbt.m_128471_("ShieldAreaActive");
            this.PoisonedShieldActive = nbt.m_128471_("PoisonedShieldActive");
            this.FuriousDashActive = nbt.m_128471_("FuriousDashActive");
            this.stamina_max_tree = nbt.m_128459_("stamina_max_tree");
            this.mana_max_tree = nbt.m_128459_("mana_max_tree");
            this.MaxStaminaBoostActive = nbt.m_128471_("MaxStaminaBoostActive");
            this.FastStaminaActive = nbt.m_128471_("FastStaminaActive");
            this.KillAuraActive = nbt.m_128471_("KillAuraActive");
            this.Absorption = nbt.m_128471_("Absorption");
            this.SharpWindActive = nbt.m_128471_("SharpWindActive");
            this.BedrockRoom = nbt.m_128471_("BedrockRoom");
            this.DoubleHpActive = nbt.m_128471_("DoubleHpActive");
            this.InvincibilityActive = nbt.m_128471_("InvincibilityActive");
            this.ManaRegenActive = nbt.m_128471_("ManaRegenActive");
            this.InstantDamageActive = nbt.m_128471_("InstantDamageActive");
            this.InstantHealthActive = nbt.m_128471_("InstantHealthActive");
            this.MaxManaBoost = nbt.m_128471_("MaxManaBoost");
            this.FireActive = nbt.m_128471_("FireActive");
            this.FireBreathActive = nbt.m_128471_("FireBreathActive");
            this.FireBallActive = nbt.m_128471_("FireBallActive");
            this.MagicalFlightButton = nbt.m_128471_("MagicalFlightButton");
            this.MagicalFlightActive = nbt.m_128471_("MagicalFlightActive");
            this.GroundBreakingActive = nbt.m_128471_("GroundBreakingActive");
            this.IntangibilityActive = nbt.m_128471_("IntangibilityActive");
            this.SummoningActive = nbt.m_128471_("SummoningActive");
            this.SummoningEliteActive = nbt.m_128471_("SummoningEliteActive");
            this.AfterDeathSummoningActive = nbt.m_128471_("AfterDeathSummoningActive");
            this.ArmyActive = nbt.m_128471_("ArmyActive");
            this.TimeBomb = nbt.m_128471_("TimeBomb");
            this.ThunderAuraActive = nbt.m_128471_("ThunderAuraActive");
            this.SpeedActive = nbt.m_128471_("SpeedActive");
            this.SlownessActive = nbt.m_128471_("SlownessActive");
            this.StrengthActive = nbt.m_128471_("StrengthActive");
            this.WeaknessActive = nbt.m_128471_("WeaknessActive");
            this.ResistanceActive = nbt.m_128471_("ResistanceActive");
            this.PanaceaActive = nbt.m_128471_("PanaceaActive");
            this.RegenerationActive = nbt.m_128471_("RegenerationActive");
            this.PoisonActive = nbt.m_128471_("PoisonActive");
            this.WitherActive = nbt.m_128471_("WitherActive");
            this.AbsorptionAllActive = nbt.m_128471_("AbsorptionAllActive");
            this.LevitationActive = nbt.m_128471_("LevitationActive");
            this.AllDebaffsUseActive = nbt.m_128471_("AllDebaffsUseActive");
            this.GlowingActive = nbt.m_128471_("GlowingActive");
            this.StManaActive = nbt.m_128471_("StManaActive");
            this.cooldown_Item = nbt.m_128459_("cooldown_Item");
            this.IsVampire = nbt.m_128471_("IsVampire");
            this.IsFighting = nbt.m_128471_("IsFighting");
            this.ApponentWon1 = nbt.m_128471_("ApponentWon1");
            this.ApponentWon2 = nbt.m_128471_("ApponentWon2");
            this.ApponentWon3 = nbt.m_128471_("ApponentWon3");
            this.ApponentWon4 = nbt.m_128471_("ApponentWon4");
            this.ApponentWon5 = nbt.m_128471_("ApponentWon5");
            this.ApponentWon6 = nbt.m_128471_("ApponentWon6");
            this.ApponentWon7 = nbt.m_128471_("ApponentWon7");
            this.ApponentWon8 = nbt.m_128471_("ApponentWon8");
            this.ApponentWon9 = nbt.m_128471_("ApponentWon9");
            this.ApponentWon10 = nbt.m_128471_("ApponentWon10");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("doesntknowtheway", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "doesntknowtheway_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                DoesntknowthewayMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "doesntknowtheway_worldvars";
        public boolean RedKnightsAngry = true;
        public String WhatSkip = "day";
        public boolean zanudaDied = false;
        public boolean zadeeraDied = false;
        public boolean Day1Gone = false;
        public boolean FightHappening = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.RedKnightsAngry = nbt.m_128471_("RedKnightsAngry");
            this.WhatSkip = nbt.m_128461_("WhatSkip");
            this.zanudaDied = nbt.m_128471_("zanudaDied");
            this.zadeeraDied = nbt.m_128471_("zadeeraDied");
            this.Day1Gone = nbt.m_128471_("Day1Gone");
            this.FightHappening = nbt.m_128471_("FightHappening");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("RedKnightsAngry", this.RedKnightsAngry);
            nbt.m_128359_("WhatSkip", this.WhatSkip);
            nbt.m_128379_("zanudaDied", this.zanudaDied);
            nbt.m_128379_("zadeeraDied", this.zadeeraDied);
            nbt.m_128379_("Day1Gone", this.Day1Gone);
            nbt.m_128379_("FightHappening", this.FightHappening);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                DoesntknowthewayMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.mana = original.mana;
            clone.mana_max = original.mana_max;
            clone.max_mana_all = original.max_mana_all;
            clone.ManaMaxHelmet = original.ManaMaxHelmet;
            clone.ManaMaxChestplate = original.ManaMaxChestplate;
            clone.ManaMaxLeggings = original.ManaMaxLeggings;
            clone.ManaMaxBoots = original.ManaMaxBoots;
            clone.stamina = original.stamina;
            clone.stamina_max = original.stamina_max;
            clone.stamina_max_all = original.stamina_max_all;
            clone.StaminaMaxHelmet = original.StaminaMaxHelmet;
            clone.StaminaMaxChestplate = original.StaminaMaxChestplate;
            clone.StaminaMaxLeggings = original.StaminaMaxLeggings;
            clone.StaminaMaxBoots = original.StaminaMaxBoots;
            clone.cooldown = original.cooldown;
            clone.level = original.level;
            clone.points = original.points;
            clone.xp = original.xp;
            clone.xp_max = original.xp_max;
            clone.Skill1 = original.Skill1;
            clone.MinerActive = original.MinerActive;
            clone.WarriorActive = original.WarriorActive;
            clone.Skill2 = original.Skill2;
            clone.MinerRoadActive = original.MinerRoadActive;
            clone.time_a = original.time_a;
            clone.time_b = original.time_b;
            clone.time_c = original.time_c;
            clone.MinerAuraActive = original.MinerAuraActive;
            clone.Passive1 = original.Passive1;
            clone.Passive2 = original.Passive2;
            clone.MinerHomeActive = original.MinerHomeActive;
            clone.AntiStoneActive = original.AntiStoneActive;
            clone.MinerMadnessActive = original.MinerMadnessActive;
            clone.TntActive = original.TntActive;
            clone.TntRoadActive = original.TntRoadActive;
            clone.DeathExplosion = original.DeathExplosion;
            clone.NuclearBombActive = original.NuclearBombActive;
            clone.ShieldAreaActive = original.ShieldAreaActive;
            clone.PoisonedShieldActive = original.PoisonedShieldActive;
            clone.FuriousDashActive = original.FuriousDashActive;
            clone.stamina_max_tree = original.stamina_max_tree;
            clone.mana_max_tree = original.mana_max_tree;
            clone.MaxStaminaBoostActive = original.MaxStaminaBoostActive;
            clone.FastStaminaActive = original.FastStaminaActive;
            clone.KillAuraActive = original.KillAuraActive;
            clone.Absorption = original.Absorption;
            clone.SharpWindActive = original.SharpWindActive;
            clone.BedrockRoom = original.BedrockRoom;
            clone.DoubleHpActive = original.DoubleHpActive;
            clone.InvincibilityActive = original.InvincibilityActive;
            clone.ManaRegenActive = original.ManaRegenActive;
            clone.InstantDamageActive = original.InstantDamageActive;
            clone.InstantHealthActive = original.InstantHealthActive;
            clone.MaxManaBoost = original.MaxManaBoost;
            clone.FireActive = original.FireActive;
            clone.FireBreathActive = original.FireBreathActive;
            clone.FireBallActive = original.FireBallActive;
            clone.MagicalFlightButton = original.MagicalFlightButton;
            clone.MagicalFlightActive = original.MagicalFlightActive;
            clone.GroundBreakingActive = original.GroundBreakingActive;
            clone.IntangibilityActive = original.IntangibilityActive;
            clone.SummoningActive = original.SummoningActive;
            clone.SummoningEliteActive = original.SummoningEliteActive;
            clone.AfterDeathSummoningActive = original.AfterDeathSummoningActive;
            clone.ArmyActive = original.ArmyActive;
            clone.TimeBomb = original.TimeBomb;
            clone.ThunderAuraActive = original.ThunderAuraActive;
            clone.SpeedActive = original.SpeedActive;
            clone.SlownessActive = original.SlownessActive;
            clone.StrengthActive = original.StrengthActive;
            clone.WeaknessActive = original.WeaknessActive;
            clone.ResistanceActive = original.ResistanceActive;
            clone.PanaceaActive = original.PanaceaActive;
            clone.RegenerationActive = original.RegenerationActive;
            clone.PoisonActive = original.PoisonActive;
            clone.WitherActive = original.WitherActive;
            clone.AbsorptionAllActive = original.AbsorptionAllActive;
            clone.LevitationActive = original.LevitationActive;
            clone.AllDebaffsUseActive = original.AllDebaffsUseActive;
            clone.GlowingActive = original.GlowingActive;
            clone.StManaActive = original.StManaActive;
            clone.cooldown_Item = original.cooldown_Item;
            clone.IsVampire = original.IsVampire;
            clone.IsFighting = original.IsFighting;
            clone.ApponentWon1 = original.ApponentWon1;
            clone.ApponentWon2 = original.ApponentWon2;
            clone.ApponentWon3 = original.ApponentWon3;
            clone.ApponentWon4 = original.ApponentWon4;
            clone.ApponentWon5 = original.ApponentWon5;
            clone.ApponentWon6 = original.ApponentWon6;
            clone.ApponentWon7 = original.ApponentWon7;
            clone.ApponentWon8 = original.ApponentWon8;
            clone.ApponentWon9 = original.ApponentWon9;
            clone.ApponentWon10 = original.ApponentWon10;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    DoesntknowthewayMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    DoesntknowthewayMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                DoesntknowthewayMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

