/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.redstonelinks.blocks.custom;

import com.andersmmg.redstonelinks.blocks.entity.LinkedBlockEntity;
import com.andersmmg.redstonelinks.blocks.entity.ModBlockEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class LinkedBlock
extends class_2248
implements class_2343 {
    public static final class_2746 POWERED = class_2746.method_11825((String)"powered");
    public static final class_2746 ENABLED = class_2746.method_11825((String)"enabled");

    public LinkedBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LinkedBlockEntity(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (player.method_5715() && player.method_5998(hand).method_7960()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof LinkedBlockEntity) {
                List<String> linkedBlockNames = this.getLinkedBlocksNames(world, pos);
                String blockNames = String.join((CharSequence)", ", linkedBlockNames);
                LinkedBlock.sendChatMessage(player, (class_2561)class_2561.method_43469((String)"block.redstonelinks.linked_blocks_list", (Object[])new Object[]{blockNames}));
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    private List<String> getLinkedBlocksNames(class_1937 world, class_2338 pos) {
        LinkedBlockEntity linkedBlockEntity = (LinkedBlockEntity)world.method_8321(pos);
        if (linkedBlockEntity == null) {
            return new ArrayList<String>();
        }
        List<class_2338> linkedBlockPositions = linkedBlockEntity.getLinkedBlockPositions();
        HashMap<class_2248, Integer> linkedBlockCounts = new HashMap<class_2248, Integer>();
        for (class_2338 linkedBlockPos : linkedBlockPositions) {
            class_2248 block = world.method_8320(linkedBlockPos).method_26204();
            linkedBlockCounts.put(block, linkedBlockCounts.getOrDefault(block, 0) + 1);
        }
        ArrayList<String> linkedBlockNames = new ArrayList<String>();
        for (Map.Entry entry : linkedBlockCounts.entrySet()) {
            class_2248 block = (class_2248)entry.getKey();
            int count = (Integer)entry.getValue();
            linkedBlockNames.add(block.method_9518().getString() + " (x" + count + ")");
        }
        return linkedBlockNames;
    }

    private void updateLinkedBlocks(class_1937 world, class_2338 pos) {
        LinkedBlockEntity linkedBlockEntity = (LinkedBlockEntity)world.method_8321(pos);
        if (linkedBlockEntity == null) {
            return;
        }
        linkedBlockEntity.updateLinkedBlocks(world, pos);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        this.updateLinkedBlocks(world, pos);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return LinkedBlock.checkType(type, ModBlockEntities.LINKED_BLOCK_ENTITY, LinkedBlockEntity::tick);
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            if (world.method_49803(pos)) {
                boolean powered;
                class_2680 blockState = world.method_8320(pos);
                if (blockState.method_28498((class_2769)POWERED) && !(powered = ((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue())) {
                    world.method_8652(pos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else {
                boolean powered;
                class_2680 blockState = world.method_8320(pos);
                if (blockState.method_28498((class_2769)POWERED) && (powered = ((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue())) {
                    world.method_8652(pos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
            this.updateLinkedBlocks(world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        boolean powered;
        class_2680 blockState;
        if (!state.method_27852(newState.method_26204()) && state.method_28498((class_2769)POWERED) && (blockState = world.method_8320(pos)).method_28498((class_2769)POWERED) && (powered = ((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue())) {
            world.method_8652(pos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.updateLinkedBlocks(world, pos);
    }

    private static void sendChatMessage(class_1657 player, class_2561 message) {
        ((class_3222)player).method_43502(message, false);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED, ENABLED});
    }
}

