/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.redstonelinks.blocks.entity;

import com.andersmmg.redstonelinks.RedstoneLinks;
import com.andersmmg.redstonelinks.blocks.custom.LinkedBlock;
import com.andersmmg.redstonelinks.blocks.entity.ModBlockEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class LinkedBlockEntity
extends class_2586 {
    private List<class_2338> linkedBlocks = new ArrayList<class_2338>();
    private final List<class_2746> supportedProperties = new ArrayList<class_2746>();
    private final List<String> propertyNames = List.of("powered", "open", "lit", "triggered", "enabled");

    public LinkedBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.LINKED_BLOCK_ENTITY, pos, state);
        this.initSupportedProperties();
    }

    private void initSupportedProperties() {
        for (String propertyName : this.propertyNames) {
            class_2746 property = class_2746.method_11825((String)propertyName);
            this.supportedProperties.add(property);
        }
    }

    public void updateLinkedBlocks(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return;
        }
        Iterator<class_2338> iterator = this.linkedBlocks.iterator();
        while (iterator.hasNext()) {
            class_2248 class_22482;
            boolean powered;
            class_2338 linkedPos = iterator.next();
            class_2680 linkedState = world.method_8320(linkedPos);
            if (!this.canBePowered(linkedPos)) {
                iterator.remove();
                continue;
            }
            boolean bl = powered = world.method_49803(pos) && (Boolean)this.method_11010().method_11654((class_2769)LinkedBlock.ENABLED) != false;
            if (powered && (class_22482 = linkedState.method_26204()) instanceof class_2315) {
                class_2315 dispenserBlock = (class_2315)class_22482;
                class_2601 dispenserEntity = (class_2601)world.method_8321(linkedPos);
                if (dispenserEntity == null) continue;
                if (!((Boolean)dispenserEntity.method_11010().method_11654((class_2769)class_2315.field_10920)).booleanValue()) {
                    dispenserBlock.method_9588(linkedState, (class_3218)world, linkedPos, world.field_9229);
                }
            }
            for (class_2746 property : this.supportedProperties) {
                if (!linkedState.method_28498((class_2769)property) || (Boolean)linkedState.method_11654((class_2769)property) == powered) continue;
                class_2680 updatedState = (class_2680)linkedState.method_11657((class_2769)property, (Comparable)Boolean.valueOf(powered));
                world.method_8652(linkedPos, updatedState, 3);
            }
        }
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10566("linked_blocks", (class_2520)this.serializeLinkedBlocks(this.linkedBlocks));
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        if (nbt.method_10545("linked_blocks")) {
            class_2499 list = nbt.method_10554("linked_blocks", 9);
            this.linkedBlocks = new ArrayList<class_2338>();
            for (int i = 0; i < list.size(); ++i) {
                class_2499 posTag = list.method_10603(i);
                int x = posTag.method_10600(0);
                int y = posTag.method_10600(1);
                int z = posTag.method_10600(2);
                this.linkedBlocks.add(new class_2338(x, y, z));
            }
            this.linkedBlocks.forEach(this::addLinkedBlock);
        }
        super.method_11014(nbt);
    }

    public class_2499 serializeLinkedBlocks(List<class_2338> linkedBlocks) {
        class_2499 listTag = new class_2499();
        for (class_2338 pos : linkedBlocks) {
            class_2499 posTag = new class_2499();
            posTag.add((Object)class_2497.method_23247((int)pos.method_10263()));
            posTag.add((Object)class_2497.method_23247((int)pos.method_10264()));
            posTag.add((Object)class_2497.method_23247((int)pos.method_10260()));
            listTag.add((Object)posTag);
        }
        return listTag;
    }

    public boolean addLinkedBlock(class_2338 pos) {
        if (!this.linkedBlocks.contains(pos) && this.canBePowered(pos)) {
            this.linkedBlocks.add(pos);
            RedstoneLinks.LOGGER.info("Added block at position {} to linked blocks list.", (Object)pos.toString());
            this.method_5431();
            return true;
        }
        return false;
    }

    public void removeLinkedBlock(class_2338 pos) {
        this.linkedBlocks.remove(pos);
        RedstoneLinks.LOGGER.info("Removed block at position {} to linked blocks list.", (Object)pos);
        this.method_5431();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, LinkedBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        blockEntity.updateLinkedBlocks(world, pos);
    }

    private boolean canBePowered(class_2338 pos) {
        class_2680 linkedState = this.field_11863.method_8320(pos);
        class_2248 block = linkedState.method_26204();
        if (block.equals(class_2246.field_10200)) {
            return true;
        }
        if (block.equals(class_2246.field_10450) || block.equals(class_2246.field_10377)) {
            return false;
        }
        for (class_2746 property : this.supportedProperties) {
            if (!linkedState.method_28498((class_2769)property)) continue;
            return true;
        }
        return false;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.updateLinkedBlocks(this.field_11863, this.field_11867);
        }
    }

    public List<class_2338> getLinkedBlockPositions() {
        return this.linkedBlocks;
    }
}

