/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IChoppingBoard;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.ChoppingBoardRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ChoppingBoardBlockEntity
extends BaseBlockEntity
implements IChoppingBoard {
    private static final String MODEL_ID = "ModelId";
    private static final String CURRENT_CUT_STACK = "CurrentCutStack";
    private static final String RESULT_ITEM = "ResultItem";
    private static final String MAX_CUT_COUNT = "MaxCutCount";
    private static final String CURRENT_CUT_COUNT = "CurrentCutCount";
    @Nullable
    public ModelResourceLocation[] cacheModels = null;
    @Nullable
    public ModelResourceLocation previousModel = null;
    @Nullable
    private ResourceLocation modelId = null;
    private int maxCutCount = 0;
    private int currentCutCount = 0;
    private ItemStack currentCutStack = ItemStack.EMPTY;
    private ItemStack result = ItemStack.EMPTY;

    public ChoppingBoardBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.CHOPPING_BOARD_BE.get(), pos, blockState);
    }

    @Override
    public boolean onPutItem(Level level, LivingEntity user, ItemStack putOnItem) {
        if (!this.result.isEmpty()) {
            return false;
        }
        SingleRecipeInput container = new SingleRecipeInput(putOnItem);
        Optional recipeOptional = level.getRecipeManager().getRecipeFor(ModRecipes.CHOPPING_BOARD_RECIPE, (RecipeInput)container, level);
        if (recipeOptional.isPresent()) {
            ChoppingBoardRecipe recipe = (ChoppingBoardRecipe)((RecipeHolder)recipeOptional.get()).value();
            this.modelId = recipe.getModelId();
            this.maxCutCount = recipe.getCutCount();
            this.currentCutCount = 0;
            this.currentCutStack = putOnItem.split(1);
            this.result = recipe.assemble(container, (HolderLookup.Provider)level.registryAccess());
            this.refresh();
            level.playSound(null, this.worldPosition, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCutItem(Level level, LivingEntity user, ItemStack cutterItem) {
        if (this.result.isEmpty()) {
            return false;
        }
        if (this.currentCutCount >= this.maxCutCount) {
            Block.popResource((Level)level, (BlockPos)this.worldPosition, (ItemStack)this.result.copy());
            this.resetBoardData();
            level.playSound(null, this.worldPosition, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 2.0f + level.random.nextFloat() * 0.2f);
            return true;
        }
        if (cutterItem.is(TagMod.KITCHEN_KNIFE)) {
            ++this.currentCutCount;
            this.playParticlesSound();
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean onTakeOut(Level level, LivingEntity user) {
        if (this.currentCutCount == 0 && !this.currentCutStack.isEmpty()) {
            if (user instanceof Player) {
                Player player = (Player)user;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentCutStack);
            } else {
                Block.popResource((Level)level, (BlockPos)this.worldPosition, (ItemStack)this.currentCutStack);
            }
            this.resetBoardData();
            level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.2f + level.random.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    @Override
    public void playParticlesSound() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.getRandom();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, (double)this.worldPosition.getX() + 0.25 + random.nextDouble() / 2.0, (double)this.worldPosition.getY() + 0.25, (double)this.worldPosition.getZ() + 0.25 + random.nextDouble() / 2.0, 2, 0.0, 0.0, 0.0, 0.1);
            serverLevel.playSound(null, this.worldPosition, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.5f + this.level.random.nextFloat() * 0.4f);
        }
    }

    private void resetBoardData() {
        this.modelId = null;
        this.result = ItemStack.EMPTY;
        this.currentCutStack = ItemStack.EMPTY;
        this.currentCutCount = 0;
        this.maxCutCount = 0;
        this.refresh();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.modelId != null) {
            tag.putString(MODEL_ID, this.modelId.toString());
        }
        tag.putInt(MAX_CUT_COUNT, this.maxCutCount);
        tag.putInt(CURRENT_CUT_COUNT, this.currentCutCount);
        tag.put(CURRENT_CUT_STACK, this.currentCutStack.saveOptional(registries));
        tag.put(RESULT_ITEM, this.result.saveOptional(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(MODEL_ID)) {
            this.modelId = ResourceLocation.parse((String)tag.getString(MODEL_ID));
        }
        this.maxCutCount = tag.getInt(MAX_CUT_COUNT);
        this.currentCutCount = tag.getInt(CURRENT_CUT_COUNT);
        if (tag.contains(CURRENT_CUT_STACK)) {
            this.currentCutStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(CURRENT_CUT_STACK));
        }
        if (tag.contains(RESULT_ITEM)) {
            this.result = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(RESULT_ITEM));
        }
    }

    @Nullable
    public ResourceLocation getModelId() {
        return this.modelId;
    }

    public int getMaxCutCount() {
        return this.maxCutCount;
    }

    public int getCurrentCutCount() {
        return this.currentCutCount;
    }

    public ItemStack getCurrentCutStack() {
        return this.currentCutStack;
    }
}

