/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.ISteamer;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.SteamerBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.SteamerRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SteamerBlockEntity
extends BaseBlockEntity
implements ISteamer {
    public static final int MAX_LIT_LEVEL = 4;
    public static final String COOKING_PROGRESS_TAG = "CookingProgress";
    public static final String COOKING_TIME_TAG = "CookingTime";
    public static final String ITEMS_TAG = "Items";
    private final RecipeManager.CachedCheck<SingleRecipeInput, SteamerRecipe> quickCheck = RecipeManager.createCheck(ModRecipes.STEAMER_RECIPE);
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private final int[] cookingProgress = new int[8];
    private final int[] cookingTime = new int[8];
    private int litLevel = 0;

    public SteamerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.STEAMER_BE.get(), pos, state);
    }

    public void tick(Level level) {
        if (level.getGameTime() % 5L == 0L) {
            this.updateLitLevel(level);
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.cookingTime[i] != -1) continue;
                this.makeRipeParticles(level, this.worldPosition);
                break;
            }
        }
        if (this.litLevel > 0) {
            this.cookingTick(level, this.worldPosition, this.getBlockState(), this);
        } else {
            this.cooldownTick(level, this.worldPosition, this.getBlockState(), this);
        }
    }

    public void mergeItem(ItemStack stack, Level level) {
        int length;
        int[] times;
        CompoundTag data = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        NonNullList merge = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        int[] mergeCookingProgress = new int[8];
        int[] mergeCookingTime = new int[8];
        if (data.contains(ITEMS_TAG, 9)) {
            NonNullList itemsInStack = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)data, (NonNullList)itemsInStack, (HolderLookup.Provider)level.registryAccess());
            for (int i = 0; i < 4; ++i) {
                merge.set(i + 4, (Object)((ItemStack)itemsInStack.get(i)));
            }
        }
        if (data.contains(COOKING_PROGRESS_TAG, 11)) {
            times = data.getIntArray(COOKING_PROGRESS_TAG);
            length = Math.min(mergeCookingProgress.length - 4, times.length);
            System.arraycopy(times, 0, mergeCookingProgress, 4, length);
        }
        if (data.contains(COOKING_TIME_TAG, 11)) {
            times = data.getIntArray(COOKING_TIME_TAG);
            length = Math.min(mergeCookingTime.length - 4, times.length);
            System.arraycopy(times, 0, mergeCookingTime, 4, length);
        }
        for (int i = 0; i < 4; ++i) {
            merge.set(i, (Object)((ItemStack)this.items.get(i)));
            mergeCookingProgress[i] = this.cookingProgress[i];
            mergeCookingTime[i] = this.cookingTime[i];
        }
        ContainerHelper.saveAllItems((CompoundTag)data, (NonNullList)merge, (boolean)false, (HolderLookup.Provider)level.registryAccess());
        data.putIntArray(COOKING_PROGRESS_TAG, mergeCookingProgress);
        data.putIntArray(COOKING_TIME_TAG, mergeCookingTime);
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.getType(), (CompoundTag)data);
    }

    public List<ItemStack> dropAsItem(Level level) {
        ArrayList drops = Lists.newArrayList();
        boolean half = (Boolean)this.getBlockState().getValue((Property)SteamerBlock.HALF);
        ItemStack first = ((Item)ModItems.STEAMER.get()).getDefaultInstance();
        if (this.items.stream().allMatch(ItemStack::isEmpty)) {
            drops.add(first);
            if (!half) {
                drops.add(((Item)ModItems.STEAMER.get()).getDefaultInstance());
            }
            return drops;
        }
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        SteamerBlockEntity.saveSplit(tag1, tag2, level, this.items, this.cookingProgress, this.cookingTime);
        BlockItem.setBlockEntityData((ItemStack)first, (BlockEntityType)this.getType(), (CompoundTag)tag1);
        drops.add(first);
        if (!half) {
            ItemStack second = ((Item)ModItems.STEAMER.get()).getDefaultInstance();
            BlockItem.setBlockEntityData((ItemStack)second, (BlockEntityType)this.getType(), (CompoundTag)tag2);
            drops.add(second);
        }
        return drops;
    }

    @Override
    public void updateLitLevel(Level level) {
        BlockPos pos = this.getBlockPos();
        if (this.hasHeatSource(level)) {
            this.litLevel = 4;
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos.below());
            if (blockEntity instanceof SteamerBlockEntity) {
                SteamerBlockEntity steamer = (SteamerBlockEntity)blockEntity;
                this.litLevel = (Boolean)steamer.getBlockState().getValue((Property)SteamerBlock.HALF) != false ? 0 : Math.max(steamer.litLevel - 1, 0);
            }
        }
    }

    @Override
    public boolean hasHeatSource(Level level) {
        BlockState belowState = level.getBlockState(this.worldPosition.below());
        if (belowState.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)belowState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return true;
        }
        return belowState.is(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    private void cookingTick(Level level, BlockPos pos, BlockState state, SteamerBlockEntity steamer) {
        BlockState aboveState = level.getBlockState(pos.above());
        boolean aboveIsSteamer = aboveState.is((Block)ModBlocks.STEAMER.get());
        if (!aboveIsSteamer) {
            this.makeCookingParticles(level, pos);
            if (!((Boolean)state.getValue((Property)SteamerBlock.HAS_LID)).booleanValue()) {
                return;
            }
        }
        boolean hasCooking = false;
        for (int i = 0; i < steamer.items.size(); ++i) {
            SingleRecipeInput container;
            ItemStack resultStack;
            int progress;
            ItemStack stack = (ItemStack)steamer.items.get(i);
            if (stack.isEmpty()) continue;
            hasCooking = true;
            int n = i;
            steamer.cookingProgress[n] = steamer.cookingProgress[n] + 1;
            if (progress < steamer.cookingTime[i] || (resultStack = steamer.quickCheck.getRecipeFor((RecipeInput)(container = new SingleRecipeInput(stack)), level).map(r -> ((SteamerRecipe)r.value()).assemble(container, (HolderLookup.Provider)level.registryAccess())).orElse(stack)).isEmpty()) continue;
            steamer.items.set(i, (Object)resultStack);
            steamer.cookingTime[i] = -1;
            level.sendBlockUpdated(pos, state, state, 3);
        }
        if (hasCooking) {
            SteamerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void cooldownTick(Level level, BlockPos pos, BlockState state, SteamerBlockEntity steamer) {
        boolean hasCooking = false;
        for (int i = 0; i < steamer.items.size(); ++i) {
            if (steamer.cookingProgress[i] <= 0) continue;
            hasCooking = true;
            steamer.cookingProgress[i] = Mth.clamp((int)(steamer.cookingProgress[i] - 2), (int)0, (int)steamer.cookingTime[i]);
        }
        if (hasCooking) {
            SteamerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void makeCookingParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.random.nextFloat() < 0.1f) {
                RandomSource random = serverLevel.random;
                boolean half = (Boolean)this.getBlockState().getValue((Property)SteamerBlock.HALF);
                double yOffset = half ? 0.5 : 1.0;
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)pos.getX() + 0.5 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + yOffset + random.nextDouble() / 2.0, (double)pos.getZ() + 0.5 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    public void makeRipeParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.random.nextFloat() < 0.5f) {
                RandomSource random = serverLevel.random;
                boolean half = (Boolean)this.getBlockState().getValue((Property)SteamerBlock.HALF);
                double yOffset = half ? 0.25 : 0.75;
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)pos.getX() + 0.5 + random.nextDouble() / 1.25 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + yOffset + random.nextDouble() / 2.0, (double)pos.getZ() + 0.5 + random.nextDouble() / 1.25 * (double)(random.nextBoolean() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    public Optional<RecipeHolder<SteamerRecipe>> getSteamerRecipe(Level level, ItemStack stack) {
        if (this.items.stream().noneMatch(ItemStack::isEmpty)) {
            return Optional.empty();
        }
        return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), level);
    }

    @Override
    public boolean placeFood(Level level, LivingEntity user, ItemStack food) {
        int startIndex;
        if (!level.isEmptyBlock(this.getBlockPos().above())) {
            return false;
        }
        if (((Boolean)this.getBlockState().getValue((Property)SteamerBlock.HAS_LID)).booleanValue()) {
            return false;
        }
        Optional<RecipeHolder<SteamerRecipe>> steamerRecipe = this.getSteamerRecipe(level, food);
        if (steamerRecipe.isEmpty()) {
            return false;
        }
        int cookTime = ((SteamerRecipe)steamerRecipe.get().value()).getCookTick();
        if (cookTime <= 0) {
            return false;
        }
        for (int i = startIndex = (half = ((Boolean)this.getBlockState().getValue((Property)SteamerBlock.HALF)).booleanValue()) ? 0 : 4; i < startIndex + 4; ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.cookingTime[i] = cookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)food.split(1));
        }
        this.refresh();
        return true;
    }

    @Override
    public boolean takeFood(Level level, LivingEntity user) {
        if (!level.isEmptyBlock(this.getBlockPos().above())) {
            return false;
        }
        BlockState blockState = this.getBlockState();
        if (((Boolean)blockState.getValue((Property)SteamerBlock.HAS_LID)).booleanValue()) {
            return false;
        }
        boolean isAllEmpty = true;
        boolean half = (Boolean)blockState.getValue((Property)SteamerBlock.HALF);
        int startIndex = half ? 4 : 8;
        for (int i = startIndex - 1; i >= startIndex - 4; --i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty()) continue;
            isAllEmpty = false;
            ItemUtils.getItemToLivingEntity(user, stack);
            this.items.set(i, (Object)ItemStack.EMPTY);
            this.cookingTime[i] = 0;
            this.cookingProgress[i] = 0;
        }
        if (isAllEmpty) {
            int n;
            if (user instanceof Player) {
                Player player = (Player)user;
                n = player.getInventory().selected;
            } else {
                n = -1;
            }
            int preferredSlot = n;
            ItemUtils.getItemToLivingEntity(user, ((Item)ModItems.STEAMER.get()).getDefaultInstance(), preferredSlot);
            for (int i = 4; i < 8; ++i) {
                this.items.set(i, (Object)ItemStack.EMPTY);
                this.cookingTime[i] = 0;
                this.cookingProgress[i] = 0;
            }
            level.playSound(null, this.getBlockPos(), blockState.getSoundType().getBreakSound(), SoundSource.BLOCKS);
            if (half) {
                level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            } else {
                this.setChanged();
                level.setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue((Property)SteamerBlock.HALF, (Comparable)Boolean.valueOf(true)));
            }
        } else {
            this.refresh();
        }
        return true;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        int length;
        int[] times;
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains(COOKING_PROGRESS_TAG, 11)) {
            times = tag.getIntArray(COOKING_PROGRESS_TAG);
            length = Math.min(this.cookingTime.length, times.length);
            System.arraycopy(times, 0, this.cookingProgress, 0, length);
        }
        if (tag.contains(COOKING_TIME_TAG, 11)) {
            times = tag.getIntArray(COOKING_TIME_TAG);
            length = Math.min(this.cookingTime.length, times.length);
            System.arraycopy(times, 0, this.cookingTime, 0, length);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        tag.putIntArray(COOKING_PROGRESS_TAG, this.cookingProgress);
        tag.putIntArray(COOKING_TIME_TAG, this.cookingTime);
    }

    public static void saveSplit(CompoundTag tag1, CompoundTag tag2, Level level, NonNullList<ItemStack> items, int[] cookingProgress, int[] cookingTime) {
        NonNullList first = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        NonNullList second = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 4; ++i) {
            first.set(i, (Object)((ItemStack)items.get(i)));
            second.set(i, (Object)((ItemStack)items.get(i + 4)));
        }
        int[] firstCookingProgress = new int[4];
        int[] secondCookingProgress = new int[4];
        int[] firstCookingTime = new int[4];
        int[] secondCookingTime = new int[4];
        System.arraycopy(cookingProgress, 0, firstCookingProgress, 0, 4);
        System.arraycopy(cookingProgress, 4, secondCookingProgress, 0, 4);
        System.arraycopy(cookingTime, 0, firstCookingTime, 0, 4);
        System.arraycopy(cookingTime, 4, secondCookingTime, 0, 4);
        ContainerHelper.saveAllItems((CompoundTag)tag1, (NonNullList)first, (boolean)false, (HolderLookup.Provider)level.registryAccess());
        if (!tag1.isEmpty()) {
            tag1.putIntArray(COOKING_PROGRESS_TAG, firstCookingProgress);
            tag1.putIntArray(COOKING_TIME_TAG, firstCookingTime);
        }
        ContainerHelper.saveAllItems((CompoundTag)tag2, (NonNullList)second, (boolean)false, (HolderLookup.Provider)level.registryAccess());
        if (!tag2.isEmpty()) {
            tag2.putIntArray(COOKING_PROGRESS_TAG, secondCookingProgress);
            tag2.putIntArray(COOKING_TIME_TAG, secondCookingTime);
        }
    }

    public int[] getCookingProgress() {
        return this.cookingProgress;
    }

    public int[] getCookingTime() {
        return this.cookingTime;
    }
}

