/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.event;

import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;

@EventBusSubscriber(modid="kaleidoscope_cookery", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModModelEvent {
    private static final String MODELS = "models/";
    private static final String MODELS_CHOPPING_BOARD = "models/chopping_board";
    private static final String MODELS_CARPET = "models/block/carpet";
    private static final String JSON = ".json";

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        resourceManager.listResources(MODELS_CHOPPING_BOARD, id -> id.getPath().endsWith(JSON)).keySet().stream().map(ModModelEvent::handleModelId).forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        resourceManager.listResources(MODELS_CARPET, id -> id.getPath().endsWith(JSON)).keySet().stream().map(ModModelEvent::handleModelId).forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"item/honey")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"item/egg")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"item/raw_dough_in_millstone")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"item/oil_in_millstone")));
        ItemRenderReplacer.resetCache();
    }

    private static ModelResourceLocation handleModelId(ResourceLocation input) {
        String namespace = input.getNamespace();
        String path = input.getPath();
        String substring = path.substring(MODELS.length(), path.length() - JSON.length());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)substring);
        return ModelResourceLocation.standalone((ResourceLocation)id);
    }
}

