/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.model;

import com.github.ysbbbbbb.kaleidoscopecookery.entity.ScarecrowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public class ScarecrowModel
extends EntityModel<ScarecrowEntity>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"scarecrow"), "main");
    private final ModelPart group;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart leftArm;
    private final ModelPart rightArm;

    public ScarecrowModel(ModelPart root) {
        this.group = root.getChild("group");
        this.head = this.group.getChild("head");
        this.hat = this.head.getChild("hat");
        this.rightArm = this.group.getChild("rightArm");
        this.leftArm = this.group.getChild("leftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition group = partdefinition.addOrReplaceChild("group", CubeListBuilder.create().texOffs(85, 82).addBox(-4.0f, -26.0278f, -2.0278f, 8.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(54, 69).addBox(-4.0f, -17.0278f, -2.0278f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(73, 60).addBox(8.0f, -26.0278f, -2.0278f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(73, 60).mirror().addBox(-8.0f, -26.0278f, -2.0278f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(10, 107).addBox(-14.0f, -25.7778f, -1.0278f, 28.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(101, 65).addBox(4.0f, -26.0278f, -2.0278f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(82, 65).addBox(-9.0f, -26.0278f, -2.0278f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(28, 70).addBox(-1.0f, -18.0278f, -1.0278f, 2.0f, 19.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0278f, (float)0.0278f));
        PartDefinition head = group.addOrReplaceChild("head", CubeListBuilder.create().texOffs(13, 3).addBox(-4.5f, -32.2278f, -4.3778f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.8f, (float)0.1f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.1198f, (float)-30.4846f, (float)0.5972f));
        PartDefinition headwear_r1 = hat.addOrReplaceChild("headwear_r1", CubeListBuilder.create().texOffs(66, 8).addBox(-5.0f, -3.775f, -5.025f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(77, 25).addBox(-8.0f, 1.275f, -7.975f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition rightArm = group.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-12.0f, (float)-24.8f, (float)-0.05f));
        PartDefinition leftArm = group.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)12.0f, (float)-24.8f, (float)-0.05f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ScarecrowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.HEAD);
        this.head.visible = stack.isEmpty();
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.group.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        if (arm == HumanoidArm.LEFT) {
            this.leftArm.translateAndRotate(poseStack);
        } else {
            this.rightArm.translateAndRotate(poseStack);
        }
    }

    public ModelPart getHead() {
        return this.head;
    }
}

