/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ScarecrowEntity
extends LivingEntity {
    public static final EntityType<ScarecrowEntity> TYPE = EntityType.Builder.of(ScarecrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 2.375f).clientTrackingRange(10).build("scarecrow");
    private static final EntityDataAccessor<CompoundTag> DATA_SHOULDER = SynchedEntityData.defineId(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final Predicate<Entity> RIDABLE_MINECARTS = e -> {
        AbstractMinecart minecart;
        return e instanceof AbstractMinecart && (minecart = (AbstractMinecart)e).canBeRidden();
    };
    private static final Predicate<Entity> SHOULDER_RIDING_ENTITY = e -> {
        ShoulderRidingEntity entity;
        return e instanceof ShoulderRidingEntity && !(entity = (ShoulderRidingEntity)e).isOrderedToSit() && entity.canSitOnShoulder();
    };
    private static final String HAND_ITEMS_TAG = "HandItems";
    private static final String ARMOR_ITEMS_TAG = "ArmorItems";
    private static final String SHOULDER_ENTITY_TAG = "ShoulderEntity";
    private final NonNullList<ItemStack> handItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public long lastHit;
    private int cooldown;
    private long timeEntitySatOnShoulder;

    public ScarecrowEntity(EntityType<ScarecrowEntity> type, Level level) {
        super(type, level);
    }

    public ScarecrowEntity(Level level, double pX, double pY, double pZ) {
        this(TYPE, level);
        this.setPos(pX, pY, pZ);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ScarecrowEntity.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SHOULDER, (Object)new CompoundTag());
    }

    public void tick() {
        super.tick();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public InteractionResult interactAt(Player player, Vec3 vec3, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(Items.NAME_TAG)) {
            return InteractionResult.PASS;
        }
        if (player.isSpectator()) {
            return InteractionResult.SUCCESS;
        }
        if (player.level().isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (this.cooldown > 0) {
            return InteractionResult.PASS;
        }
        if (this.isClickHand(vec3)) {
            return this.handleHandItems(player, itemInHand);
        }
        if (this.isClickHead(vec3)) {
            return this.handleHeadItems(player, itemInHand);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleHeadItems(Player player, ItemStack itemInHand) {
        BlockItem blockItem;
        this.cooldown = 5;
        ItemStack headItem = this.getItemBySlot(EquipmentSlot.HEAD);
        if (itemInHand.isEmpty() && !headItem.isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)headItem);
            return InteractionResult.SUCCESS;
        }
        Item item = itemInHand.getItem();
        if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof SkullBlock)) {
            return InteractionResult.PASS;
        }
        if (player.getAbilities().instabuild && headItem.isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, itemInHand.copyWithCount(1));
            this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_FRAME_ADD_ITEM, this.getSoundSource());
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "place_head_on_scarecrow");
            return InteractionResult.SUCCESS;
        }
        if (!itemInHand.isEmpty() && itemInHand.getCount() > 1) {
            if (headItem.isEmpty()) {
                this.setItemSlot(EquipmentSlot.HEAD, itemInHand.split(1));
                this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_FRAME_ADD_ITEM, this.getSoundSource());
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "place_head_on_scarecrow");
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        this.setItemSlot(EquipmentSlot.HEAD, itemInHand);
        this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_FRAME_ADD_ITEM, this.getSoundSource());
        player.setItemInHand(InteractionHand.MAIN_HAND, headItem);
        ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "place_head_on_scarecrow");
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleHandItems(Player player, ItemStack itemInHand) {
        BlockItem blockItem;
        this.cooldown = 5;
        if (itemInHand.isEmpty()) {
            ItemStack mainhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack offhand = this.getItemInHand(InteractionHand.OFF_HAND);
            if (!mainhand.isEmpty()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)mainhand);
                return InteractionResult.SUCCESS;
            }
            if (!offhand.isEmpty()) {
                this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)offhand);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        Item item = itemInHand.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof LanternBlock && this.swapHand(InteractionHand.OFF_HAND, player, itemInHand)) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.LANTERN_PLACE, this.getSoundSource());
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.has(DataComponents.DAMAGE) && this.swapHand(InteractionHand.MAIN_HAND, player, itemInHand)) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_FRAME_ADD_ITEM, this.getSoundSource());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean swapHand(InteractionHand hand, Player player, ItemStack itemInHand) {
        ItemStack scarecrowStack = this.getItemInHand(hand);
        if (player.getAbilities().instabuild && scarecrowStack.isEmpty() && !itemInHand.isEmpty()) {
            this.setItemInHand(hand, itemInHand.copyWithCount(1));
            return true;
        }
        if (!itemInHand.isEmpty() && itemInHand.getCount() > 1) {
            if (scarecrowStack.isEmpty()) {
                this.setItemInHand(hand, itemInHand.split(1));
                return true;
            }
            return false;
        }
        this.setItemInHand(hand, itemInHand);
        player.setItemInHand(InteractionHand.MAIN_HAND, scarecrowStack);
        return true;
    }

    private boolean isClickHand(Vec3 vector) {
        return 1.0625 <= vector.y && vector.y <= 1.588235294117647;
    }

    private boolean isClickHead(Vec3 vector) {
        return 1.588235294117647 < vector.y;
    }

    public boolean hurt(DamageSource source, float amount) {
        ServerLevel serverLevel;
        block14: {
            block13: {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block13;
                serverLevel = (ServerLevel)level;
                if (!this.isRemoved()) break block14;
            }
            return false;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.kill();
            return false;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            this.brokenByAnything(serverLevel, source);
            this.kill();
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().mayBuild) {
                return false;
            }
        }
        if (source.isCreativePlayer()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.kill();
            return false;
        }
        long gameTime = this.level().getGameTime();
        if (gameTime - this.lastHit > 5L) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f);
            this.level().broadcastEntityEvent((Entity)this, (byte)32);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
            this.lastHit = gameTime;
            if (!this.getShoulderEntity().isEmpty()) {
                this.removeEntitiesOnShoulder();
            }
        } else {
            this.brokenByPlayer(serverLevel, source);
            this.showBreakingParticles();
            this.kill();
        }
        return true;
    }

    public void handleEntityEvent(byte id) {
        if (id == 32) {
            if (this.level().isClientSide) {
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void brokenByPlayer(ServerLevel level, DamageSource damageSource) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SCARECROW.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)stack);
        this.brokenByAnything(level, damageSource);
    }

    private void brokenByAnything(ServerLevel level, DamageSource damageSource) {
        ItemStack stack;
        int i;
        this.playBrokenSound();
        this.dropAllDeathLoot(level, damageSource);
        for (i = 0; i < this.handItems.size(); ++i) {
            stack = (ItemStack)this.handItems.get(i);
            if (stack.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)stack);
            this.handItems.set(i, (Object)ItemStack.EMPTY);
        }
        for (i = 0; i < this.armorItems.size(); ++i) {
            stack = (ItemStack)this.armorItems.get(i);
            if (stack.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)stack);
            this.armorItems.set(i, (Object)ItemStack.EMPTY);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.blockPosition(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    private void showBreakingParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState());
            serverLevel.sendParticles((ParticleOptions)particleOption, this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private boolean setEntityOnShoulder(CompoundTag tag) {
        if (this.canEntityOnShoulder()) {
            this.setShoulderEntity(tag);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        return false;
    }

    private void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            this.respawnEntityOnShoulder(this.getShoulderEntity());
            this.setShoulderEntity(new CompoundTag());
        }
    }

    private void respawnEntityOnShoulder(CompoundTag tag) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!tag.isEmpty()) {
                EntityType.create((CompoundTag)tag, (Level)this.level()).ifPresent(entity -> {
                    entity.setPos(this.getX(), this.getY() + 1.675, this.getZ());
                    serverLevel.addWithUUID(entity);
                });
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        RegistryAccess registryAccess = this.level().registryAccess();
        tag.put(HAND_ITEMS_TAG, (Tag)new ItemStackHandler(this.handItems).serializeNBT((HolderLookup.Provider)registryAccess));
        tag.put(ARMOR_ITEMS_TAG, (Tag)new ItemStackHandler(this.armorItems).serializeNBT((HolderLookup.Provider)registryAccess));
        if (!this.getShoulderEntity().isEmpty()) {
            tag.put(SHOULDER_ENTITY_TAG, (Tag)this.getShoulderEntity());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        ItemStack stack;
        int i;
        ItemStackHandler handler;
        RegistryAccess registryAccess = this.level().registryAccess();
        super.readAdditionalSaveData(tag);
        if (tag.contains(HAND_ITEMS_TAG)) {
            handler = new ItemStackHandler();
            handler.deserializeNBT((HolderLookup.Provider)registryAccess, tag.getCompound(HAND_ITEMS_TAG));
            for (i = 0; i < this.handItems.size(); ++i) {
                stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.handItems.set(i, (Object)stack);
            }
        }
        if (tag.contains(ARMOR_ITEMS_TAG)) {
            handler = new ItemStackHandler();
            handler.deserializeNBT((HolderLookup.Provider)registryAccess, tag.getCompound(ARMOR_ITEMS_TAG));
            for (i = 0; i < this.armorItems.size(); ++i) {
                stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.armorItems.set(i, (Object)stack);
            }
        }
        if (tag.contains(SHOULDER_ENTITY_TAG, 10)) {
            this.setShoulderEntity(tag.getCompound(SHOULDER_ENTITY_TAG));
        }
    }

    protected float tickHeadTurn(float yRot, float animStep) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    public void setYBodyRot(float offset) {
        this.yBodyRotO = this.yRotO = offset;
        this.yHeadRotO = this.yHeadRot = offset;
    }

    public void setYHeadRot(float rotation) {
        this.yBodyRotO = this.yRotO = rotation;
        this.yHeadRotO = this.yHeadRot = rotation;
    }

    public void kill() {
        if (!this.getShoulderEntity().isEmpty()) {
            this.removeEntitiesOnShoulder();
        }
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox(), RIDABLE_MINECARTS);
        for (Entity entity : list) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push((Entity)this);
            return;
        }
        if (this.canEntityOnShoulder()) {
            list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(2.0), SHOULDER_RIDING_ENTITY);
            for (Entity entity : list) {
                ShoulderRidingEntity shoulderEntity;
                if (!(this.distanceToSqr(entity) <= 1.5) || !(entity instanceof ShoulderRidingEntity) || !this.setEntityOnShoulder(shoulderEntity = (ShoulderRidingEntity)entity)) continue;
                return;
            }
        }
    }

    private boolean setEntityOnShoulder(ShoulderRidingEntity entity) {
        CompoundTag tag = new CompoundTag();
        String id = entity.getEncodeId();
        if (id == null) {
            return false;
        }
        tag.putString("id", id);
        entity.saveWithoutId(tag);
        if (this.setEntityOnShoulder(tag)) {
            entity.discard();
            return true;
        }
        return false;
    }

    private boolean canEntityOnShoulder() {
        return !this.isPassenger() && this.onGround() && !this.isInWater() && !this.isInPowderSnow && this.getShoulderEntity().isEmpty();
    }

    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return switch (slot.getType()) {
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handItems.get(slot.getIndex());
            case EquipmentSlot.Type.HUMANOID_ARMOR -> (ItemStack)this.armorItems.get(slot.getIndex());
            default -> ItemStack.EMPTY;
        };
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.verifyEquippedItem(stack);
        switch (slot.getType()) {
            case HAND: {
                this.onEquipItem(slot, (ItemStack)this.handItems.set(slot.getIndex(), (Object)stack), stack);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(slot, (ItemStack)this.armorItems.set(slot.getIndex(), (Object)stack), stack);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean skipAttackInteraction(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (this.level().mayInteract(player, this.blockPosition())) return false;
        return true;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel level, LightningBolt lightningBolt) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.SCARECROW.get());
    }

    public CompoundTag getShoulderEntity() {
        return (CompoundTag)this.entityData.get(DATA_SHOULDER);
    }

    public void setShoulderEntity(CompoundTag tag) {
        this.entityData.set(DATA_SHOULDER, (Object)tag);
    }
}

