/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.FruitBasketBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="kaleidoscope_cookery")
public class RightClickEvent {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack itemInHand = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && hand == InteractionHand.MAIN_HAND && !itemInHand.is(Items.DEBUG_STICK) && (blockEntity = level.getBlockEntity(pos)) instanceof FruitBasketBlockEntity) {
            FruitBasketBlockEntity fruitBasketBlock = (FruitBasketBlockEntity)blockEntity;
            fruitBasketBlock.takeOut(player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Chicken chicken;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        if (target instanceof Chicken && (chicken = (Chicken)target).isBaby() && player.getMainHandItem().is((Item)ModItems.CATERPILLAR.get())) {
            chicken.setAge(0);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, chicken.getX(), chicken.getY() + 0.25, chicken.getZ(), 5, 0.2, 0.1, 0.2, 0.1);
                serverLevel.playSound(null, chicken.getX(), chicken.getY(), chicken.getZ(), SoundEvents.PARROT_EAT, chicken.getSoundSource(), 1.0f, 1.0f + (serverLevel.random.nextFloat() - serverLevel.random.nextFloat()) * 0.2f);
            }
            player.getMainHandItem().shrink(1);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "use_caterpillar_feed_chicken");
        }
    }
}

