/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event.recipe;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.MillstoneFinishEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.OilPotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class MillstoneSpecialFinishEvent {
    @SubscribeEvent
    public static void onMillstoneTakeItem(MillstoneFinishEvent event) {
        MillstoneBlockEntity millstone = event.getMillstone();
        ItemStack output = millstone.getOutput();
        Level level = millstone.getLevel();
        if (level == null) {
            return;
        }
        if (output.is((Item)ModItems.OIL_POT.get())) {
            MillstoneSpecialFinishEvent.onGetOilPot(millstone, level, output);
            return;
        }
        if (output.is((Item)ModItems.RAW_DOUGH.get())) {
            MillstoneSpecialFinishEvent.onGetRawDough(millstone, level, output);
        }
    }

    private static void onGetRawDough(MillstoneBlockEntity millstone, Level level, ItemStack output) {
        BlockPos below = millstone.getBlockPos().below();
        BlockState blockState = level.getBlockState(below);
        if (!blockState.is(Blocks.WATER_CAULDRON)) {
            return;
        }
        ItemEntity entity = new ItemEntity(level, (double)below.getX() + 0.5, (double)below.getY() + 0.2, (double)below.getZ() + 0.5, output.copy());
        entity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)entity);
        millstone.resetWhenTakeout();
    }

    private static void onGetOilPot(MillstoneBlockEntity millstone, Level level, ItemStack output) {
        BlockPos below = millstone.getBlockPos().below();
        BlockState blockState = level.getBlockState(below);
        if (!blockState.is((Block)ModBlocks.OIL_POT.get())) {
            return;
        }
        int oilCount = (Integer)blockState.getValue((Property)OilPotBlock.OIL_COUNT);
        if (oilCount >= 8) {
            return;
        }
        RandomSource random = level.getRandom();
        if (random.nextInt(8) < output.getCount()) {
            level.setBlockAndUpdate(below, (BlockState)blockState.setValue((Property)OilPotBlock.OIL_COUNT, (Comparable)Integer.valueOf(oilCount + 1)));
        }
        millstone.resetWhenTakeout();
    }
}

