/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.inventory.itemhandler;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MillstoneOutputHandler
implements IItemHandler {
    private final MillstoneBlockEntity millstone;

    public MillstoneOutputHandler(MillstoneBlockEntity millstone) {
        this.millstone = millstone;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.millstone.getOutput();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        if (!this.millstone.getCarrier().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack output = this.millstone.getOutput();
        if (output.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            return output.copyWithCount(amount);
        }
        ItemStack split = output.split(amount);
        this.millstone.refresh();
        return split;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return false;
    }
}

