/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.RecipeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModDataComponents;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.tooltip.RecipeItemTooltip;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeItem
extends BlockItem {
    public static final ResourceLocation HAS_RECIPE_PROPERTY = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"has_recipe");
    public static final ResourceLocation POT = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"pot");
    public static final ResourceLocation STOCKPOT = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"stockpot");
    private static final int NO_RECIPE = 0;
    private static final int HAS_RECIPE = 1;

    public RecipeItem() {
        super((Block)ModBlocks.RECIPE_BLOCK.get(), new Item.Properties());
    }

    public static void setRecipe(ItemStack stack, RecipeRecord record) {
        stack.set(ModDataComponents.RECIPE_RECORD, (Object)record);
    }

    @Nullable
    public static RecipeRecord getRecipe(ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof RecipeItem)) {
            return null;
        }
        return (RecipeRecord)stack.get(ModDataComponents.RECIPE_RECORD);
    }

    public static boolean hasRecipe(ItemStack stack) {
        return stack.has(ModDataComponents.RECIPE_RECORD);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (RecipeItem.hasRecipe(stack)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public Component getName(ItemStack pStack) {
        RecipeRecord recipe;
        if (RecipeItem.hasRecipe(pStack) && (recipe = RecipeItem.getRecipe(pStack)) != null) {
            Component result = recipe.output().getHoverName();
            MutableComponent type = recipe.type().equals((Object)POT) ? Component.translatable((String)"block.kaleidoscope_cookery.pot") : (recipe.type().equals((Object)STOCKPOT) ? Component.translatable((String)"block.kaleidoscope_cookery.stockpot") : Component.empty());
            return Component.translatable((String)"block.kaleidoscope_cookery.recipe_block.has_record", (Object[])new Object[]{result, type});
        }
        return super.getName(pStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemInHand = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        BlockEntity blockEntity = context.getLevel().getBlockEntity(clickedPos);
        RecipeManager recipeManager = context.getLevel().getRecipeManager();
        if (blockEntity == null) {
            return super.useOn(context);
        }
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        if (RecipeItem.hasRecipe(itemInHand)) {
            return this.onPutRecipe(blockEntity, player, itemInHand);
        }
        return this.onRecordRecipe(context, blockEntity, recipeManager, itemInHand);
    }

    private InteractionResult onPutRecipe(BlockEntity blockEntity, Player player, ItemStack itemInHand) {
        StockpotBlockEntity stockpot;
        PotBlockEntity pot;
        RecipeRecord record = RecipeItem.getRecipe(itemInHand);
        if (record == null) {
            return InteractionResult.PASS;
        }
        if (blockEntity instanceof PotBlockEntity && (pot = (PotBlockEntity)blockEntity).getStatus() == 0 && ((Boolean)pot.getBlockState().getValue((Property)PotBlock.HAS_OIL)).booleanValue() && record.type().equals((Object)POT)) {
            List<ItemStack> inputs = pot.getInputs().stream().filter(s -> !s.isEmpty()).toList();
            if (!inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            return this.handlePutRecipe(player, record, () -> pot.addAllIngredients(record.input(), (LivingEntity)player));
        }
        if (blockEntity instanceof StockpotBlockEntity && (stockpot = (StockpotBlockEntity)blockEntity).getStatus() == 1 && record.type().equals((Object)STOCKPOT)) {
            List<ItemStack> inputs = stockpot.getInputs().stream().filter(s -> !s.isEmpty()).toList();
            if (!inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            return this.handlePutRecipe(player, record, () -> stockpot.addAllIngredients(record.input(), (LivingEntity)player));
        }
        return InteractionResult.PASS;
    }

    @NotNull
    private InteractionResult handlePutRecipe(Player player, RecipeRecord record, Runnable success) {
        Reference2IntOpenHashMap need = new Reference2IntOpenHashMap();
        for (ItemStack s : record.input()) {
            if (s.isEmpty()) continue;
            Item item = s.getItem();
            need.put((Object)item, need.getInt((Object)item) + 1);
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.getInventory());
        Reference2IntOpenHashMap supply = new Reference2IntOpenHashMap();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack s = inventory.getStackInSlot(slot);
            if (s.isEmpty()) continue;
            RecipeItemEvent.CheckItem event = new RecipeItemEvent.CheckItem(s, (Reference2IntMap<Item>)supply);
            NeoForge.EVENT_BUS.post((Event)event);
            Item item = s.getItem();
            supply.put((Object)item, supply.getInt((Object)item) + s.getCount());
        }
        Reference2IntOpenHashMap missing = new Reference2IntOpenHashMap();
        for (Item item : need.keySet()) {
            if (supply.getInt((Object)item) >= need.getInt((Object)item)) continue;
            missing.put((Object)item, need.getInt((Object)item) - supply.getInt((Object)item));
        }
        if (!missing.isEmpty()) {
            MutableComponent component = Component.translatable((String)"tooltip.kaleidoscope_cookery.recipe_item.missing");
            int i = 0;
            for (Item s : missing.keySet()) {
                Component hoverName = s.getDefaultInstance().getHoverName();
                MutableComponent count = Component.literal((String)"\u00d7%d".formatted(missing.getInt((Object)s)));
                if (i != 0) {
                    component = component.append(CommonComponents.SPACE);
                }
                component.append(CommonComponents.SPACE).append(hoverName).append((Component)count);
                ++i;
            }
            if (!player.level().isClientSide()) {
                player.sendSystemMessage((Component)component);
            }
            return InteractionResult.FAIL;
        }
        block4: for (Item item : need.keySet()) {
            int needCount = need.getInt((Object)item);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack inSlot = inventory.getStackInSlot(i);
                if (inSlot.isEmpty()) continue;
                RecipeItemEvent.DeductItem event = new RecipeItemEvent.DeductItem(inSlot, item, new int[]{needCount});
                NeoForge.EVENT_BUS.post((Event)event);
                needCount = event.getNeedCount();
                if (needCount <= 0) continue block4;
                if (!inSlot.is(item)) continue;
                int extracted = Math.min(needCount, inSlot.getCount());
                inventory.extractItem(i, extracted, false);
                if ((needCount -= extracted) <= 0) continue block4;
            }
        }
        success.run();
        return InteractionResult.SUCCESS;
    }

    private InteractionResult onRecordRecipe(UseOnContext context, BlockEntity blockEntity, RecipeManager recipeManager, ItemStack itemInHand) {
        StockpotBlockEntity stockpot;
        PotBlockEntity pot;
        Level level = context.getLevel();
        if (blockEntity instanceof PotBlockEntity && (pot = (PotBlockEntity)blockEntity).getStatus() == 0) {
            List<ItemStack> inputs = pot.getInputs().stream().filter(s -> !s.isEmpty()).toList();
            if (inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            recipeManager.getRecipeFor(ModRecipes.POT_RECIPE, (RecipeInput)pot.getContainer(), level).ifPresentOrElse(recipe -> {
                ItemStack resultItem = ((PotRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                RecipeItem.setRecipe(itemInHand, new RecipeRecord(inputs, resultItem, POT));
            }, () -> {
                ItemStack instance = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).getDefaultInstance();
                RecipeItem.setRecipe(itemInHand, new RecipeRecord(inputs, instance, POT));
            });
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof StockpotBlockEntity && (stockpot = (StockpotBlockEntity)blockEntity).getStatus() == 1) {
            List<ItemStack> inputs = stockpot.getInputs().stream().filter(s -> !s.isEmpty()).toList();
            if (inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            recipeManager.getRecipeFor(ModRecipes.STOCKPOT_RECIPE, (RecipeInput)stockpot.getContainer(), level).ifPresentOrElse(recipe -> {
                ItemStack resultItem = ((StockpotRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                RecipeItem.setRecipe(itemInHand, new RecipeRecord(inputs, resultItem, STOCKPOT));
            }, () -> {
                ItemStack instance = Items.SUSPICIOUS_STEW.getDefaultInstance();
                RecipeItem.setRecipe(itemInHand, new RecipeRecord(inputs, instance, STOCKPOT));
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (RecipeItem.hasRecipe(stack)) {
            RecipeRecord recipe = RecipeItem.getRecipe(stack);
            if (recipe == null) {
                return Optional.empty();
            }
            return Optional.of(new RecipeItemTooltip(recipe));
        }
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.recipe_item").withStyle(ChatFormatting.GRAY));
    }

    public record RecipeRecord(List<ItemStack> input, ItemStack output, ResourceLocation type) {
        public static final Codec<RecipeRecord> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("input").forGetter(RecipeRecord::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(RecipeRecord::output), (App)ResourceLocation.CODEC.fieldOf("type").forGetter(RecipeRecord::type)).apply((Applicative)instance, RecipeRecord::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeRecord> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RecipeRecord>(){

            public RecipeRecord decode(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readVarInt();
                ArrayList inputs = Lists.newArrayList();
                for (int i = 0; i < size; ++i) {
                    inputs.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
                }
                ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                ResourceLocation type = buffer.readResourceLocation();
                return new RecipeRecord(inputs, output, type);
            }

            public void encode(RegistryFriendlyByteBuf buffer, RecipeRecord value) {
                buffer.writeVarInt(value.input().size());
                for (ItemStack s : value.input()) {
                    ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)s);
                }
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)value.output());
                buffer.writeResourceLocation(value.type());
            }
        };

        public static RecipeRecord pot(ItemLike output, ItemLike ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(ItemStack::new).toList();
            return new RecipeRecord(inputList, new ItemStack(output), POT);
        }

        @SafeVarargs
        public static RecipeRecord pot(DeferredItem<Item> output, DeferredItem<Item> ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(s -> new ItemStack((ItemLike)s.get())).toList();
            return new RecipeRecord(inputList, new ItemStack((ItemLike)output.get()), POT);
        }

        public static RecipeRecord stockpot(ItemLike output, ItemLike ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(ItemStack::new).toList();
            return new RecipeRecord(inputList, new ItemStack(output), STOCKPOT);
        }

        @SafeVarargs
        public static RecipeRecord stockpot(DeferredItem<Item> output, DeferredItem<Item> ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(s -> new ItemStack((ItemLike)s.get())).toList();
            return new RecipeRecord(inputList, new ItemStack((ItemLike)output.get()), STOCKPOT);
        }
    }
}

