/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IStockpot;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StockpotBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_LID = BooleanProperty.m_61465_((String)"has_lid");
    public static final BooleanProperty HAS_BASE = BooleanProperty.m_61465_((String)"has_base");
    public static final BooleanProperty HAS_CHAINS = BooleanProperty.m_61465_((String)"has_chains");
    private static final VoxelShape AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));
    private static final VoxelShape AABB_WITH_LID = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));

    public StockpotBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(ModSoundType.POT).m_60955_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            IStockpot stockpot;
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IStockpot && (stockpot = (IStockpot)blockEntity).hasHeatSource(level)) {
                ModTrigger.EVENT.trigger((LivingEntity)player, "place_stockpot_on_heat_source");
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction == Direction.DOWN && !((Boolean)state.m_61143_((Property)HAS_CHAINS)).booleanValue()) {
            return (BlockState)((BlockState)state.m_61124_((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(StockpotBlock.m_49863_((LevelReader)levelAccessor, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN)))).m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(!neighborState.m_60783_((BlockGetter)levelAccessor, neighborPos, Direction.UP)));
        }
        if (direction == Direction.UP && !((Boolean)state.m_61143_((Property)HAS_BASE)).booleanValue()) {
            BlockState belowState = levelAccessor.m_8055_(pos.m_7495_());
            return (BlockState)((BlockState)state.m_61124_((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(StockpotBlock.m_49863_((LevelReader)levelAccessor, (BlockPos)neighborPos, (Direction)Direction.DOWN)))).m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(!belowState.m_60783_((BlockGetter)levelAccessor, pos.m_7495_(), Direction.UP)));
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IStockpot)) {
            return InteractionResult.PASS;
        }
        IStockpot stockpot = (IStockpot)blockEntity;
        ItemStack mainHandItem = player.m_21205_();
        if (stockpot.onLitClick(level, (LivingEntity)player, mainHandItem)) {
            return InteractionResult.SUCCESS;
        }
        if (stockpot.addSoupBase(level, (LivingEntity)player, mainHandItem)) {
            ModTrigger.EVENT.trigger((LivingEntity)player, "put_soup_base_in_stockpot");
            return InteractionResult.SUCCESS;
        }
        if (stockpot.removeSoupBase(level, (LivingEntity)player, mainHandItem)) {
            return InteractionResult.SUCCESS;
        }
        if (!mainHandItem.m_41619_() && stockpot.addIngredient(level, (LivingEntity)player, mainHandItem)) {
            return InteractionResult.SUCCESS;
        }
        if ((mainHandItem.m_41619_() || mainHandItem.m_204117_(TagMod.INGREDIENT_CONTAINER)) && stockpot.removeIngredient(level, (LivingEntity)player)) {
            return InteractionResult.SUCCESS;
        }
        if (stockpot.takeOutProduct(level, (LivingEntity)player, mainHandItem)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StockpotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return StockpotBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.STOCKPOT_BE.get(), (lvl, blockPos, blockState, pot) -> pot.clientTick());
        }
        return StockpotBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.STOCKPOT_BE.get(), (lvl, blockPos, blockState, pot) -> pot.tick(lvl));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        FluidState fluidState = level.m_6425_(context.m_8083_());
        Direction clickFace = context.m_43719_();
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        BlockPos abovePos = context.m_8083_().m_7494_();
        if (clickFace == Direction.DOWN && StockpotBlock.m_49863_((LevelReader)level, (BlockPos)abovePos, (Direction)Direction.DOWN)) {
            return (BlockState)blockState.m_61124_((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(true));
        }
        BlockPos belowPos = context.m_8083_().m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        if (!belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP)) {
            return (BlockState)blockState.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, HAS_LID, HAS_BASE, HAS_CHAINS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        if (((Boolean)state.m_61143_((Property)HAS_LID)).booleanValue()) {
            return AABB_WITH_LID;
        }
        return AABB;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder lootParamsBuilder) {
        StockpotBlockEntity stockpotBlock;
        BlockEntity parameter;
        List drops = super.m_49635_(state, lootParamsBuilder);
        if (((Boolean)state.m_61143_((Property)HAS_LID)).booleanValue()) {
            StockpotBlockEntity stockpot;
            parameter = (BlockEntity)lootParamsBuilder.m_287159_(LootContextParams.f_81462_);
            if (parameter instanceof StockpotBlockEntity && !(stockpot = (StockpotBlockEntity)parameter).getLidItem().m_41619_()) {
                drops.add(stockpot.getLidItem().m_41777_());
            } else {
                drops.add(new ItemStack((ItemLike)ModItems.STOCKPOT_LID.get()));
            }
        }
        if ((parameter = (BlockEntity)lootParamsBuilder.m_287261_(LootContextParams.f_81462_)) instanceof StockpotBlockEntity && (stockpotBlock = (StockpotBlockEntity)parameter).getStatus() == 1) {
            stockpotBlock.getInputs().forEach(stack -> {
                if (!stack.m_41619_()) {
                    drops.add(stack);
                }
            });
        }
        return drops;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.stockpot").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.stockpot.fail").m_130940_(ChatFormatting.GRAY));
    }
}

