/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IShawarmaSpit;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.ShawarmaSpitBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShawarmaSpitBlockEntity
extends BaseBlockEntity
implements IShawarmaSpit {
    private static final int MAX_ITEMS = 8;
    public static final String COOKING_ITEM = "CookingItem";
    public static final String COOKED_ITEM = "CookedItem";
    public static final String COOK_TIME = "CookTime";
    private final RecipeManager.CachedCheck<Container, CampfireCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);
    public ItemStack cookingItem = ItemStack.f_41583_;
    public ItemStack cookedItem = ItemStack.f_41583_;
    public int cookTime;

    public ShawarmaSpitBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlocks.SHAWARMA_SPIT_BE.get(), pPos, pBlockState);
    }

    @Override
    public boolean onPutCookingItem(Level level, ItemStack itemStack) {
        if (!this.cookingItem.m_41619_() || !this.cookedItem.m_41619_()) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{itemStack});
        return this.quickCheck.m_213657_((Container)container, level).map(recipe -> {
            this.cookingItem = itemStack.m_41620_(8);
            this.cookedItem = recipe.m_5874_((Container)container, level.m_9598_());
            this.cookedItem.m_41764_(this.cookingItem.m_41613_());
            this.cookTime = recipe.m_43753_();
            this.refresh();
            if (level instanceof ServerLevel) {
                level.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.5f + level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 0.7f + 0.6f);
            }
            return true;
        }).orElse(false);
    }

    @Override
    public boolean onTakeCookedItem(Level level, LivingEntity entity) {
        ItemStack mainHandItem = entity.m_21205_();
        if (this.cookTime <= 0 && !this.cookedItem.m_41619_()) {
            this.giveItem(level, entity, mainHandItem, this.cookedItem.m_41777_());
            return true;
        }
        if (this.cookTime > 0 && !this.cookingItem.m_41619_()) {
            this.giveItem(level, entity, mainHandItem, this.cookingItem.m_41777_());
            return true;
        }
        return false;
    }

    private void giveItem(Level level, LivingEntity entity, ItemStack mainHandItem, ItemStack copy) {
        this.cookingItem = ItemStack.f_41583_;
        this.cookedItem = ItemStack.f_41583_;
        this.cookTime = 0;
        this.refresh();
        if (((Boolean)this.m_58900_().m_61143_((Property)ShawarmaSpitBlock.POWERED)).booleanValue()) {
            entity.m_6469_(level.m_269111_().m_269387_(), 1.0f);
        }
        ItemUtils.getItemToLivingEntity(entity, copy);
        if (level instanceof ServerLevel) {
            level.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.5f + level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 0.7f + 0.6f);
        }
    }

    public void tick() {
        if (this.cookingItem.m_41619_()) {
            if (!this.cookedItem.m_41619_()) {
                this.spawnParticles();
            }
            return;
        }
        this.spawnParticles();
        if (this.cookTime > 0) {
            --this.cookTime;
        } else {
            if (this.f_58857_ instanceof ServerLevel) {
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.6f);
            }
            this.cookingItem = ItemStack.f_41583_;
            this.refresh();
        }
    }

    private void spawnParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_58857_.f_46441_.m_188501_() < 0.25f) {
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.25, 0.2, 0.25, (double)0.1f);
            }
            if (this.f_58857_.f_46441_.m_188503_(20) == 0) {
                serverLevel.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.6f);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(COOKING_ITEM, (Tag)this.cookingItem.m_41739_(new CompoundTag()));
        tag.m_128365_(COOKED_ITEM, (Tag)this.cookedItem.m_41739_(new CompoundTag()));
        tag.m_128405_(COOK_TIME, this.cookTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(COOKING_ITEM)) {
            this.cookingItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_(COOKING_ITEM));
        }
        if (tag.m_128441_(COOKED_ITEM)) {
            this.cookedItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_(COOKED_ITEM));
        }
        this.cookTime = tag.m_128451_(COOK_TIME);
    }
}

