/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModVillager;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.item.RecipeItem;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="kaleidoscope_cookery")
public class ModTradesEvent {
    @SubscribeEvent
    public static void onTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == ModVillager.CHEF.get()) {
            ModTradesEvent.addNoviceTrades(event);
            ModTradesEvent.addApprenticeTrades(event);
            ModTradesEvent.addJourneymanTrades(event);
            ModTradesEvent.addExpertTrades(event);
            ModTradesEvent.addMasterTrades(event);
        }
    }

    private static void addNoviceTrades(VillagerTradesEvent event) {
        ModTradesEvent.addTrade(event, 1, ModItems.TOMATO.get(), 12, Items.f_42616_, 1, 16, 2, 0.05f);
        ModTradesEvent.addTrade(event, 1, ModItems.LETTUCE.get(), 16, Items.f_42616_, 1, 16, 2, 0.05f);
        ModTradesEvent.addTrade(event, 1, ModItems.RICE_SEED.get(), 20, Items.f_42616_, 1, 16, 2, 0.05f);
        ModTradesEvent.addTrade(event, 1, ModItems.RED_CHILI.get(), 12, Items.f_42616_, 1, 16, 2, 0.05f);
        ModTradesEvent.addTrade(event, 1, ModItems.GREEN_CHILI.get(), 8, Items.f_42616_, 1, 12, 2, 0.1f);
        ModTradesEvent.addTrade(event, 1, ModItems.CATERPILLAR.get(), 1, Items.f_42616_, 1, 12, 2, 0.1f);
    }

    private static void addApprenticeTrades(VillagerTradesEvent event) {
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 4, ModItems.KITCHEN_SHOVEL.get(), 1, 12, 4, 0.1f);
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 8, ModItems.IRON_KITCHEN_KNIFE.get(), 1, 12, 4, 0.2f);
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 3, ModItems.STOCKPOT_LID.get(), 1, 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 3, RecipeItem.RecipeRecord.pot(ModItems.SCRAMBLE_EGG_WITH_TOMATOES, ModItems.FRIED_EGG, ModItems.FRIED_EGG, ModItems.TOMATO, ModItems.TOMATO), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 3, RecipeItem.RecipeRecord.pot(ModItems.BRAISED_BEEF, ModItems.RAW_COW_OFFAL, ModItems.RAW_COW_OFFAL, ModItems.GREEN_CHILI, ModItems.GREEN_CHILI), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 3, RecipeItem.RecipeRecord.pot((ItemLike)ModItems.SWEET_AND_SOUR_PORK.get(), new ItemLike[]{Items.f_42501_, Items.f_42501_, Items.f_42501_, Items.f_42485_, Items.f_42485_, Items.f_42485_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 2, Items.f_42616_, 3, RecipeItem.RecipeRecord.pot((ItemLike)ModItems.FISH_FLAVORED_SHREDDED_PORK.get(), new ItemLike[]{Items.f_41952_, Items.f_41952_, Items.f_42485_, Items.f_42485_, Items.f_42485_, (ItemLike)ModItems.GREEN_CHILI.get()}), 16, 4, 0.1f);
    }

    private static void addJourneymanTrades(VillagerTradesEvent event) {
        ModTradesEvent.addTrade(event, 3, ModItems.DELICIOUS_EGG_FRIED_RICE.get(), 1, Items.f_42616_, 3, 16, 5, 0.05f);
        ModTradesEvent.addTrade(event, 3, ModItems.SUSPICIOUS_STIR_FRY_RICE_BOWL.get(), 3, Items.f_42616_, 1, 16, 5, 0.05f);
        ModTradesEvent.addTrade(event, 3, FoodBiteRegistry.getItem(FoodBiteRegistry.DARK_CUISINE), 5, Items.f_42616_, 2, 16, 5, 0.1f);
        ModTradesEvent.addTrade(event, 3, Items.f_42616_, 3, RecipeItem.RecipeRecord.stockpot((ItemLike)ModItems.TOMATO_BEEF_BRISKET_SOUP.get(), new ItemLike[]{Items.f_42579_, Items.f_42579_, Items.f_42579_, (ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.TOMATO.get()}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 3, Items.f_42616_, 3, RecipeItem.RecipeRecord.stockpot((ItemLike)ModItems.PUFFERFISH_SOUP.get(), new ItemLike[]{Items.f_42529_, Items.f_42529_, Items.f_42529_, Items.f_41867_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 3, Items.f_42616_, 3, RecipeItem.RecipeRecord.stockpot((ItemLike)ModItems.BORSCHT.get(), new ItemLike[]{Items.f_42579_, Items.f_42579_, (ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.LETTUCE.get()}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 3, Items.f_42616_, 3, RecipeItem.RecipeRecord.stockpot((ItemLike)ModItems.BRAISED_BEEF_WITH_POTATOES.get(), new ItemLike[]{Items.f_42579_, Items.f_42579_, Items.f_42620_, Items.f_42620_, Items.f_42620_}), 16, 4, 0.1f);
    }

    private static void addExpertTrades(VillagerTradesEvent event) {
        ModTradesEvent.addTrade(event, 4, ModItems.PORK_BONE_SOUP.get(), 1, Items.f_42616_, 1, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.PUFFERFISH_SOUP.get(), 1, Items.f_42616_, 4, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.SEAFOOD_MISO_SOUP.get(), 1, Items.f_42616_, 1, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.LAMB_AND_RADISH_SOUP.get(), 1, Items.f_42616_, 2, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.BRAISED_BEEF_WITH_POTATOES.get(), 1, Items.f_42616_, 2, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.WILD_MUSHROOM_RABBIT_SOUP.get(), 1, Items.f_42616_, 3, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.TOMATO_BEEF_BRISKET_SOUP.get(), 1, Items.f_42616_, 2, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.BORSCHT.get(), 1, Items.f_42616_, 2, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.BEEF_MEATBALL_SOUP.get(), 1, Items.f_42616_, 3, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, ModItems.FEARSOME_THICK_SOUP.get(), 1, Items.f_42616_, 5, 16, 10, 0.1f);
        ModTradesEvent.addTrade(event, 4, Items.f_42616_, 5, RecipeItem.RecipeRecord.pot((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.DONGPO_PORK), new ItemLike[]{Items.f_41911_, Items.f_41911_, Items.f_42485_, Items.f_42485_, Items.f_42485_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 4, Items.f_42616_, 5, RecipeItem.RecipeRecord.pot((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.STARGAZY_PIE), new ItemLike[]{Items.f_42526_, Items.f_42526_, Items.f_42526_, Items.f_42526_, Items.f_42526_, Items.f_42687_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 4, Items.f_42616_, 5, RecipeItem.RecipeRecord.pot((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.NETHER_STYLE_SASHIMI), new ItemLike[]{Items.f_41954_, Items.f_41954_, Items.f_41955_, Items.f_41955_, Items.f_42528_, Items.f_42528_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 4, Items.f_42616_, 5, RecipeItem.RecipeRecord.pot((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.SLIME_BALL_MEAL), new ItemLike[]{Items.f_42518_, Items.f_42518_, Items.f_42518_, Items.f_42518_, Items.f_42518_, Items.f_42518_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 4, Items.f_42616_, 5, RecipeItem.RecipeRecord.pot((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.SPICY_CHICKEN), new ItemLike[]{(ItemLike)ModItems.GREEN_CHILI.get(), (ItemLike)ModItems.GREEN_CHILI.get(), (ItemLike)ModItems.GREEN_CHILI.get(), Items.f_42581_, Items.f_42581_, Items.f_42581_, Items.f_42581_}), 16, 4, 0.1f);
        ModTradesEvent.addTrade(event, 4, Items.f_42616_, 5, RecipeItem.RecipeRecord.pot((ItemLike)FoodBiteRegistry.getItem(FoodBiteRegistry.YAKITORI), new ItemLike[]{(ItemLike)ModItems.GREEN_CHILI.get(), (ItemLike)ModItems.GREEN_CHILI.get(), Items.f_42581_, Items.f_42581_, Items.f_42581_, Items.f_42581_}), 16, 4, 0.1f);
    }

    private static void addMasterTrades(VillagerTradesEvent event) {
        ((List)event.getTrades().get(5)).add(new EnchantedItemForEmeralds((Item)ModItems.DIAMOND_KITCHEN_KNIFE.get(), 8, 3, 30, 0.2f));
    }

    private static void addTrade(VillagerTradesEvent event, int level, Object inputItem, int inputCount, Object outputItem, int outputCount, int maxUses, int villagerXp, float priceMultiplier) {
        ItemStack input = ModTradesEvent.createItemStack(inputItem, inputCount);
        ItemStack output = ModTradesEvent.createItemStack(outputItem, outputCount);
        BasicItemListing listing = new BasicItemListing(input, output, maxUses, villagerXp, priceMultiplier);
        ((List)event.getTrades().get(level)).add(listing);
    }

    private static void addTrade(VillagerTradesEvent event, int level, Object inputItem, int inputCount, RecipeItem.RecipeRecord record, int maxUses, int villagerXp, float priceMultiplier) {
        ItemStack input = ModTradesEvent.createItemStack(inputItem, inputCount);
        ItemStack output = ((Item)ModItems.RECIPE_ITEM.get()).m_7968_();
        RecipeItem.setRecipe(output, record);
        BasicItemListing listing = new BasicItemListing(input, output, maxUses, villagerXp, priceMultiplier);
        ((List)event.getTrades().get(level)).add(listing);
    }

    private static ItemStack createItemStack(Object item, int count) {
        if (item instanceof Item) {
            Item itemInstance = (Item)item;
            return new ItemStack((ItemLike)itemInstance, count);
        }
        if (item instanceof RegistryObject) {
            RegistryObject registryObject = (RegistryObject)item;
            return new ItemStack((ItemLike)((Item)registryObject.get()), count);
        }
        if (item instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)item;
            return itemStack.m_255036_(count);
        }
        throw new IllegalArgumentException("Unsupported item type: " + String.valueOf(item.getClass()));
    }

    private static class EnchantedItemForEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int baseEmeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EnchantedItemForEmeralds(Item item, int baseEmeraldCost, int maxUses, int villagerXp) {
            this(item, baseEmeraldCost, maxUses, villagerXp, 0.05f);
        }

        public EnchantedItemForEmeralds(Item item, int baseEmeraldCost, int maxUses, int villagerXp, float priceMultiplier) {
            this.itemStack = new ItemStack((ItemLike)item);
            this.baseEmeraldCost = baseEmeraldCost;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            int cost = 5 + random.m_188503_(15);
            ItemStack enchantedItem = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)new ItemStack((ItemLike)this.itemStack.m_41720_()), (int)cost, (boolean)false);
            int emeraldCount = Math.min(this.baseEmeraldCost + cost, 64);
            ItemStack emeraldStack = new ItemStack((ItemLike)Items.f_42616_, emeraldCount);
            return new MerchantOffer(emeraldStack, enchantedItem, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

