/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.decoration;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.TableBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.util.BlockDrop;
import com.github.ysbbbbbb.kaleidoscopecookery.util.CarpetColor;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends class_2248
implements class_3737,
class_2343 {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    public static final class_2758 POSITION = class_2758.method_11867((String)"position", (int)0, (int)3);
    public static final class_2746 HAS_CARPET = class_2746.method_11825((String)"has_carpet");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final int SINGLE = 0;
    public static final int LEFT = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT = 3;
    private static final class_265 FACE = class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TableBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488().method_50013());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051)).method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HAS_CARPET, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemInHand = player.method_5998(hand);
        if (hand == class_1268.field_5808) {
            if (itemInHand.method_31573(class_3489.field_15542)) {
                return this.useWithCarpets(state, level, pos, player, itemInHand);
            }
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof TableBlockEntity) {
                TableBlockEntity table = (TableBlockEntity)class_25862;
                return this.useWithOther(level, pos, player, hand, table, itemInHand);
            }
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    @NotNull
    private class_1269 useWithOther(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, TableBlockEntity table, class_1799 itemInHand) {
        class_2371<class_1799> tableItems = table.getItems();
        Pair<Integer, class_1799> lastStack = ItemUtils.getLastStack(tableItems);
        Integer tableIndex = (Integer)lastStack.getLeft();
        class_1799 tableItem = (class_1799)lastStack.getRight();
        boolean handEmpty = itemInHand.method_7960();
        if (handEmpty && !tableItem.method_7960()) {
            level.method_8396(player, pos, class_3417.field_14770, player.method_5634(), 1.0f, 1.0f);
            BlockDrop.popResource(level, pos, 0.75, tableItem.method_7972());
            tableItems.set(tableIndex.intValue(), (Object)class_1799.field_8037);
            table.refresh();
            return class_1269.field_5812;
        }
        if (!handEmpty && tableIndex < tableItems.size() - 1) {
            class_1799 split = itemInHand.method_7971(1);
            if (tableItem.method_7960()) {
                tableItems.set(tableIndex.intValue(), (Object)split);
            } else {
                tableItems.set(tableIndex + 1, (Object)split);
            }
            table.refresh();
            level.method_8396(player, pos, class_3417.field_14667, player.method_5634(), 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @NotNull
    private class_1269 useWithCarpets(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1799 itemInHand) {
        TableBlockEntity tableBlockEntity;
        class_2586 class_25862;
        @Nullable class_1767 dyeColor = CarpetColor.getColorByCarpet(itemInHand.method_7909());
        boolean hasCarpet = (Boolean)state.method_11654((class_2769)HAS_CARPET);
        if (dyeColor == null) {
            return class_1269.field_5811;
        }
        if (!hasCarpet) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            class_25862 = level.method_8321(pos);
            if (class_25862 instanceof TableBlockEntity) {
                TableBlockEntity tableBlockEntity2 = (TableBlockEntity)class_25862;
                level.method_8396(null, pos, class_2498.field_11543.method_10598(), player.method_5634(), 1.0f, 1.0f);
                tableBlockEntity2.setColor(dyeColor);
                tableBlockEntity2.refresh();
                itemInHand.method_7934(1);
                return class_1269.field_5812;
            }
        }
        if (hasCarpet && (class_25862 = level.method_8321(pos)) instanceof TableBlockEntity && (tableBlockEntity = (TableBlockEntity)class_25862).getColor() != dyeColor) {
            class_1767 originalColor = tableBlockEntity.getColor();
            class_1799 carpetItem = CarpetColor.getCarpetByColor(originalColor).method_7854();
            BlockDrop.popResource(level, pos, 0.75, carpetItem);
            level.method_8396(null, pos, class_2498.field_11543.method_10598(), player.method_5634(), 1.0f, 1.0f);
            tableBlockEntity.setColor(dyeColor);
            tableBlockEntity.refresh();
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            itemInHand.method_7934(1);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 lootParamsBuilder) {
        List drops = super.method_9560(state, lootParamsBuilder);
        class_2586 parameter = (class_2586)lootParamsBuilder.method_51876(class_181.field_1228);
        if (parameter instanceof TableBlockEntity) {
            TableBlockEntity tableBlockEntity = (TableBlockEntity)parameter;
            if (((Boolean)state.method_11654((class_2769)HAS_CARPET)).booleanValue()) {
                class_1792 carpet = CarpetColor.getCarpetByColor(tableBlockEntity.getColor());
                drops.add(new class_1799((class_1935)carpet));
            }
            class_2371<class_1799> items = tableBlockEntity.getItems();
            for (class_1799 item : items) {
                drops.add(item.method_7972());
            }
        }
        return drops;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, POSITION, HAS_CARPET, WATERLOGGED});
    }

    private class_2680 checkEastWestState(class_1936 levelAccessor, class_2338 pos, class_2680 baseState) {
        if (baseState.method_11654(AXIS) == class_2350.class_2351.field_11051 && (Integer)baseState.method_11654((class_2769)POSITION) != 0) {
            return baseState;
        }
        class_2680 westState = levelAccessor.method_8320(pos.method_10067());
        class_2680 eastState = levelAccessor.method_8320(pos.method_10078());
        if (eastState.method_27852((class_2248)this) && westState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(2))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
        }
        if (eastState.method_27852((class_2248)this) && !westState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(1))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
        }
        if (!eastState.method_27852((class_2248)this) && westState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(3))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
        }
        return (class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(0));
    }

    private class_2680 checkNorthSouthState(class_1936 levelAccessor, class_2338 pos, class_2680 baseState) {
        if (baseState.method_11654(AXIS) == class_2350.class_2351.field_11048 && (Integer)baseState.method_11654((class_2769)POSITION) != 0) {
            return baseState;
        }
        class_2680 northState = levelAccessor.method_8320(pos.method_10095());
        class_2680 southState = levelAccessor.method_8320(pos.method_10072());
        if (northState.method_27852((class_2248)this) && southState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(2))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
        }
        if (!northState.method_27852((class_2248)this) && southState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(1))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
        }
        if (northState.method_27852((class_2248)this) && !southState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(3))).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
        }
        return (class_2680)baseState.method_11657((class_2769)POSITION, (Comparable)Integer.valueOf(0));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 levelAccessor, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            levelAccessor.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            return this.checkEastWestState(levelAccessor, pos, state);
        }
        if (direction.method_10166() == class_2350.class_2351.field_11051) {
            return this.checkNorthSouthState(levelAccessor, pos, state);
        }
        return state;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_2350 direction = context.method_8042();
        boolean hasWater = level.method_8316(clickedPos).method_15772() == class_3612.field_15910;
        class_2680 base = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            return this.checkNorthSouthState((class_1936)level, clickedPos, base);
        }
        if (direction.method_10166() == class_2350.class_2351.field_11051) {
            return this.checkEastWestState((class_1936)level, clickedPos, base);
        }
        return base;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
        return FACE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TableBlockEntity(pos, state);
    }
}

