/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IPot;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_5894;
import org.jetbrains.annotations.Nullable;

public class PotBlock
extends class_2383
implements class_2343,
class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 HAS_OIL = class_2746.method_11825((String)"has_oil");
    public static final class_2746 SHOW_OIL = class_2746.method_11825((String)"show_oil");
    public static final class_2746 HAS_BASE = class_2746.method_11825((String)"has_base");
    private static final class_265 AABB = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final double DURABILITY_COST_PROBABILITY = 0.25;

    public PotBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_9626(ModSoundType.POT).method_22488().method_9629(1.5f, 6.0f));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11035)).method_11657((class_2769)HAS_OIL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SHOW_OIL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_BASE, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 levelAccessor, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            levelAccessor.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        if (direction == class_2350.field_11033) {
            return (class_2680)state.method_11657((class_2769)HAS_BASE, (Comparable)Boolean.valueOf(!neighborState.method_26206((class_1922)levelAccessor, neighborPos, class_2350.field_11036)));
        }
        return super.method_9559(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> createTickerHelper(class_2591<A> serverType, class_2591<E> clientType, class_5558<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        if (placer instanceof class_1657) {
            IPot pot;
            class_1657 player = (class_1657)placer;
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof IPot && (pot = (IPot)class_25862).hasHeatSource(level)) {
                ModTrigger.EVENT.trigger((class_1309)player, "place_pot_on_heat_source");
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof IPot)) {
            return class_1269.field_5811;
        }
        IPot pot = (IPot)class_25862;
        class_1799 itemInHand = player.method_5998(hand);
        class_5819 random = level.field_9229;
        if (itemInHand.method_7960() && pot.removeIngredient(level, (class_1309)player)) {
            return class_1269.field_5812;
        }
        if (pot.takeOutProduct(level, (class_1309)player, player.method_6047())) {
            return class_1269.field_5812;
        }
        if (!pot.hasHeatSource(level)) {
            this.sendBarMessage(player, "tip.kaleidoscope_cookery.pot.need_lit_stove");
            return class_1269.field_5814;
        }
        if (!((Boolean)state.method_11654((class_2769)HAS_OIL)).booleanValue()) {
            if (pot.onPlaceOil(level, (class_1309)player, itemInHand)) {
                return class_1269.field_5812;
            }
            this.sendBarMessage(player, "tip.kaleidoscope_cookery.pot.need_oil");
            return class_1269.field_5814;
        }
        if (itemInHand.method_31574(ModItems.KITCHEN_SHOVEL)) {
            if (level.field_9229.method_43058() < 0.25) {
                itemInHand.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            }
            pot.onShovelHit(level, (class_1309)player, itemInHand);
            level.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f + (random.method_43057() - random.method_43057()) * 0.8f);
            return class_1269.field_5812;
        }
        if (pot.addIngredient(level, (class_1309)player, itemInHand)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void sendBarMessage(class_1657 player, String key) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_5250 message = class_2561.method_43471((String)key);
            serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)message));
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        if (level.field_9236) {
            return null;
        }
        if (!((Boolean)state.method_11654((class_2769)HAS_OIL)).booleanValue()) {
            return null;
        }
        return PotBlock.createTickerHelper(blockEntityType, ModBlocks.POT_BE, (levelIn, pos, stateIn, pot) -> pot.tick(levelIn));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        class_2680 belowState = context.method_8045().method_8320(context.method_8037().method_10074());
        if (!belowState.method_26206((class_1922)context.method_8045(), context.method_8037().method_10074(), class_2350.field_11036)) {
            return (class_2680)blockState.method_11657((class_2769)HAS_BASE, (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HAS_OIL, SHOW_OIL, HAS_BASE, field_11177, WATERLOGGED});
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
        return AABB;
    }
}

