/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IChoppingBoard;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.ChoppingBoardRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ChoppingBoardBlockEntity
extends BaseBlockEntity
implements IChoppingBoard {
    private static final String MODEL_ID = "ModelId";
    private static final String CURRENT_CUT_STACK = "CurrentCutStack";
    private static final String RESULT_ITEM = "ResultItem";
    private static final String MAX_CUT_COUNT = "MaxCutCount";
    private static final String CURRENT_CUT_COUNT = "CurrentCutCount";
    @Nullable
    public class_2960[] cacheModels = null;
    @Nullable
    public class_2960 previousModel = null;
    @Nullable
    private class_2960 modelId = null;
    private int maxCutCount = 0;
    private int currentCutCount = 0;
    private class_1799 currentCutStack = class_1799.field_8037;
    private class_1799 result = class_1799.field_8037;

    public ChoppingBoardBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlocks.CHOPPING_BOARD_BE, pos, blockState);
    }

    @Override
    public boolean onPutItem(class_1937 level, class_1309 user, class_1799 putOnItem) {
        if (!this.result.method_7960()) {
            return false;
        }
        class_1277 container = new class_1277(new class_1799[]{putOnItem});
        Optional recipeOptional = level.method_8433().method_8132(ModRecipes.CHOPPING_BOARD_RECIPE, (class_1263)container, level);
        if (recipeOptional.isPresent()) {
            ChoppingBoardRecipe recipe = (ChoppingBoardRecipe)((Object)recipeOptional.get());
            this.modelId = recipe.getModelId();
            this.maxCutCount = recipe.getCutCount();
            this.currentCutCount = 0;
            this.currentCutStack = putOnItem.method_7971(1);
            this.result = recipe.method_8116((class_1263)container, level.method_30349());
            this.refresh();
            level.method_8396(null, this.field_11867, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCutItem(class_1937 level, class_1309 user, class_1799 cutterItem) {
        if (this.result.method_7960()) {
            return false;
        }
        if (this.currentCutCount >= this.maxCutCount) {
            class_2248.method_9577((class_1937)level, (class_2338)this.field_11867, (class_1799)this.result.method_7972());
            this.resetBoardData();
            level.method_8396(null, this.field_11867, class_3417.field_14718, class_3419.field_15245, 1.0f, 2.0f + level.field_9229.method_43057() * 0.2f);
            return true;
        }
        if (cutterItem.method_31573(TagMod.KITCHEN_KNIFE)) {
            ++this.currentCutCount;
            this.playParticlesSound();
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean onTakeOut(class_1937 level, class_1309 user) {
        if (this.currentCutCount == 0 && !this.currentCutStack.method_7960()) {
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                player.method_31548().method_7398(this.currentCutStack);
            } else {
                class_2248.method_9577((class_1937)level, (class_2338)this.field_11867, (class_1799)this.currentCutStack);
            }
            this.resetBoardData();
            level.method_8396(null, this.field_11867, class_3417.field_14770, class_3419.field_15245, 1.0f, 1.2f + level.field_9229.method_43057() * 0.2f);
            return true;
        }
        return false;
    }

    @Override
    public void playParticlesSound() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_5819 random = serverLevel.method_8409();
            serverLevel.method_14199((class_2394)class_2398.field_11205, (double)this.field_11867.method_10263() + 0.25 + random.method_43058() / 2.0, (double)this.field_11867.method_10264() + 0.25, (double)this.field_11867.method_10260() + 0.25 + random.method_43058() / 2.0, 2, 0.0, 0.0, 0.0, 0.1);
            serverLevel.method_8396(null, this.field_11867, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.5f + this.field_11863.field_9229.method_43057() * 0.4f);
        }
    }

    private void resetBoardData() {
        this.modelId = null;
        this.result = class_1799.field_8037;
        this.currentCutStack = class_1799.field_8037;
        this.currentCutCount = 0;
        this.maxCutCount = 0;
        this.refresh();
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.modelId != null) {
            tag.method_10582(MODEL_ID, this.modelId.toString());
        }
        tag.method_10569(MAX_CUT_COUNT, this.maxCutCount);
        tag.method_10569(CURRENT_CUT_COUNT, this.currentCutCount);
        tag.method_10566(CURRENT_CUT_STACK, (class_2520)this.currentCutStack.method_7953(new class_2487()));
        tag.method_10566(RESULT_ITEM, (class_2520)this.result.method_7953(new class_2487()));
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545(MODEL_ID)) {
            this.modelId = new class_2960(tag.method_10558(MODEL_ID));
        }
        this.maxCutCount = tag.method_10550(MAX_CUT_COUNT);
        this.currentCutCount = tag.method_10550(CURRENT_CUT_COUNT);
        if (tag.method_10545(CURRENT_CUT_STACK)) {
            this.currentCutStack = class_1799.method_7915((class_2487)tag.method_10562(CURRENT_CUT_STACK));
        }
        if (tag.method_10545(RESULT_ITEM)) {
            this.result = class_1799.method_7915((class_2487)tag.method_10562(RESULT_ITEM));
        }
    }

    @Nullable
    public class_2960 getModelId() {
        return this.modelId;
    }

    public int getMaxCutCount() {
        return this.maxCutCount;
    }

    public int getCurrentCutCount() {
        return this.currentCutCount;
    }
}

