/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IPot;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagCommon;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_5894;

public class PotBlockEntity
extends BaseBlockEntity
implements IPot {
    private static final int PUT_INGREDIENT_TIME = 1200;
    private static final int TAKEOUT_TIME = 800;
    private static final int BURNT_TIME = 400;
    private static final String INPUTS = "Inputs";
    private static final String CARRIER = "Carrier";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String STIR_FRY_COUNT = "StirFryCount";
    private static final String SEED = "Seed";
    private class_2371<class_1799> inputs = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_1856 carrier = class_1856.field_9017;
    private class_1799 result = class_1799.field_8037;
    private int status = 0;
    private int currentTick = 0;
    private int stirFryCount = 0;
    public long seed;
    public StirFryAnimationData animationData = new StirFryAnimationData();

    public PotBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(ModBlocks.POT_BE, pPos, pBlockState);
        this.seed = System.currentTimeMillis();
    }

    @Override
    public boolean hasHeatSource(class_1937 level) {
        class_2680 belowState = level.method_8320(this.field_11867.method_10074());
        if (belowState.method_28498((class_2769)class_2741.field_12548) && ((Boolean)belowState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            return true;
        }
        return belowState.method_26164(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    public void tick(class_1937 level) {
        if (!this.hasHeatSource(level)) {
            return;
        }
        class_5819 random = level.field_9229;
        if (this.currentTick > 0) {
            --this.currentTick;
            if (this.currentTick % 5 == 0) {
                this.refresh();
            }
            if (this.currentTick % 20 == 0) {
                level.method_8396(null, this.field_11867, class_3417.field_14993, class_3419.field_15245, 0.5f + random.method_43057() / 0.5f, 0.8f + random.method_43057() / 0.5f);
            }
        }
        if (this.status == 0) {
            this.tickPutIngredient(level, random);
            return;
        }
        if (this.status == 1) {
            this.tickCooking(level, random);
            return;
        }
        if (this.status == 2) {
            this.tickFinished(random);
            return;
        }
        if (this.status == 3) {
            this.tickBurnt(level, random);
        }
    }

    private void tickBurnt(class_1937 level, class_5819 random) {
        class_3218 serverLevel;
        class_1937 class_19372;
        int particleCount = 10 - this.currentTick / 5;
        if (this.currentTick % 2 == 0 && (class_19372 = this.field_11863) instanceof class_3218) {
            serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11251, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.25 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), particleCount, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.currentTick == 0) {
            this.reset();
            level.method_8396(null, this.field_11867, class_3417.field_15102, class_3419.field_15245, 1.0f, (random.method_43057() - random.method_43057()) * 0.8f);
            if (level instanceof class_3218) {
                serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)class_2398.field_11251, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.25 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
                int count = 1 + random.method_43048(3);
                class_2248.method_9577((class_1937)level, (class_2338)this.field_11867, (class_1799)new class_1799((class_1935)class_1802.field_8665, count));
            }
        }
    }

    private void tickFinished(class_5819 random) {
        class_1937 class_19372;
        if (this.currentTick % 10 == 0 && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)ModParticles.COOKING, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.1 + random.method_43058() / 2.0, (double)this.field_11867.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.currentTick == 0) {
            this.status = 3;
            this.currentTick = 400;
            this.method_5431();
        }
    }

    private void tickCooking(class_1937 level, class_5819 random) {
        if (this.currentTick == 0) {
            level.method_8396(null, this.field_11867, class_3417.field_15102, class_3419.field_15245, 1.0f, (random.method_43057() - random.method_43057()) * 0.8f);
            this.status = 2;
            if (this.stirFryCount > 0) {
                this.result = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).method_7854();
                this.carrier = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8428});
            }
            this.currentTick = 800;
            this.method_5431();
            class_2680 state = level.method_8320(this.field_11867);
            level.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void tickPutIngredient(class_1937 level, class_5819 random) {
        class_3218 serverLevel;
        if (this.currentTick % 10 == 0 && level instanceof class_3218) {
            serverLevel = (class_3218)level;
            serverLevel.method_14199((class_2394)ModParticles.COOKING, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 5.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.1 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 5.0 * (double)(random.method_43056() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.currentTick == 0) {
            if (this.isEmpty()) {
                this.reset();
                level.method_8396(null, this.field_11867, class_3417.field_15102, class_3419.field_15245, 1.0f, (random.method_43057() - random.method_43057()) * 0.8f);
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199((class_2394)ModParticles.COOKING, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.1 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
                }
            } else {
                this.startCooking(level);
            }
        }
    }

    @Override
    public boolean onPlaceOil(class_1937 level, class_1309 user, class_1799 stack) {
        if (stack.method_31573(TagMod.OIL)) {
            this.placeOil(level, user, level.field_9229);
            stack.method_7934(1);
            ModTrigger.EVENT.trigger(user, "put_oil_in_pot");
            return true;
        }
        if (stack.method_31574(ModItems.KITCHEN_SHOVEL) && KitchenShovelItem.hasOil(stack)) {
            this.placeOil(level, user, level.field_9229);
            KitchenShovelItem.setHasOil(stack, false);
            ModTrigger.EVENT.trigger(user, "put_oil_in_pot");
            return true;
        }
        return false;
    }

    private void placeOil(class_1937 level, class_1309 user, class_5819 random) {
        this.currentTick = 1200;
        class_2680 state = level.method_8320(this.field_11867);
        level.method_8501(this.field_11867, (class_2680)((class_2680)state.method_11657((class_2769)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(true)));
        level.method_45445((class_1297)user, this.field_11867, class_3417.field_15102, class_3419.field_15245, 1.0f, (random.method_43057() - random.method_43057()) * 0.8f);
        for (int i = 0; i < 10; ++i) {
            level.method_8406((class_2394)class_2398.field_11251, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.25 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.05, 0.0);
        }
    }

    @Override
    public void onShovelHit(class_1937 level, class_1309 user, class_1799 shovel) {
        class_1937 class_19372;
        if (!level.field_9236) {
            this.seed = System.currentTimeMillis();
            this.refresh();
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_5819 random = serverLevel.field_9229;
            serverLevel.method_14199((class_2394)ModParticles.COOKING, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.1 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.status == 0 && !this.isEmpty()) {
            this.startCooking(level);
            ModTrigger.EVENT.trigger(user, "stir_fry_in_pot");
        }
        if (this.status == 1 && this.stirFryCount > 0) {
            --this.stirFryCount;
            ModTrigger.EVENT.trigger(user, "stir_fry_in_pot");
        }
    }

    private void startCooking(class_1937 level) {
        class_1277 container = this.getContainer();
        level.method_8433().method_8132(ModRecipes.POT_RECIPE, (class_1263)container, level).ifPresentOrElse(recipe -> {
            this.carrier = recipe.carrier();
            this.result = recipe.method_8116(container, level.method_30349());
            this.currentTick = recipe.time();
            this.stirFryCount = recipe.stirFryCount();
        }, () -> {
            this.carrier = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8428});
            this.result = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).method_7854();
            this.currentTick = 200;
            this.stirFryCount = 0;
        });
        this.status = 1;
        this.refresh();
    }

    @Override
    public boolean takeOutProduct(class_1937 level, class_1309 user, class_1799 stack) {
        class_1799 finallyResult;
        if (this.status != 2 && this.status != 3) {
            return false;
        }
        class_1799 class_17992 = finallyResult = this.status == 2 ? this.result : FoodBiteRegistry.getItem(FoodBiteRegistry.DARK_CUISINE).method_7854();
        if (finallyResult.method_31574(FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY)) && stack.method_31573(TagCommon.COOKED_RICE)) {
            stack.method_7934(1);
            ItemUtils.getItemToLivingEntity(user, ModItems.SUSPICIOUS_STIR_FRY_RICE_BOWL.method_7854());
            this.reset();
            return true;
        }
        if (!this.carrier.method_8103()) {
            return this.takeOutWithCarrier(level, user, stack, finallyResult);
        }
        return this.takeOutWithoutCarrier(level, user, stack, finallyResult);
    }

    private boolean takeOutWithoutCarrier(class_1937 level, class_1309 user, class_1799 stack, class_1799 finallyResult) {
        if (stack.method_31574(ModItems.KITCHEN_SHOVEL)) {
            class_1657 player;
            if (user instanceof class_1657 && !(player = (class_1657)user).method_21823()) {
                return false;
            }
            ItemUtils.getItemToLivingEntity(user, finallyResult);
            this.reset();
            return true;
        }
        if (this.hasHeatSource(level)) {
            user.method_5643(level.method_48963().method_48794(), 1.0f);
            ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_pot");
        }
        this.sendActionBarMessage(user, "need_kitchen_shovel", new Object[0]);
        return false;
    }

    private boolean takeOutWithCarrier(class_1937 level, class_1309 user, class_1799 mainHandItem, class_1799 finallyResult) {
        class_2561 carrierName = this.carrier.method_8105()[0].method_7964();
        if (this.carrier.method_8093(mainHandItem)) {
            if (mainHandItem.method_7947() < finallyResult.method_7947()) {
                this.sendActionBarMessage(user, "carrier_count_not_enough", finallyResult.method_7947(), carrierName);
                return false;
            }
            mainHandItem.method_7934(finallyResult.method_7947());
            ItemUtils.getItemToLivingEntity(user, finallyResult);
            this.reset();
            return true;
        }
        if (!mainHandItem.method_31574(ModItems.KITCHEN_SHOVEL)) {
            if (this.hasHeatSource(level)) {
                user.method_5643(level.method_48963().method_48794(), 1.0f);
                ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_pot");
            }
            this.sendActionBarMessage(user, "need_carrier", carrierName);
        }
        return false;
    }

    private void sendActionBarMessage(class_1309 user, String type, Object ... args) {
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            String key = "tip.kaleidoscope_cookery.pot." + type;
            class_5250 message = class_2561.method_43469((String)key, (Object[])args);
            serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)message));
        }
    }

    @Override
    public boolean addIngredient(class_1937 level, class_1309 user, class_1799 itemStack) {
        if (this.status != 0) {
            return false;
        }
        if (!itemStack.method_19267() && !itemStack.method_31573(TagItem.POT_INGREDIENT)) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            class_1799 item = (class_1799)this.inputs.get(i);
            if (!item.method_7960()) continue;
            this.inputs.set(i, (Object)itemStack.method_46651(1));
            itemStack.method_7934(1);
            level.method_8396(null, this.field_11867, class_3417.field_17743, class_3419.field_15245, 1.0f, 0.5f);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIngredient(class_1937 level, class_1309 user) {
        if (this.status != 0) {
            return false;
        }
        for (int i = this.inputs.size() - 1; i >= 0; --i) {
            class_1799 stack = (class_1799)this.inputs.get(i);
            if (stack.method_7960()) continue;
            this.inputs.set(i, (Object)class_1799.field_8037);
            ItemUtils.getItemToLivingEntity(user, stack);
            if (this.hasHeatSource(level)) {
                user.method_5643(level.method_48963().method_48794(), 1.0f);
                ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_pot");
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.inputs.clear();
        this.carrier = class_1856.field_9017;
        this.result = class_1799.field_8037;
        this.status = 0;
        this.currentTick = 0;
        this.stirFryCount = 0;
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8501(this.field_11867, (class_2680)((class_2680)state.method_11657((class_2769)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566(INPUTS, (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.inputs));
        tag.method_10582(CARRIER, this.carrier.method_8089().toString());
        tag.method_10566(RESULT, (class_2520)this.result.method_7953(new class_2487()));
        tag.method_10569(STATUS, this.status);
        tag.method_10569(CURRENT_TICK, this.currentTick);
        tag.method_10569(STIR_FRY_COUNT, this.stirFryCount);
        tag.method_10544(SEED, this.seed);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.inputs = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        if (tag.method_10573(INPUTS, 10)) {
            class_1262.method_5429((class_2487)tag.method_10562(INPUTS), this.inputs);
        }
        if (tag.method_10573(CARRIER, 8)) {
            JsonElement element = JsonParser.parseString((String)tag.method_10558(CARRIER));
            this.carrier = class_1856.method_52177((JsonElement)element);
        }
        if (tag.method_10573(RESULT, 10)) {
            this.result = class_1799.method_7915((class_2487)tag.method_10562(RESULT));
        }
        this.status = tag.method_10550(STATUS);
        this.currentTick = tag.method_10550(CURRENT_TICK);
        this.stirFryCount = tag.method_10550(STIR_FRY_COUNT);
        this.seed = tag.method_10537(SEED);
    }

    public List<class_1799> getInputs() {
        return this.inputs;
    }

    public class_1277 getContainer() {
        class_1277 container = new class_1277(9);
        for (int i = 0; i < this.inputs.size(); ++i) {
            class_1799 stack = (class_1799)this.inputs.get(i);
            if (stack.method_7960()) continue;
            container.method_5447(i, stack);
        }
        return container;
    }

    public boolean isEmpty() {
        for (class_1799 stack : this.inputs) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean hasCarrier() {
        return !this.carrier.method_8103();
    }

    public class_1799 getResult() {
        return this.result;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public static class StirFryAnimationData {
        public long preSeed = -1L;
        public long timestamp = -1L;
        public float[] randomHeights = new float[0];
    }
}

