/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IStockpot;
import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.container.StockpotContainer;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.FluidSoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoupBases;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.particle.StockpotParticleOptions;
import com.github.ysbbbbbb.kaleidoscopecookery.util.BlockDrop;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class StockpotBlockEntity
extends BaseBlockEntity
implements IStockpot {
    public static final int MAX_TAKEOUT_COUNT = 9;
    private static final String INPUTS = "Inputs";
    private static final String RECIPE_ID = "RecipeId";
    private static final String SOUP_BASE_ID = "SoupBaseId";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String TAKEOUT_COUNT = "TakeoutCount";
    private static final String LID_ITEM = "LidItem";
    private final class_1863.class_7266<StockpotContainer, StockpotRecipe> quickCheck = class_1863.method_42302(ModRecipes.STOCKPOT_RECIPE);
    private class_2371<class_1799> inputs = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_2960 recipeId = StockpotRecipeSerializer.EMPTY_ID;
    private class_2960 soupBaseId = ModSoupBases.WATER;
    private class_1799 result = class_1799.field_8037;
    private int status = 0;
    private int currentTick = -1;
    private int takeoutCount = 0;
    private class_1799 lidItem = class_1799.field_8037;
    public StockpotRecipe recipe = StockpotRecipeSerializer.getEmptyRecipe();
    @Nullable
    public class_1297 renderEntity = null;

    public StockpotBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(ModBlocks.STOCKPOT_BE, pPos, pBlockState);
    }

    public void clientTick() {
        if (this.renderEntity != null) {
            ++this.renderEntity.field_6012;
        }
    }

    @Override
    public boolean hasHeatSource(class_1937 level) {
        class_2680 belowState = level.method_8320(this.field_11867.method_10074());
        if (belowState.method_28498((class_2769)class_2741.field_12548) && ((Boolean)belowState.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            return true;
        }
        return belowState.method_26164(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    @Override
    public boolean hasLid() {
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        return this.field_11863 != null && blockState.method_28498((class_2769)StockpotBlock.HAS_LID) && (Boolean)blockState.method_11654((class_2769)StockpotBlock.HAS_LID) != false;
    }

    public void tick(class_1937 level) {
        if (this.status == 0) {
            return;
        }
        if (!this.hasHeatSource(level)) {
            return;
        }
        boolean hasLid = this.hasLid();
        if (level.method_8510() % 15L == 0L) {
            float volume = hasLid ? 0.075f : 0.2f;
            float pitch = hasLid ? 0.1f + level.field_9229.method_43057() * 0.05f : 1.0f + level.field_9229.method_43057() * 0.1f;
            level.method_43128(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, ModSounds.BLOCK_STOCKPOT, class_3419.field_15245, volume, pitch);
        }
        if (!hasLid) {
            this.spawnParticleWithoutLid(level);
            return;
        }
        this.spawnParticleWithLid(level);
        if (this.status == 1 && level.method_8510() % 5L == 0L && !this.isEmpty()) {
            this.setRecipe(level);
            this.status = 2;
            this.refresh();
            return;
        }
        if (this.status == 2) {
            if (this.currentTick > 0) {
                --this.currentTick;
                return;
            }
            this.status = 3;
            this.currentTick = -1;
            this.inputs.clear();
            this.refresh();
        }
    }

    private void spawnParticleWithLid(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (level.field_9229.method_43057() < 0.05f) {
                class_5819 random = serverLevel.field_9229;
                serverLevel.method_14199((class_2394)ModParticles.COOKING, (double)this.field_11867.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)this.field_11867.method_10264() + 0.375 + random.method_43058() / 3.0, (double)this.field_11867.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private void spawnParticleWithoutLid(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (serverLevel.field_9229.method_43057() < 0.25f) {
                int color = this.getBubbleColor();
                serverLevel.method_14199((class_2394)new StockpotParticleOptions(class_243.method_24457((int)color).method_46409(), 1.0f), (double)this.field_11867.method_10263() + 0.25 + (double)(level.field_9229.method_43057() * 0.5f), (double)this.field_11867.method_10264() + 0.375, (double)this.field_11867.method_10260() + 0.25 + (double)(level.field_9229.method_43057() * 0.5f), 2, ((double)level.field_9229.method_43057() - 0.5) * (double)0.1f, 0.0, ((double)level.field_9229.method_43057() - 0.5) * (double)0.1f, 0.0);
            }
        }
    }

    private int getBubbleColor() {
        if (this.field_11863 != null && this.recipeId != StockpotRecipeSerializer.EMPTY_ID && this.recipe.method_8114() == StockpotRecipeSerializer.EMPTY_ID) {
            StockpotRecipe stockpotRecipe = (StockpotRecipe)this.field_11863.method_8433().method_17717(ModRecipes.STOCKPOT_RECIPE).get(this.recipeId);
            this.recipe = Objects.requireNonNullElseGet(stockpotRecipe, StockpotRecipeSerializer::getEmptyRecipe);
        }
        if (this.status == 2) {
            return this.recipe.cookingBubbleColor();
        }
        if (this.status == 3) {
            return this.recipe.finishedBubbleColor();
        }
        ISoupBase soup = this.getSoupBase();
        if (soup != null) {
            return soup.getBubbleColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean onLitClick(class_1937 level, class_1309 user, class_1799 stack) {
        class_2680 blockState = level.method_8320(this.field_11867);
        boolean hasLid = this.hasLid();
        if (!hasLid && stack.method_31574(ModItems.STOCKPOT_LID)) {
            this.setLidItem(stack.method_7971(1));
            this.method_5431();
            level.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(true)));
            user.method_5783(class_3417.field_17743, 0.5f, 0.5f);
            ModTrigger.EVENT.trigger(user, "use_lid_on_stockpot");
            return true;
        }
        if (hasLid) {
            class_1799 lid = this.getLidItem().method_7960() ? ModItems.STOCKPOT_LID.method_7854() : this.getLidItem().method_7972();
            this.setLidItem(class_1799.field_8037);
            if (stack.method_7960()) {
                user.method_6122(class_1268.field_5808, lid);
            } else {
                BlockDrop.popResource(level, this.field_11867, 0.5, lid);
            }
            this.method_5431();
            level.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(false)));
            user.method_5783(class_3417.field_17745, 0.5f, 0.5f);
            return true;
        }
        return false;
    }

    private void setRecipe(class_1937 levelIn) {
        StockpotContainer container = new StockpotContainer((List<class_1799>)this.inputs, this.soupBaseId);
        this.quickCheck.method_42303((class_1263)container, levelIn).ifPresentOrElse(recipe -> {
            this.recipeId = recipe.method_8114();
            this.recipe = recipe;
            this.result = recipe.method_8116(container, levelIn.method_30349());
            this.currentTick = recipe.time();
            this.takeoutCount = Math.min(this.result.method_7947(), 9);
        }, () -> {
            this.recipeId = StockpotRecipeSerializer.EMPTY_ID;
            this.recipe = StockpotRecipeSerializer.getEmptyRecipe();
            this.result = class_1802.field_8766.method_7854();
            this.currentTick = 300;
            this.takeoutCount = 1;
        });
    }

    @Override
    public boolean addSoupBase(class_1937 level, class_1309 user, class_1799 bucket) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 0) {
            return false;
        }
        for (Map.Entry<class_2960, ISoupBase> entry : SoupBaseManager.getAllSoupBases().entrySet()) {
            class_2960 key = entry.getKey();
            ISoupBase soupBase = entry.getValue();
            if (!soupBase.isSoupBase(bucket)) continue;
            this.soupBaseId = key;
            this.status = 1;
            this.refresh();
            class_1799 container = soupBase.getReturnContainer(level, user, bucket);
            bucket.method_7934(1);
            ItemUtils.getItemToLivingEntity(user, container);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSoupBase(class_1937 level, class_1309 user, class_1799 bucket) {
        if (this.status == 1 && this.isEmpty() && SoupBaseManager.containsSoupBase(this.soupBaseId)) {
            ISoupBase soupBase = this.getSoupBase();
            if (soupBase == null || !soupBase.isContainer(bucket)) {
                return false;
            }
            this.renderEntity = null;
            this.soupBaseId = ModSoupBases.WATER;
            this.status = 0;
            this.refresh();
            class_1799 container = soupBase.getReturnSoupBase(level, user, bucket);
            bucket.method_7934(1);
            ItemUtils.getItemToLivingEntity(user, container);
            return true;
        }
        return false;
    }

    @Override
    public boolean addIngredient(class_1937 level, class_1309 user, class_1799 itemStack) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 1) {
            return false;
        }
        if (!itemStack.method_19267() && !itemStack.method_31573(TagItem.POT_INGREDIENT)) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!((class_1799)this.inputs.get(i)).method_7960()) continue;
            this.inputs.set(i, (Object)itemStack.method_7971(1));
            level.method_43128(null, user.method_23317(), user.method_23318() + 0.5, user.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIngredient(class_1937 level, class_1309 user) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 1) {
            return false;
        }
        for (int i = this.inputs.size() - 1; i >= 0; --i) {
            FluidSoupBase fluidSoupBase;
            class_1799 stack = (class_1799)this.inputs.get(i);
            if (stack.method_7960()) continue;
            ItemUtils.getItemToLivingEntity(user, stack.method_7972());
            this.inputs.set(i, (Object)class_1799.field_8037);
            ISoupBase soupBase = this.getSoupBase();
            if (soupBase instanceof FluidSoupBase && (fluidSoupBase = (FluidSoupBase)soupBase).getFluid().method_15791(class_3486.field_15518)) {
                user.method_5643(level.method_48963().method_48794(), 1.0f);
                ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_stockpot");
            }
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean takeOutProduct(class_1937 level, class_1309 user, class_1799 stack) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 3 || this.result.method_7960() || this.takeoutCount <= 0) {
            return false;
        }
        if (!stack.method_31574(class_1802.field_8428)) {
            return false;
        }
        stack.method_7934(1);
        class_1799 resultCopy = this.result.method_46651(1);
        ItemUtils.getItemToLivingEntity(user, resultCopy);
        --this.takeoutCount;
        if (this.takeoutCount <= 0) {
            this.status = 0;
            this.inputs.clear();
            this.recipeId = StockpotRecipeSerializer.EMPTY_ID;
            this.soupBaseId = ModSoupBases.WATER;
            this.result = class_1799.field_8037;
            this.currentTick = -1;
            this.renderEntity = null;
        }
        this.refresh();
        return true;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566(INPUTS, (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.inputs));
        tag.method_10582(RECIPE_ID, this.recipeId.toString());
        tag.method_10582(SOUP_BASE_ID, this.soupBaseId.toString());
        tag.method_10566(RESULT, (class_2520)this.result.method_7953(new class_2487()));
        tag.method_10569(STATUS, this.status);
        tag.method_10569(CURRENT_TICK, this.currentTick);
        tag.method_10569(TAKEOUT_COUNT, this.takeoutCount);
        if (!this.lidItem.method_7960()) {
            tag.method_10566(LID_ITEM, (class_2520)this.lidItem.method_7953(new class_2487()));
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545(INPUTS)) {
            this.inputs = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)tag.method_10562(INPUTS), this.inputs);
        }
        if (tag.method_10545(RECIPE_ID)) {
            this.recipeId = class_2960.method_12829((String)tag.method_10558(RECIPE_ID));
            if (this.field_11863 != null) {
                StockpotRecipe stockpotRecipe = (StockpotRecipe)this.field_11863.method_8433().method_17717(ModRecipes.STOCKPOT_RECIPE).get(this.recipeId);
                this.recipe = Objects.requireNonNullElseGet(stockpotRecipe, StockpotRecipeSerializer::getEmptyRecipe);
            }
        }
        if (tag.method_10545(SOUP_BASE_ID)) {
            this.soupBaseId = class_2960.method_12829((String)tag.method_10558(SOUP_BASE_ID));
        }
        if (tag.method_10545(RESULT)) {
            this.result = class_1799.method_7915((class_2487)tag.method_10562(RESULT));
        }
        this.status = tag.method_10550(STATUS);
        this.currentTick = tag.method_10550(CURRENT_TICK);
        this.takeoutCount = tag.method_10550(TAKEOUT_COUNT);
        if (tag.method_10545(LID_ITEM)) {
            this.lidItem = class_1799.method_7915((class_2487)tag.method_10562(LID_ITEM));
        }
    }

    public boolean isEmpty() {
        for (class_1799 stack : this.inputs) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2371<class_1799> getInputs() {
        return this.inputs;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public int getTakeoutCount() {
        return this.takeoutCount;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public class_2960 getSoupBaseId() {
        return this.soupBaseId;
    }

    @Nullable
    public ISoupBase getSoupBase() {
        return SoupBaseManager.getSoupBase(this.soupBaseId);
    }

    public class_1799 getLidItem() {
        return this.lidItem;
    }

    public void setLidItem(class_1799 lidItem) {
        this.lidItem = lidItem;
    }
}

