/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.api.client.render.ISoupBaseRender;
import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacerReloadListener;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class StockpotBlockEntityRender
implements class_827<StockpotBlockEntity> {
    private final class_5614.class_5615 context;
    private final Function<class_2960, ISoupBaseRender> soupBaseRender;

    public StockpotBlockEntityRender(class_5614.class_5615 context) {
        this.context = context;
        this.soupBaseRender = class_156.method_34866(id -> {
            ISoupBase soupBase = SoupBaseManager.getSoupBase(id);
            if (soupBase != null) {
                return soupBase.getRender();
            }
            return null;
        });
    }

    public void render(StockpotBlockEntity stockpot, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (((Boolean)stockpot.method_11010().method_11654((class_2769)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        int status = stockpot.getStatus();
        ISoupBaseRender soupBase = this.soupBaseRender.apply(stockpot.getSoupBaseId());
        if (status == 1) {
            soupBase.renderWhenPutIngredient(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, 0.38f);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay, false);
        } else if (status == 2) {
            soupBase.renderWhenCooking(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, stockpot.recipe.cookingTexture(), 0.38f);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay, true);
        } else if (status == 3) {
            int takeoutCount = stockpot.getTakeoutCount();
            int maxCount = Math.min(stockpot.getResult().method_7947(), 9);
            float soupHeight = 0.065f + 0.315f / (float)maxCount * (float)takeoutCount;
            soupBase.renderWhenFinished(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, stockpot.recipe.finishedTexture(), soupHeight);
        }
    }

    private void renderItems(StockpotBlockEntity stockpot, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, boolean isFinished) {
        class_2371<class_1799> items = stockpot.getInputs();
        items.forEach(stack -> {
            if (!stack.method_7960()) {
                int random = stack.hashCode();
                long time = (long)random + System.currentTimeMillis();
                float offsetX = (float)(random % 100) * 0.002f;
                float offsetZ = (float)(Math.sin((double)time * 5.0E-4) * 0.2);
                float offsetY = (float)(random % 50) * 0.004f;
                float yRot = (random % 2 == 0 ? -1 : 1) * 20 + random % 10;
                class_1087 model = isFinished ? ItemRenderReplacer.getModel(stockpot.method_10997(), stack, ItemRenderReplacerReloadListener.INSTANCE.stockpotFinished()) : ItemRenderReplacer.getModel(stockpot.method_10997(), stack, ItemRenderReplacerReloadListener.INSTANCE.stockpotCooking());
                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)(85 + random % 10)));
                poseStack.method_22905(0.5f, 0.5f, 0.5f);
                poseStack.method_22904(0.9 + (double)offsetX, 0.9 + (double)offsetY, -0.5 + (double)offsetZ);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(yRot));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(random % 360)));
                this.context.method_43335().method_23179(stack, class_811.field_4319, false, poseStack, buffer, packedLight, packedOverlay, model);
                poseStack.method_22909();
            }
        });
    }
}

