/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoupBases;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeSerializer
implements class_1865<StockpotRecipe> {
    public static final int DEFAULT_TIME = 300;
    public static final int DEFAULT_COOKING_BUBBLE_COLOR = 16772291;
    public static final int DEFAULT_FINISHED_BUBBLE_COLOR = 16034443;
    public static final class_2960 DEFAULT_SOUP_BASE = ModSoupBases.WATER;
    public static final class_2960 EMPTY_ID = new class_2960("kaleidoscope_cookery", "stockpot/empty");
    public static final class_2960 DEFAULT_COOKING_TEXTURE = new class_2960("kaleidoscope_cookery", "stockpot/default_cooking");
    public static final class_2960 DEFAULT_FINISHED_TEXTURE = new class_2960("kaleidoscope_cookery", "stockpot/default_finished");

    public static StockpotRecipe getEmptyRecipe() {
        return new StockpotRecipe(EMPTY_ID, Lists.newArrayList(), DEFAULT_SOUP_BASE, class_1799.field_8037, 300, DEFAULT_COOKING_TEXTURE, DEFAULT_FINISHED_TEXTURE, 16772291, 16034443);
    }

    public StockpotRecipe fromJson(class_2960 recipeId, JsonObject json) {
        JsonArray ingredients = class_3518.method_15261((JsonObject)json, (String)"ingredients");
        ArrayList inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(class_1856.method_52177((JsonElement)e));
        }
        class_2960 soupBase = DEFAULT_SOUP_BASE;
        if (json.has("soup_base")) {
            soupBase = new class_2960(class_3518.method_15265((JsonObject)json, (String)"soup_base"));
        }
        class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
        int time = class_3518.method_15282((JsonObject)json, (String)"time", (int)300);
        class_2960 cookingTexture = new class_2960(class_3518.method_15253((JsonObject)json, (String)"cooking_texture", (String)DEFAULT_COOKING_TEXTURE.toString()));
        class_2960 finishedTexture = new class_2960(class_3518.method_15253((JsonObject)json, (String)"finished_texture", (String)DEFAULT_FINISHED_TEXTURE.toString()));
        int cookingBubbleColor = class_3518.method_15282((JsonObject)json, (String)"cooking_bubble_color", (int)16772291);
        int finishedBubbleColor = class_3518.method_15282((JsonObject)json, (String)"finished_bubble_color", (int)16034443);
        return new StockpotRecipe(recipeId, inputs, soupBase, result, time, cookingTexture, finishedTexture, cookingBubbleColor, finishedBubbleColor);
    }

    @Nullable
    public StockpotRecipe fromNetwork(class_2960 recipeId, class_2540 buf) {
        int ingredientsSize = buf.method_10816();
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < ingredientsSize; ++i) {
            inputs.add(class_1856.method_8086((class_2540)buf));
        }
        class_2960 soupBase = buf.method_10810();
        class_1799 result = buf.method_10819();
        int time = buf.method_10816();
        class_2960 cookingTexture = buf.method_10810();
        class_2960 finishedTexture = buf.method_10810();
        int cookingBubbleColor = buf.method_10816();
        int finishedBubbleColor = buf.method_10816();
        return new StockpotRecipe(recipeId, inputs, soupBase, result, time, cookingTexture, finishedTexture, cookingBubbleColor, finishedBubbleColor);
    }

    public void toNetwork(class_2540 buffer, StockpotRecipe recipe) {
        buffer.method_10804(recipe.method_8117().size());
        recipe.method_8117().forEach(i -> i.method_8088(buffer));
        buffer.method_10812(recipe.soupBase());
        buffer.method_10793(recipe.result());
        buffer.method_10804(recipe.time());
        buffer.method_10812(recipe.cookingTexture());
        buffer.method_10812(recipe.finishedTexture());
        buffer.method_10804(recipe.cookingBubbleColor());
        buffer.method_10804(recipe.finishedBubbleColor());
    }
}

