/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase;

import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.FluidSoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.MobSoupBase;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class SoupBaseManager {
    private static final Map<class_2960, ISoupBase> ALL_SOUP_BASES = Maps.newLinkedHashMap();

    public static void registerSoupBase(ISoupBase soupBase) {
        if (ALL_SOUP_BASES.containsKey(soupBase.getName())) {
            throw new IllegalArgumentException("Soup base with name " + String.valueOf(soupBase.getName()) + " already exists!");
        }
        ALL_SOUP_BASES.put(soupBase.getName(), soupBase);
    }

    public static void registerFluidSoupBase(class_2960 name, class_1792 bucketItem, int bubbleColor) {
        SoupBaseManager.registerSoupBase(new FluidSoupBase(name, bucketItem, bubbleColor));
    }

    public static void registerMobSoupBase(class_2960 name, class_1792 bucketItem, int bubbleColor) {
        SoupBaseManager.registerSoupBase(new MobSoupBase(name, bucketItem, bubbleColor));
    }

    public static void registerMobSoupBase(class_2960 name, class_1792 mobBucketItem) {
        SoupBaseManager.registerSoupBase(new MobSoupBase(name, mobBucketItem));
    }

    public static ISoupBase getSoupBase(class_2960 name) {
        return ALL_SOUP_BASES.get(name);
    }

    public static boolean containsSoupBase(class_2960 name) {
        return ALL_SOUP_BASES.containsKey(name);
    }

    public static Map<class_2960, ISoupBase> getAllSoupBases() {
        return ALL_SOUP_BASES;
    }
}

