/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ChoppingBoardBuilder
implements class_5797 {
    private static final String NAME = "chopping_board";
    private class_1856 ingredient = class_1856.field_9017;
    private class_1799 result = class_1799.field_8037;
    private int cutCount = 3;
    private class_2960 modelId;

    public static ChoppingBoardBuilder builder() {
        return new ChoppingBoardBuilder();
    }

    public ChoppingBoardBuilder setIngredient(class_1935 itemLike) {
        this.ingredient = class_1856.method_8091((class_1935[])new class_1935[]{itemLike});
        return this;
    }

    public ChoppingBoardBuilder setIngredient(class_6862<class_1792> itemLike) {
        this.ingredient = class_1856.method_8106(itemLike);
        return this;
    }

    public ChoppingBoardBuilder setResult(class_1799 stack) {
        this.result = stack;
        return this;
    }

    public ChoppingBoardBuilder setResult(class_1935 itemLike) {
        this.result = new class_1799(itemLike);
        return this;
    }

    public ChoppingBoardBuilder setResult(class_1935 itemLike, int count) {
        this.result = new class_1799(itemLike, count);
        return this;
    }

    public ChoppingBoardBuilder setCutCount(int cutCount) {
        this.cutCount = Math.max(cutCount, 1);
        return this;
    }

    public ChoppingBoardBuilder setModelId(class_2960 modelId) {
        this.modelId = modelId;
        return this;
    }

    public class_5797 method_33530(String criterionName, class_184 criterionTrigger) {
        return this;
    }

    public class_5797 method_33529(@Nullable String groupName) {
        return this;
    }

    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    public void method_10431(Consumer<class_2444> output) {
        String path = class_5797.method_36442((class_1935)this.method_36441()).method_12832();
        class_2960 filePath = new class_2960("kaleidoscope_cookery", "chopping_board/" + path);
        this.method_17972(output, filePath);
    }

    public void method_36443(Consumer<class_2444> output, String recipeId) {
        class_2960 filePath = new class_2960("kaleidoscope_cookery", "chopping_board/" + recipeId);
        this.method_17972(output, filePath);
    }

    public void method_17972(Consumer<class_2444> recipeOutput, class_2960 id) {
        recipeOutput.accept(new ChoppingBoardRecipe(id, this.ingredient, this.result, this.cutCount, this.modelId));
    }

    public static class ChoppingBoardRecipe
    implements class_2444 {
        private final class_2960 id;
        private final class_1856 ingredient;
        private final class_1799 result;
        private final int cutCount;
        private final class_2960 modelId;

        public ChoppingBoardRecipe(class_2960 id, class_1856 ingredient, class_1799 result, int cutCount, class_2960 modelId) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.cutCount = cutCount;
            this.modelId = modelId;
        }

        public void method_10416(JsonObject json) {
            json.add("ingredient", this.ingredient.method_8089());
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", Objects.requireNonNull(class_7923.field_41178.method_10221((Object)this.result.method_7909())).toString());
            if (this.result.method_7947() > 1) {
                itemJson.addProperty("count", (Number)this.result.method_7947());
            }
            json.add("result", (JsonElement)itemJson);
            json.addProperty("cut_count", (Number)this.cutCount);
            json.addProperty("model_id", this.modelId.toString());
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.CHOPPING_BOARD_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

