/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PotRecipeBuilder
implements class_5797 {
    private static final String NAME = "pot";
    private int time = 200;
    private int stirFryCount = 3;
    private class_1856 carrier = class_1856.field_9017;
    private List<class_1856> ingredients = Lists.newArrayList();
    private class_1799 result = class_1799.field_8037;

    public static PotRecipeBuilder builder() {
        return new PotRecipeBuilder();
    }

    public PotRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public PotRecipeBuilder setStirFryCount(int stirFryCount) {
        this.stirFryCount = stirFryCount;
        return this;
    }

    public PotRecipeBuilder setCarrier(class_1856 ingredient) {
        this.carrier = ingredient;
        return this;
    }

    public PotRecipeBuilder setCarrier(class_1935 itemLike) {
        this.carrier = class_1856.method_8091((class_1935[])new class_1935[]{itemLike});
        return this;
    }

    public PotRecipeBuilder setBowlCarrier() {
        this.carrier = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8428});
        return this;
    }

    public PotRecipeBuilder addInput(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            if (ingredient instanceof class_1935) {
                class_1935 itemLike = (class_1935)ingredient;
                this.ingredients.add(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}));
                continue;
            }
            if (ingredient instanceof class_1799) {
                class_1799 stack = (class_1799)ingredient;
                this.ingredients.add(class_1856.method_8101((class_1799[])new class_1799[]{stack}));
                continue;
            }
            if (ingredient instanceof class_6862) {
                class_6862 tagKey = (class_6862)ingredient;
                this.ingredients.add(class_1856.method_8106((class_6862)tagKey));
                continue;
            }
            if (!(ingredient instanceof class_1856)) continue;
            class_1856 ingredientObj = (class_1856)ingredient;
            this.ingredients.add(ingredientObj);
        }
        return this;
    }

    public PotRecipeBuilder setResult(class_1792 result) {
        this.result = new class_1799((class_1935)result);
        return this;
    }

    public PotRecipeBuilder setResult(class_2960 result) {
        this.result = new class_1799((class_1935)Objects.requireNonNull((class_1792)class_7923.field_41178.method_10223(result)));
        return this;
    }

    public PotRecipeBuilder setResult(class_1792 result, int count) {
        this.result = new class_1799((class_1935)result, count);
        return this;
    }

    public PotRecipeBuilder setResult(class_2960 result, int count) {
        this.result = new class_1799((class_1935)Objects.requireNonNull((class_1792)class_7923.field_41178.method_10223(result)), count);
        return this;
    }

    public PotRecipeBuilder setResult(class_1799 result) {
        this.result = result;
        return this;
    }

    public class_5797 method_33530(String criterionName, class_184 criterionTrigger) {
        return this;
    }

    public class_5797 method_33529(@Nullable String groupName) {
        return this;
    }

    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    public void method_10431(Consumer<class_2444> output) {
        String path = class_5797.method_36442((class_1935)this.method_36441()).method_12832();
        class_2960 filePath = new class_2960("kaleidoscope_cookery", "pot/" + path);
        this.method_17972(output, filePath);
    }

    public void method_36443(Consumer<class_2444> output, String recipeId) {
        class_2960 filePath = new class_2960("kaleidoscope_cookery", "pot/" + recipeId);
        this.method_17972(output, filePath);
    }

    public void method_17972(Consumer<class_2444> recipeOutput, class_2960 id) {
        recipeOutput.accept(new PotFinishedRecipe(id, this.time, this.stirFryCount, this.carrier, this.ingredients, this.result));
    }

    public static class PotFinishedRecipe
    implements class_2444 {
        private final class_2960 id;
        private final int time;
        private final int stirFryCount;
        private final class_1856 carrier;
        private final List<class_1856> ingredients;
        private final class_1799 result;

        public PotFinishedRecipe(class_2960 id, int time, int stirFryCount, class_1856 carrier, List<class_1856> ingredients, class_1799 result) {
            this.id = id;
            this.time = time;
            this.stirFryCount = stirFryCount;
            this.carrier = carrier;
            this.ingredients = ingredients;
            this.result = result;
        }

        public void method_10416(JsonObject json) {
            json.addProperty("time", (Number)this.time);
            json.addProperty("stir_fry_count", (Number)this.stirFryCount);
            if (!this.carrier.method_8103()) {
                json.add("carrier", this.carrier.method_8089());
            }
            JsonArray ingredientsJson = new JsonArray();
            this.ingredients.stream().filter(i -> i != class_1856.field_9017).forEach(i -> ingredientsJson.add(i.method_8089()));
            json.add("ingredients", (JsonElement)ingredientsJson);
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", Objects.requireNonNull(class_7923.field_41178.method_10221((Object)this.result.method_7909())).toString());
            if (this.result.method_7947() > 1) {
                itemJson.addProperty("count", (Number)this.result.method_7947());
            }
            json.add("result", (JsonElement)itemJson);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.POT_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

