/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeBuilder
implements class_5797 {
    private static final String NAME = "stockpot";
    private List<class_1856> ingredients = Lists.newArrayList();
    private class_1799 result = class_1799.field_8037;
    private int time = 300;
    private class_2960 soupBase = StockpotRecipeSerializer.DEFAULT_SOUP_BASE;
    private class_2960 cookingTexture = StockpotRecipeSerializer.DEFAULT_COOKING_TEXTURE;
    private class_2960 finishedTexture = StockpotRecipeSerializer.DEFAULT_FINISHED_TEXTURE;
    private int cookingBubbleColor = 16772291;
    private int finishedBubbleColor = 16034443;

    public static StockpotRecipeBuilder builder() {
        return new StockpotRecipeBuilder();
    }

    public StockpotRecipeBuilder addInput(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            if (ingredient instanceof class_1935) {
                class_1935 itemLike = (class_1935)ingredient;
                this.ingredients.add(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}));
                continue;
            }
            if (ingredient instanceof class_1799) {
                class_1799 stack = (class_1799)ingredient;
                this.ingredients.add(class_1856.method_8101((class_1799[])new class_1799[]{stack}));
                continue;
            }
            if (ingredient instanceof class_6862) {
                class_6862 tagKey = (class_6862)ingredient;
                this.ingredients.add(class_1856.method_8106((class_6862)tagKey));
                continue;
            }
            if (!(ingredient instanceof class_1856)) continue;
            class_1856 ingredientObj = (class_1856)ingredient;
            this.ingredients.add(ingredientObj);
        }
        return this;
    }

    public StockpotRecipeBuilder setSoupBase(class_2960 soupBase) {
        this.soupBase = soupBase;
        return this;
    }

    public StockpotRecipeBuilder setResult(class_1792 result) {
        this.result = new class_1799((class_1935)result, 3);
        return this;
    }

    public StockpotRecipeBuilder setResult(class_1792 result, int count) {
        return this.setResult(new class_1799((class_1935)result, count));
    }

    public StockpotRecipeBuilder setResult(class_2960 result) {
        this.result = new class_1799((class_1935)Objects.requireNonNull((class_1792)class_7923.field_41178.method_10223(result)));
        return this;
    }

    public StockpotRecipeBuilder setResult(class_1799 result) {
        this.result = result;
        return this;
    }

    public StockpotRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public StockpotRecipeBuilder setCookingTexture(class_2960 cookingTexture) {
        this.cookingTexture = cookingTexture;
        return this;
    }

    public StockpotRecipeBuilder setFinishedTexture(class_2960 finishedTexture) {
        this.finishedTexture = finishedTexture;
        return this;
    }

    public StockpotRecipeBuilder setCookingBubbleColor(int cookingBubbleColor) {
        this.cookingBubbleColor = cookingBubbleColor;
        return this;
    }

    public StockpotRecipeBuilder setFinishedBubbleColor(int finishedBubbleColor) {
        this.finishedBubbleColor = finishedBubbleColor;
        return this;
    }

    public StockpotRecipeBuilder setBubbleColors(int cookingBubbleColor, int finishedBubbleColor) {
        this.cookingBubbleColor = cookingBubbleColor;
        this.finishedBubbleColor = finishedBubbleColor;
        return this;
    }

    public class_5797 method_33530(String criterionName, class_184 criterionTrigger) {
        return this;
    }

    public class_5797 method_33529(@Nullable String groupName) {
        return this;
    }

    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    public void method_10431(Consumer<class_2444> output) {
        String path = class_5797.method_36442((class_1935)this.method_36441()).method_12832();
        class_2960 filePath = new class_2960("kaleidoscope_cookery", "stockpot/" + path);
        this.method_17972(output, filePath);
    }

    public void method_36443(Consumer<class_2444> output, String recipeId) {
        class_2960 filePath = new class_2960("kaleidoscope_cookery", "stockpot/" + recipeId);
        this.method_17972(output, filePath);
    }

    public void method_17972(Consumer<class_2444> recipeOutput, class_2960 id) {
        recipeOutput.accept(new StockpotFinishedRecipe(id, this.ingredients, this.soupBase, this.result, this.time, this.cookingTexture, this.finishedTexture, this.cookingBubbleColor, this.finishedBubbleColor));
    }

    public static class StockpotFinishedRecipe
    implements class_2444 {
        private final class_2960 id;
        private final List<class_1856> ingredients;
        private final class_2960 soupBase;
        private final class_1799 result;
        private final int time;
        private final class_2960 cookingTexture;
        private final class_2960 finishedTexture;
        private final int cookingBubbleColor;
        private final int finishedBubbleColor;

        public StockpotFinishedRecipe(class_2960 id, List<class_1856> ingredients, class_2960 soupBase, class_1799 result, int time, class_2960 cookingTexture, class_2960 finishedTexture, int cookingBubbleColor, int finishedBubbleColor) {
            this.id = id;
            this.ingredients = ingredients;
            this.soupBase = soupBase;
            this.result = result;
            this.time = time;
            this.cookingTexture = cookingTexture;
            this.finishedTexture = finishedTexture;
            this.cookingBubbleColor = cookingBubbleColor;
            this.finishedBubbleColor = finishedBubbleColor;
        }

        public void method_10416(JsonObject json) {
            JsonArray ingredientsJson = new JsonArray();
            this.ingredients.stream().filter(i -> i != class_1856.field_9017).forEach(i -> ingredientsJson.add(i.method_8089()));
            json.add("ingredients", (JsonElement)ingredientsJson);
            json.addProperty("soup_base", this.soupBase.toString());
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", Objects.requireNonNull(class_7923.field_41178.method_10221((Object)this.result.method_7909())).toString());
            if (this.result.method_7947() > 1) {
                itemJson.addProperty("count", (Number)this.result.method_7947());
            }
            json.add("result", (JsonElement)itemJson);
            json.addProperty("time", (Number)this.time);
            json.addProperty("cooking_texture", this.cookingTexture.toString());
            json.addProperty("finished_texture", this.finishedTexture.toString());
            json.addProperty("cooking_bubble_color", (Number)this.cookingBubbleColor);
            json.addProperty("finished_bubble_color", (Number)this.finishedBubbleColor);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.STOCKPOT_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

