/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1471;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3749;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class ScarecrowEntity
extends class_1309 {
    public static final class_1299<ScarecrowEntity> TYPE = class_1299.class_1300.method_5903(ScarecrowEntity::new, (class_1311)class_1311.field_17715).method_17687(0.5f, 2.375f).method_27299(10).method_5905("scarecrow");
    private static final class_2940<class_2487> DATA_SHOULDER = class_2945.method_12791(ScarecrowEntity.class, (class_2941)class_2943.field_13318);
    private static final Predicate<class_1297> RIDABLE_MINECARTS = e -> {
        class_1688 minecart;
        return e instanceof class_1688 && (minecart = (class_1688)e).method_7518() == class_1688.class_1689.field_7674;
    };
    private static final Predicate<class_1297> SHOULDER_RIDING_ENTITY = e -> {
        class_1471 entity;
        return e instanceof class_1471 && !(entity = (class_1471)e).method_24345() && entity.method_6626();
    };
    private static final String HAND_ITEMS_TAG = "HandItems";
    private static final String ARMOR_ITEMS_TAG = "ArmorItems";
    private static final String SHOULDER_ENTITY_TAG = "ShoulderEntity";
    private final class_2371<class_1799> handItems = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private final class_2371<class_1799> armorItems = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public long lastHit;
    private int cooldown;
    private long timeEntitySatOnShoulder;

    public ScarecrowEntity(class_1299<ScarecrowEntity> type, class_1937 level) {
        super(type, level);
        this.method_49477(0.0f);
    }

    public ScarecrowEntity(class_1937 level, double pX, double pY, double pZ) {
        this(TYPE, level);
        this.method_5814(pX, pY, pZ);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_SHOULDER, (Object)new class_2487());
    }

    public void method_5773() {
        super.method_5773();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public class_1269 method_5664(class_1657 player, class_243 vec3, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand.method_31574(class_1802.field_8448)) {
            return class_1269.field_5811;
        }
        if (player.method_7325()) {
            return class_1269.field_5812;
        }
        if (player.method_37908().field_9236) {
            return class_1269.field_21466;
        }
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        if (this.cooldown > 0) {
            return class_1269.field_5811;
        }
        if (this.isClickHand(vec3)) {
            return this.handleHandItems(player, itemInHand);
        }
        if (this.isClickHead(vec3)) {
            return this.handleHeadItems(player, itemInHand);
        }
        return class_1269.field_5811;
    }

    private class_1269 handleHeadItems(class_1657 player, class_1799 itemInHand) {
        class_1747 blockItem;
        this.cooldown = 5;
        class_1799 headItem = this.method_6118(class_1304.field_6169);
        if (itemInHand.method_7960() && !headItem.method_7960()) {
            this.method_5673(class_1304.field_6169, class_1799.field_8037);
            player.method_31548().method_7398(headItem);
            return class_1269.field_5812;
        }
        class_1792 class_17922 = itemInHand.method_7909();
        if (!(class_17922 instanceof class_1747) || !((blockItem = (class_1747)class_17922).method_7711() instanceof class_2484)) {
            return class_1269.field_5811;
        }
        if (player.method_31549().field_7477 && headItem.method_7960()) {
            this.method_5673(class_1304.field_6169, itemInHand.method_46651(1));
            this.method_37908().method_45447(null, this.method_24515(), class_3417.field_14667, this.method_5634());
            ModTrigger.EVENT.trigger((class_1309)player, "place_head_on_scarecrow");
            return class_1269.field_5812;
        }
        if (!itemInHand.method_7960() && itemInHand.method_7947() > 1) {
            if (headItem.method_7960()) {
                this.method_5673(class_1304.field_6169, itemInHand.method_7971(1));
                this.method_37908().method_45447(null, this.method_24515(), class_3417.field_14667, this.method_5634());
                ModTrigger.EVENT.trigger((class_1309)player, "place_head_on_scarecrow");
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        this.method_5673(class_1304.field_6169, itemInHand);
        this.method_37908().method_45447(null, this.method_24515(), class_3417.field_14667, this.method_5634());
        player.method_6122(class_1268.field_5808, headItem);
        ModTrigger.EVENT.trigger((class_1309)player, "place_head_on_scarecrow");
        return class_1269.field_5812;
    }

    private class_1269 handleHandItems(class_1657 player, class_1799 itemInHand) {
        class_1747 blockItem;
        this.cooldown = 5;
        if (itemInHand.method_7960()) {
            class_1799 mainhand = this.method_5998(class_1268.field_5808);
            class_1799 offhand = this.method_5998(class_1268.field_5810);
            if (!mainhand.method_7960()) {
                this.method_5673(class_1304.field_6173, class_1799.field_8037);
                player.method_31548().method_7398(mainhand);
                return class_1269.field_5812;
            }
            if (!offhand.method_7960()) {
                this.method_5673(class_1304.field_6171, class_1799.field_8037);
                player.method_31548().method_7398(offhand);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_3749 && this.swapHand(class_1268.field_5810, player, itemInHand)) {
            this.method_37908().method_45447(null, this.method_24515(), class_3417.field_17743, this.method_5634());
            return class_1269.field_5812;
        }
        if (itemInHand.method_7909().method_7846() && this.swapHand(class_1268.field_5808, player, itemInHand)) {
            this.method_37908().method_45447(null, this.method_24515(), class_3417.field_14667, this.method_5634());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean swapHand(class_1268 hand, class_1657 player, class_1799 itemInHand) {
        class_1799 scarecrowStack = this.method_5998(hand);
        if (player.method_31549().field_7477 && scarecrowStack.method_7960() && !itemInHand.method_7960()) {
            this.method_6122(hand, itemInHand.method_46651(1));
            return true;
        }
        if (!itemInHand.method_7960() && itemInHand.method_7947() > 1) {
            if (scarecrowStack.method_7960()) {
                this.method_6122(hand, itemInHand.method_7971(1));
                return true;
            }
            return false;
        }
        this.method_6122(hand, itemInHand);
        player.method_6122(class_1268.field_5808, scarecrowStack);
        return true;
    }

    private boolean isClickHand(class_243 vector) {
        return 1.0625 <= vector.field_1351 && vector.field_1351 <= 1.588235294117647;
    }

    private boolean isClickHead(class_243 vector) {
        return 1.588235294117647 < vector.field_1351;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236 || this.method_31481()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5768();
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.brokenByAnything(source);
            this.method_5768();
            return false;
        }
        class_1297 entity = source.method_5529();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!player.method_31549().field_7476) {
                return false;
            }
        }
        if (source.method_5530()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.method_5768();
            return false;
        }
        long gameTime = this.method_37908().method_8510();
        if (gameTime - this.lastHit > 5L) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14897, this.method_5634(), 0.3f, 1.0f);
            this.method_37908().method_8421((class_1297)this, (byte)32);
            this.method_32875(class_5712.field_28736, source.method_5529());
            this.lastHit = gameTime;
            if (!this.getShoulderEntity().method_33133()) {
                this.removeEntitiesOnShoulder();
            }
        } else {
            this.brokenByPlayer(source);
            this.showBreakingParticles();
            this.method_5768();
        }
        return true;
    }

    public void method_5711(byte id) {
        if (id == 32) {
            if (this.method_37908().field_9236) {
                this.lastHit = this.method_37908().method_8510();
            }
        } else {
            super.method_5711(id);
        }
    }

    private void brokenByPlayer(class_1282 source) {
        class_1799 stack = new class_1799((class_1935)ModItems.SCARECROW);
        if (this.method_16914()) {
            stack.method_7977(this.method_5797());
        }
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)stack);
        this.brokenByAnything(source);
    }

    private void brokenByAnything(class_1282 source) {
        class_1799 stack;
        int i;
        this.playBrokenSound();
        this.method_16080(source);
        for (i = 0; i < this.handItems.size(); ++i) {
            stack = (class_1799)this.handItems.get(i);
            if (stack.method_7960()) continue;
            class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515().method_10084(), (class_1799)stack);
            this.handItems.set(i, (Object)class_1799.field_8037);
        }
        for (i = 0; i < this.armorItems.size(); ++i) {
            stack = (class_1799)this.armorItems.get(i);
            if (stack.method_7960()) continue;
            class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515().method_10084(), (class_1799)stack);
            this.armorItems.set(i, (Object)class_1799.field_8037);
        }
    }

    private void playBrokenSound() {
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15118, this.method_5634(), 1.0f, 1.0f);
    }

    private void showBreakingParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2388 particleOption = new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564());
            serverLevel.method_14199((class_2394)particleOption, this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private boolean setEntityOnShoulder(class_2487 tag) {
        if (this.canEntityOnShoulder()) {
            this.setShoulderEntity(tag);
            this.timeEntitySatOnShoulder = this.method_37908().method_8510();
            return true;
        }
        return false;
    }

    private void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.method_37908().method_8510()) {
            this.respawnEntityOnShoulder(this.getShoulderEntity());
            this.setShoulderEntity(new class_2487());
        }
    }

    private void respawnEntityOnShoulder(class_2487 tag) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!tag.method_33133()) {
                class_1299.method_5892((class_2487)tag, (class_1937)this.method_37908()).ifPresent(entity -> {
                    entity.method_5814(this.method_23317(), this.method_23318() + 1.675, this.method_23321());
                    serverLevel.method_18768(entity);
                });
            }
        }
    }

    public void method_5652(class_2487 tag) {
        tag.method_10566(HAND_ITEMS_TAG, (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.handItems));
        tag.method_10566(ARMOR_ITEMS_TAG, (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.armorItems));
        if (!this.getShoulderEntity().method_33133()) {
            tag.method_10566(SHOULDER_ENTITY_TAG, (class_2520)this.getShoulderEntity());
        }
    }

    public void method_5749(class_2487 tag) {
        class_2487 compound;
        super.method_5749(tag);
        if (tag.method_10545(HAND_ITEMS_TAG)) {
            compound = tag.method_10562(HAND_ITEMS_TAG);
            class_1262.method_5429((class_2487)compound, this.handItems);
        }
        if (tag.method_10545(ARMOR_ITEMS_TAG)) {
            compound = tag.method_10562(ARMOR_ITEMS_TAG);
            class_1262.method_5429((class_2487)compound, this.armorItems);
        }
        if (tag.method_10573(SHOULDER_ENTITY_TAG, 10)) {
            this.setShoulderEntity(tag.method_10562(SHOULDER_ENTITY_TAG));
        }
    }

    protected float method_6031(float yRot, float animStep) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    public void method_5636(float offset) {
        this.field_6220 = this.field_5982 = offset;
        this.field_6259 = this.field_6241 = offset;
    }

    public void method_5847(float rotation) {
        this.field_6220 = this.field_5982 = rotation;
        this.field_6259 = this.field_6241 = rotation;
    }

    public void method_5768() {
        if (!this.getShoulderEntity().method_33133()) {
            this.removeEntitiesOnShoulder();
        }
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876(class_5712.field_37676);
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829(), RIDABLE_MINECARTS);
        for (class_1297 entity : list) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
            return;
        }
        if (this.canEntityOnShoulder()) {
            list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(2.0), SHOULDER_RIDING_ENTITY);
            for (class_1297 entity : list) {
                class_1471 shoulderEntity;
                if (!(this.method_5858(entity) <= 1.5) || !(entity instanceof class_1471) || !this.setEntityOnShoulder(shoulderEntity = (class_1471)entity)) continue;
                return;
            }
        }
    }

    private boolean setEntityOnShoulder(class_1471 entity) {
        class_2487 tag = new class_2487();
        String id = entity.method_5653();
        if (id == null) {
            return false;
        }
        tag.method_10582("id", id);
        entity.method_5647(tag);
        if (this.setEntityOnShoulder(tag)) {
            entity.method_31472();
            return true;
        }
        return false;
    }

    private boolean canEntityOnShoulder() {
        return !this.method_5765() && this.method_24828() && !this.method_5799() && !this.field_27857 && this.getShoulderEntity().method_33133();
    }

    public Iterable<class_1799> method_5877() {
        return this.handItems;
    }

    public Iterable<class_1799> method_5661() {
        return this.armorItems;
    }

    public class_1799 method_6118(class_1304 slot) {
        return switch (slot.method_5925()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1304.class_1305.field_6177 -> (class_1799)this.handItems.get(slot.method_5927());
            case class_1304.class_1305.field_6178 -> (class_1799)this.armorItems.get(slot.method_5927());
        };
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        switch (slot.method_5925()) {
            case field_6177: {
                this.method_6116(slot, (class_1799)this.handItems.set(slot.method_5927(), (Object)stack), stack);
                break;
            }
            case field_6178: {
                this.method_6116(slot, (class_1799)this.armorItems.set(slot.method_5927(), (Object)stack), stack);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_5698(class_1297 entity) {
        if (!(entity instanceof class_1657)) return false;
        class_1657 player = (class_1657)entity;
        if (this.method_37908().method_8505(player, this.method_24515())) return false;
        return true;
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_15186, class_3417.field_15186);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_14897;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15118;
    }

    public void method_5800(class_3218 level, class_1538 lightningBolt) {
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.SCARECROW);
    }

    public class_2487 getShoulderEntity() {
        return (class_2487)this.field_6011.method_12789(DATA_SHOULDER);
    }

    public void setShoulderEntity(class_2487 tag) {
        this.field_6011.method_12778(DATA_SHOULDER, (Object)tag);
    }
}

