/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.init.registry;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModFoods;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteAnimateTicks;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FoodBiteRegistry {
    public static final Map<class_2960, FoodData> FOOD_DATA_MAP = Maps.newLinkedHashMap();
    public static class_2960 DARK_CUISINE;
    public static class_2960 SUSPICIOUS_STIR_FRY;
    public static class_2960 SLIME_BALL_MEAL;
    public static class_2960 FONDANT_PIE;
    public static class_2960 DONGPO_PORK;
    public static class_2960 FONDANT_SPIDER_EYE;
    public static class_2960 CHORUS_FRIED_EGG;
    public static class_2960 BRAISED_FISH;
    public static class_2960 GOLDEN_SALAD;
    public static class_2960 SPICY_CHICKEN;
    public static class_2960 YAKITORI;
    public static class_2960 PAN_SEARED_KNIGHT_STEAK;
    public static class_2960 STARGAZY_PIE;
    public static class_2960 SWEET_AND_SOUR_ENDER_PEARLS;
    public static class_2960 CRYSTAL_LAMB_CHOP;
    public static class_2960 BLAZE_LAMB_CHOP;
    public static class_2960 FROST_LAMB_CHOP;
    public static class_2960 NETHER_STYLE_SASHIMI;
    public static class_2960 END_STYLE_SASHIMI;
    public static class_2960 DESERT_STYLE_SASHIMI;
    public static class_2960 TUNDRA_STYLE_SASHIMI;
    public static class_2960 COLD_STYLE_SASHIMI;

    public static void init() {
        FoodBiteRegistry registry = new FoodBiteRegistry();
        DARK_CUISINE = registry.registerFoodData("dark_cuisine", FoodData.create(3, ModFoods.DARK_CUISINE_BLOCK, ModFoods.DARK_CUISINE_ITEM).setAnimateTick(FoodBiteAnimateTicks.DARK_CUISINE_ANIMATE_TICK));
        SUSPICIOUS_STIR_FRY = registry.registerFoodData("suspicious_stir_fry", FoodData.create(1, ModFoods.SUSPICIOUS_STIR_FRY_BLOCK, ModFoods.SUSPICIOUS_STIR_FRY_ITEM).setAnimateTick(FoodBiteAnimateTicks.SUSPICIOUS_STIR_FRY_ANIMATE_TICK));
        SLIME_BALL_MEAL = registry.registerFoodData("slime_ball_meal", FoodData.create(3, ModFoods.SLIME_BALL_MEAL_BLOCK, ModFoods.SLIME_BALL_MEAL_ITEM));
        FONDANT_PIE = registry.registerFoodData("fondant_pie", FoodData.create(4, ModFoods.FONDANT_PIE_BLOCK, ModFoods.FONDANT_PIE_ITEM));
        DONGPO_PORK = registry.registerFoodData("dongpo_pork", FoodData.create(3, ModFoods.DONGPO_PORK_BLOCK, ModFoods.DONGPO_PORK_ITEM).addLootItems(new class_1935[]{class_1802.field_8648}));
        FONDANT_SPIDER_EYE = registry.registerFoodData("fondant_spider_eye", FoodData.create(4, ModFoods.FONDANT_SPIDER_EYE_BLOCK, ModFoods.FONDANT_SPIDER_EYE_ITEM));
        CHORUS_FRIED_EGG = registry.registerFoodData("chorus_fried_egg", FoodData.create(3, ModFoods.CHORUS_FRIED_EGG_BLOCK, ModFoods.CHORUS_FRIED_EGG_ITEM));
        BRAISED_FISH = registry.registerFoodData("braised_fish", FoodData.create(4, ModFoods.BRAISED_FISH_BLOCK, ModFoods.BRAISED_FISH_ITEM).addLootItems(new class_1935[]{class_1802.field_8606, class_1802.field_8324}));
        GOLDEN_SALAD = registry.registerFoodData("golden_salad", FoodData.create(6, ModFoods.GOLDEN_SALAD_BLOCK, ModFoods.GOLDEN_SALAD_ITEM));
        SPICY_CHICKEN = registry.registerFoodData("spicy_chicken", FoodData.create(4, ModFoods.SPICY_CHICKEN_BLOCK, ModFoods.SPICY_CHICKEN_ITEM));
        YAKITORI = registry.registerFoodData("yakitori", FoodData.create(4, ModFoods.YAKITORI_BLOCK, ModFoods.YAKITORI_ITEM));
        PAN_SEARED_KNIGHT_STEAK = registry.registerFoodData("pan_seared_knight_steak", FoodData.create(4, ModFoods.PAN_SEARED_KNIGHT_STEAK_BLOCK, ModFoods.PAN_SEARED_KNIGHT_STEAK_ITEM).addLootItems(new class_1935[]{class_1802.field_8606, class_1802.field_8324}));
        STARGAZY_PIE = registry.registerFoodData("stargazy_pie", FoodData.create(4, ModFoods.STARGAZY_PIE_BLOCK, ModFoods.STARGAZY_PIE_ITEM));
        SWEET_AND_SOUR_ENDER_PEARLS = registry.registerFoodData("sweet_and_sour_ender_pearls", FoodData.create(3, ModFoods.SWEET_AND_SOUR_ENDER_PEARLS_BLOCK, ModFoods.SWEET_AND_SOUR_ENDER_PEARLS_ITEM));
        CRYSTAL_LAMB_CHOP = registry.registerFoodData("crystal_lamb_chop", FoodData.create(3, ModFoods.CRYSTAL_LAMB_CHOP_BLOCK, ModFoods.CRYSTAL_LAMB_CHOP_ITEM).addLootItems(new class_1935[]{class_1802.field_27063}));
        BLAZE_LAMB_CHOP = registry.registerFoodData("blaze_lamb_chop", FoodData.create(3, ModFoods.BLAZE_LAMB_CHOP_BLOCK, ModFoods.BLAZE_LAMB_CHOP_ITEM).addLootItems(new class_1935[]{class_1802.field_8894}));
        FROST_LAMB_CHOP = registry.registerFoodData("frost_lamb_chop", FoodData.create(3, ModFoods.FROST_LAMB_CHOP_BLOCK, ModFoods.FROST_LAMB_CHOP_ITEM).addLootItems(new class_1935[]{class_1802.field_8178}));
        NETHER_STYLE_SASHIMI = registry.registerFoodData("nether_style_sashimi", FoodData.create(4, ModFoods.NETHER_STYLE_SASHIMI_BLOCK, ModFoods.NETHER_STYLE_SASHIMI_ITEM).addLootItems(new class_1935[]{class_1802.field_21987, class_1802.field_21988}));
        END_STYLE_SASHIMI = registry.registerFoodData("end_style_sashimi", FoodData.create(4, ModFoods.END_STYLE_SASHIMI_BLOCK, ModFoods.END_STYLE_SASHIMI_ITEM).addLootItems(new class_1935[]{class_1802.field_8233}));
        DESERT_STYLE_SASHIMI = registry.registerFoodData("desert_style_sashimi", FoodData.create(4, ModFoods.DESERT_STYLE_SASHIMI_BLOCK, ModFoods.DESERT_STYLE_SASHIMI_ITEM).addLootItems(new class_1935[]{class_1802.field_17520}));
        TUNDRA_STYLE_SASHIMI = registry.registerFoodData("tundra_style_sashimi", FoodData.create(4, ModFoods.TUNDRA_STYLE_SASHIMI_BLOCK, ModFoods.TUNDRA_STYLE_SASHIMI_ITEM));
        COLD_STYLE_SASHIMI = registry.registerFoodData("cold_style_sashimi", FoodData.create(4, ModFoods.COLD_STYLE_SASHIMI_BLOCK, ModFoods.COLD_STYLE_SASHIMI_ITEM).addLootItems(new class_1935[]{class_1802.field_8543, class_1802.field_8543}));
    }

    public class_2960 registerFoodData(class_2960 foodName, FoodData data) {
        FOOD_DATA_MAP.put(foodName, data);
        return foodName;
    }

    public class_2960 registerFoodData(String foodName, FoodData data) {
        class_2960 id = FoodBiteRegistry.mcLoc(foodName);
        FOOD_DATA_MAP.put(id, data);
        return id;
    }

    public static class_2960 mcLoc(String name) {
        return new class_2960("kaleidoscope_cookery", name);
    }

    public static class_1792 getItem(class_2960 name) {
        return (class_1792)class_7923.field_41178.method_10223(name);
    }

    public static class_2248 getBlock(class_2960 name) {
        return (class_2248)class_7923.field_41175.method_10223(name);
    }

    public static final class FoodData {
        private final int maxBites;
        private final List<class_1935> lootItems = Lists.newArrayList();
        private final class_4174 blockFood;
        private final class_4174 itemFood;
        @Nullable
        private FoodBiteAnimateTicks.AnimateTick animateTick = null;

        private FoodData(int maxBites, class_4174 blockFood, class_4174 itemFood) {
            this.maxBites = maxBites;
            this.lootItems.add((class_1935)class_1802.field_8428);
            this.blockFood = blockFood;
            this.itemFood = itemFood;
        }

        public static FoodData create(int maxBites, class_4174 blockFood, class_4174 itemFood) {
            return new FoodData(maxBites, blockFood, itemFood);
        }

        public FoodData setAnimateTick(FoodBiteAnimateTicks.AnimateTick animateTick) {
            this.animateTick = animateTick;
            return this;
        }

        public FoodData addLootItems(class_1935 ... lootItems) {
            this.lootItems.addAll(Arrays.stream(lootItems).toList());
            return this;
        }

        public int maxBites() {
            return this.maxBites;
        }

        @Nullable
        public FoodBiteAnimateTicks.AnimateTick animateTick() {
            return this.animateTick;
        }

        public List<class_1935> getLootItems() {
            return this.lootItems;
        }

        public class_4174 blockFood() {
            return this.blockFood;
        }

        public class_4174 itemFood() {
            return this.itemFood;
        }
    }
}

