/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui;

import io.github.flemmli97.tenshilib.client.gui.widget.SuggestionEditBox;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.network.C2SAnimationDebuggerUpdate;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;

public class AnimationScreen<T extends LivingEntity>
extends Screen {
    protected final T entity;
    private final InteractionHand hand;
    private final String[] animations;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 160;
    private SuggestionEditBox box;
    private String selected;

    public AnimationScreen(T entity, InteractionHand hand, String id) {
        super((Component)Component.translatable((String)"tenshilib.gui.animation"));
        this.entity = entity;
        this.animations = (String[])((AnimatedEntity)entity).getAnimationHandler().getAnimations().all().toArray(String[]::new);
        this.hand = hand;
        this.selected = id;
    }

    protected void init() {
        super.init();
        this.leftPos = this.width / 2 - this.sizeX / 2;
        this.topPos = this.height / 2 - this.sizeY / 2;
        this.buttons();
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.fillGradient(this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int padding = 16;
        float scale = 32.0f;
        RenderUtils.renderScaledEntityGui(graphics, (float)(this.leftPos + this.sizeX - padding) - 3.0f * scale, this.topPos + padding, 3.0f * scale, 3.0f * scale, scale, 0.0f, mouseX, mouseY, this.entity);
        graphics.drawString(this.font, this.getTitle(), this.leftPos + 16, this.topPos + 16, 0xFFFFFF);
    }

    protected void buttons() {
        int padding = 16;
        int yOff = padding + 12 + 80;
        this.box = new SuggestionEditBox(this.minecraft.font, this.leftPos + this.sizeX / 2 - 70, this.topPos + yOff, 140, 20, (Component)Component.empty(), 5, true, SuggestionEditBox.ofString(List.of(this.animations)));
        this.box.setValue(this.selected);
        this.box.setResponder(s -> {
            s = s.trim();
            this.box.setTextColor(0xFF0000);
            for (String str : this.animations) {
                if (!s.equals(str)) continue;
                this.box.setTextColor(0xE0E0E0);
                this.selected = s;
                break;
            }
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"tenshilib.gui.save"), b -> {
            LoaderNetwork.INSTANCE.sendToServer(new C2SAnimationDebuggerUpdate(this.hand, this.selected));
            this.minecraft.setScreen(null);
        }).bounds(this.leftPos + this.sizeX / 2 - 50, this.topPos + (yOff += 24), 100, 20).build());
        this.addRenderableWidget((GuiEventListener)this.box);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.box.canConsumeInput() && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean click = super.mouseClicked(mouseX, mouseY, button);
        if (!click) {
            this.setFocused(null);
        }
        return click;
    }
}

