/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class TexturedButton
extends Button {
    private WidgetSprites sprites;

    public TexturedButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        this(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
    }

    public TexturedButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration) {
        super(x, y, width, height, message, onPress, createNarration);
    }

    public TexturedButton withSprite(WidgetSprites sprites) {
        this.sprites = sprites;
        return this;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.sprites == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.blitSprite(this.sprites.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(graphics, minecraft.font, FastColor.ABGR32.color((int)Mth.ceil((float)(this.alpha * 255.0f)), (int)color));
    }
}

