/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.particles.advanced.handler;

import io.github.flemmli97.tenshilib.client.particles.advanced.AdvancedParticleHandler;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.Mth;

public class ScaleHandler
implements AdvancedParticleHandler {
    private final ScaleData data;
    private int tick;

    public ScaleHandler(ScaleData data, Particle particle) {
        this.data = data;
        this.setScaleParticle(particle, data.start());
    }

    @Override
    public void tick(Particle particle) {
        if (this.data.duration() <= 0) {
            return;
        }
        ++this.tick;
        float prog = Mth.clamp((float)((float)this.tick / (float)this.data.duration()), (float)0.0f, (float)1.0f);
        this.setScaleParticle(particle, Mth.lerp((float)prog, (float)this.data.start(), (float)this.data.end()));
    }

    protected void setScaleParticle(Particle particle, float scale) {
        if (particle instanceof SingleQuadParticle) {
            SingleQuadParticle quad = (SingleQuadParticle)particle;
            float current = quad.getQuadSize(1.0f);
            scale /= current;
        }
        particle.scale(scale);
    }
}

