/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedProjectile
extends Projectile {
    protected static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.defineId(AdvancedProjectile.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private Entity shooter;
    protected boolean inGround;
    protected int ticksInGround;
    protected int livingTicks;
    public final List<UUID> attackedEntities = new ArrayList<UUID>();
    public final List<UUID> checkedEntities = new ArrayList<UUID>();
    protected BlockState groundState;
    protected BlockPos groundPos;

    public AdvancedProjectile(EntityType<? extends AdvancedProjectile> type, Level level) {
        super(type, level);
    }

    public AdvancedProjectile(EntityType<? extends AdvancedProjectile> type, Level level, double x, double y, double z) {
        this(type, level);
        this.setPos(x, y, z);
    }

    public AdvancedProjectile(EntityType<? extends AdvancedProjectile> type, Level level, LivingEntity shooter) {
        this(type, level, shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight() - 0.1, shooter.getZ());
        this.shooter = shooter;
        this.entityData.set(SHOOTER_UUID, Optional.of(shooter.getUUID()));
        this.setRot(shooter.getYRot(), shooter.getXRot());
        this.onUpdateOwner();
    }

    public static double getGravityOffset(AdvancedProjectile projectile, Vec3 dir, Vec3 motion) {
        if (projectile.getGravityVelocity() == 0.0f) {
            return 0.0;
        }
        double gravityOffset = dir.length() / motion.length() * 0.5 * (double)projectile.getGravityVelocity();
        return gravityOffset * 0.99;
    }

    public boolean isPiercing() {
        return false;
    }

    public int maxPierceAmount() {
        return -1;
    }

    public float radius() {
        return 0.0f;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 6000;
    }

    public boolean canHitShooter() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SHOOTER_UUID, Optional.empty());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 throwerMotion = entityThrower.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(throwerMotion.x, entityThrower.onGround() ? 0.0 : throwerMotion.y, throwerMotion.z));
        this.getDeltaMovement().add(throwerMotion.x, 0.0, throwerMotion.z);
    }

    public void shootAtEntity(Entity target, float velocity, float inaccuracy) {
        this.shootAtEntity(target, velocity, inaccuracy, false);
    }

    public void shootAtEntity(Entity target, float velocity, float inaccuracy, boolean ignoreGravity) {
        Vec3 targetPos = EntityUtils.getStraightProjectileTarget(this.position(), target);
        this.shootAtPosition(targetPos.x(), targetPos.y(), targetPos.z(), velocity, inaccuracy, ignoreGravity);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy) {
        this.shootAtPosition(x, y, z, velocity, inaccuracy, false);
    }

    public void shootAtPosition(double x, double y, double z, float velocity, float inaccuracy, boolean ignoreGravity) {
        Vec3 dir = new Vec3(x - this.getX(), y - this.getY(), z - this.getZ());
        if (this.getGravityVelocity() == 0.0f || ignoreGravity) {
            this.shoot(dir.x, dir.y, dir.z, velocity, inaccuracy);
        } else {
            Vec3 motion = dir.normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
            motion = motion.add(0.0, AdvancedProjectile.getGravityOffset(this, dir, motion), 0.0);
            this.setMotionWithRotation(motion);
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 motion = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setMotionWithRotation(motion);
    }

    private void setMotionWithRotation(Vec3 motion) {
        this.setDeltaMovement(motion);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag(motion));
        this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.ticksInGround = 0;
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = Math.sqrt(x * x + z * z);
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    public void setInGround(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        if (this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06))) {
            this.inGround = false;
            this.groundPos = null;
            this.groundState = null;
            return;
        }
        this.inGround = true;
        this.groundPos = pos;
        this.groundState = state;
    }

    public void tick() {
        BlockState groundState;
        super.tick();
        ++this.livingTicks;
        if (!this.level().isClientSide && this.livingTicks > this.livingTickMax()) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = Math.sqrt(AdvancedProjectile.horizontalMag(motion));
            this.setXRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
        }
        BlockState blockState = groundState = this.groundPos != null ? this.level().getBlockState(this.groundPos) : null;
        if (this.inGround) {
            if (groundState != this.groundState && this.noGround()) {
                this.resetInGround();
            }
            this.tickInGround();
            return;
        }
        if (!this.level().isClientSide) {
            this.doCollision();
        }
        this.moveEntity();
    }

    protected void tickInGround() {
        ++this.ticksInGround;
        if (!this.level().isClientSide && this.ticksInGround == 1200) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void moveEntity() {
        Vec3 motion = this.getDeltaMovement();
        double newX = this.getX() + motion.x;
        double newY = this.getY() + motion.y;
        double newZ = this.getZ() + motion.z;
        double f = Math.sqrt(AdvancedProjectile.horizontalMag(motion));
        this.setYRot(this.updateRotation(this.yRotO, (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232)));
        this.setXRot(this.updateRotation(this.xRotO, (float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875)));
        boolean water = this.isInWater();
        if (water) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() * 0.25, this.getY() * 0.25, this.getZ() * 0.25, motion.x, motion.y, motion.z);
            }
        }
        float friction = this.motionReduction(water);
        this.setDeltaMovement(motion.scale((double)friction));
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)this.getGravityVelocity(), 0.0));
        }
        this.setPos(newX, newY, newZ);
    }

    public static double horizontalMag(Vec3 vec) {
        return vec.x * vec.x + vec.z * vec.z;
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)prev, (float)current);
    }

    protected void doCollision() {
        Vec3 pos = this.position();
        Vec3 to = pos.add(this.getDeltaMovement());
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(pos, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            to = raytraceresult.getLocation();
        }
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            if (!TenshiLibCrossPlat.INSTANCE.projectileImpactEvent(this, (HitResult)raytraceresult)) {
                this.onHitBlock(raytraceresult);
                BlockPos blockPos = raytraceresult.getBlockPos();
                this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockPos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockPos)));
            }
        } else {
            EntityHitResult res;
            while ((res = this.getEntityHit(pos, to)) != null && this.isAlive()) {
                this.checkedEntities.add(res.getEntity().getUUID());
                if (TenshiLibCrossPlat.INSTANCE.projectileImpactEvent(this, (HitResult)res) || this.attackedEntities.contains(res.getEntity().getUUID()) || !this.entityRayTraceHit(res)) continue;
                this.attackedEntities.add(res.getEntity().getUUID());
                if (this.maxPierceAmount() == -1 || this.attackedEntities.size() <= this.maxPierceAmount()) continue;
                this.onReachMaxPierce();
            }
        }
    }

    protected boolean noGround() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    protected void resetInGround() {
        this.inGround = false;
        this.groundPos = null;
        this.groundState = null;
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    public void move(MoverType type, Vec3 to) {
        super.move(type, to);
        if (type != MoverType.SELF && this.noGround()) {
            this.resetInGround();
        }
    }

    protected boolean canHit(Entity target) {
        if (target.isSpectator() || !target.isAlive() || !target.isPickable() || this.checkedEntities.contains(target.getUUID())) {
            return false;
        }
        Entity entity = this.getOwner();
        if (entity == null) {
            return true;
        }
        if (entity.isPassengerOfSameVehicle(target) || TenshiLibCrossPlat.INSTANCE.isSameMultipart(target, this.getOwner())) {
            return false;
        }
        return !target.equals((Object)this.getOwner()) || this.canHitShooter() && this.tickCount >= 5;
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.isAlive()) {
            return null;
        }
        double amount = 1.0;
        if (this.isPiercing()) {
            amount = this.maxPierceAmount();
        }
        if (amount == -1.0 || (double)this.attackedEntities.size() < amount) {
            if (this.radius() != 0.0f) {
                double dist = to.subtract(from).length();
                OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.baseBox(this.radius() * 2.0f, this.radius() * 2.0f, dist), -this.getYRot(), this.getXRot(), this.position());
                List list = this.level().getEntities((Entity)this, obb.getEncompassingBox());
                for (Entity e : list) {
                    if (!this.canHit(e) || !obb.intersects(e.getBoundingBox())) continue;
                    AABB outer = obb.getEncompassingBox();
                    Vec3 hit = new Vec3(Mth.clamp((double)e.position().x, (double)outer.minX, (double)outer.maxX), Mth.clamp((double)e.position().y, (double)outer.minY, (double)outer.maxY), Mth.clamp((double)e.position().z, (double)outer.minZ, (double)outer.maxZ));
                    return new EntityHitResult(e, hit);
                }
                return null;
            }
            return HitResultUtils.rayTraceEntities((Entity)this, from, to, this::canHit);
        }
        return null;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected float motionReduction(boolean inWater) {
        return inWater ? 0.8f : 0.99f;
    }

    protected abstract boolean entityRayTraceHit(EntityHitResult var1);

    protected abstract void onBlockHit(BlockHitResult var1);

    protected void onReachMaxPierce() {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.inGround = compound.getBoolean("InGround");
        if (compound.contains("GroundPos")) {
            NbtUtils.readBlockPos((CompoundTag)compound, (String)"GroundPos").ifPresent(this::setInGround);
        }
        if (compound.hasUUID("Shooter")) {
            this.entityData.set(SHOOTER_UUID, Optional.of(compound.getUUID("Shooter")));
        }
        this.shooter = this.getOwner();
        this.livingTicks = compound.getInt("LivingTicks");
        ListTag list = compound.getList("AttackedEntities", 8);
        list.forEach(tag -> this.attackedEntities.add(UUID.fromString(tag.getAsString())));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.groundPos != null) {
            compound.put("GroundPos", NbtUtils.writeBlockPos((BlockPos)this.groundPos));
        }
        compound.putBoolean("InGround", this.inGround);
        ((Optional)this.entityData.get(SHOOTER_UUID)).ifPresent(uuid -> compound.putUUID("Shooter", uuid));
        compound.putInt("LivingTicks", this.livingTicks);
        ListTag list = new ListTag();
        this.attackedEntities.forEach(uuid -> list.add((Object)StringTag.valueOf((String)uuid.toString())));
        compound.put("AttackedEntities", (Tag)list);
    }

    @Nullable
    public Entity getOwner() {
        if (this.shooter != null && !this.shooter.isRemoved()) {
            return this.shooter;
        }
        ((Optional)this.entityData.get(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtils.findFromUUID(Entity.class, this.level(), uuid);
            this.onUpdateOwner();
        });
        return this.shooter;
    }

    public void onUpdateOwner() {
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(SHOOTER_UUID)).orElse(null);
    }

    protected final void onHitEntity(EntityHitResult result) {
        this.entityRayTraceHit(result);
    }

    protected final void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.onBlockHit(result);
    }

    public final void setOwner(@Nullable Entity entity) {
        if (entity == null) {
            this.shooter = null;
            this.entityData.set(SHOOTER_UUID, Optional.empty());
        } else {
            this.shooter = entity;
            this.entityData.set(SHOOTER_UUID, Optional.of(entity.getUUID()));
        }
        this.onUpdateOwner();
    }
}

