/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.animated;

import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record AnimationDefinition(String id, String animation, double length, double speed, boolean shouldRunOut, int startTransition, int endTransition, Map<String, double[]> markers) {
    public static final StreamCodec<FriendlyByteBuf, AnimationDefinition> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, AnimationDefinition>(){

        public AnimationDefinition decode(FriendlyByteBuf buf) {
            return new AnimationDefinition(buf.readUtf(), buf.readUtf(), buf.readDouble(), buf.readDouble(), buf.readBoolean(), buf.readInt(), buf.readInt(), buf.readMap(FriendlyByteBuf::readUtf, b -> {
                double[] ds = new double[b.readVarInt()];
                for (int i = 0; i < ds.length; ++i) {
                    ds[i] = buf.readDouble();
                }
                return ds;
            }));
        }

        public void encode(FriendlyByteBuf buf, AnimationDefinition data) {
            buf.writeUtf(data.id);
            buf.writeUtf(data.animation);
            buf.writeDouble(data.length);
            buf.writeDouble(data.speed);
            buf.writeBoolean(data.shouldRunOut);
            buf.writeInt(data.startTransition);
            buf.writeInt(data.endTransition);
            buf.writeMap(data.markers, FriendlyByteBuf::writeUtf, (b, ds) -> {
                buf.writeVarInt(((double[])ds).length);
                for (double d : ds) {
                    buf.writeDouble(d);
                }
            });
        }
    };

    public boolean is(AnimationDefinition ... definitions) {
        for (AnimationDefinition other : definitions) {
            if (other == null || !this.id().equals(other.id())) continue;
            return true;
        }
        return false;
    }

    public boolean is(String ... ids) {
        for (String other : ids) {
            if (!this.id().equals(other)) continue;
            return true;
        }
        return false;
    }

    public double marker(String marker, int idx) {
        double[] times = this.markers().get(marker);
        if (times == null || idx >= times.length) {
            return -1.0;
        }
        return times[idx];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof AnimationDefinition)) return false;
        AnimationDefinition other = (AnimationDefinition)obj;
        if (!this.id().equals(other.id())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id().hashCode();
    }
}

