/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.animated;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class AnimationDefinitionContainer {
    public static final StreamCodec<FriendlyByteBuf, AnimationDefinitionContainer> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, AnimationDefinitionContainer>(){

        public AnimationDefinitionContainer decode(FriendlyByteBuf buf) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List list = buf.readList(AnimationDefinition.STREAM_CODEC);
            list.forEach(d -> builder.put((Object)d.id(), d));
            return new AnimationDefinitionContainer((Map<String, AnimationDefinition>)builder.build());
        }

        public void encode(FriendlyByteBuf buf, AnimationDefinitionContainer data) {
            buf.writeCollection(data.animations.values(), AnimationDefinition.STREAM_CODEC);
        }
    };
    private final Map<String, AnimationDefinition> animations;

    public AnimationDefinitionContainer(Map<String, AnimationDefinition> animations) {
        this.animations = animations;
    }

    public AnimationDefinition get(String id) {
        return this.animations.get(id);
    }

    public Collection<String> all() {
        return this.animations.keySet();
    }
}

