/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.tenshilib.TenshiLib;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class SpawnEgg
extends SpawnEggItem {
    private static final Map<Supplier<? extends EntityType<?>>, SpawnEgg> EGGS_SUP = Maps.newIdentityHashMap();
    private static final Map<EntityType<?>, SpawnEgg> EGGS = Maps.newIdentityHashMap();
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> BY_ID = SpawnEgg.fetchMapFromSpawnEgg();
    private static boolean resolved;
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC;
    protected static final DispenseItemBehavior DEF;
    private final Supplier<? extends EntityType<?>> type;
    private final boolean mob;

    public SpawnEgg(Supplier<? extends EntityType<?>> type, int primary, int secondary, Item.Properties props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type;
        this.mob = false;
        this.onInit(type);
    }

    public SpawnEgg(EntityTypeHolder<?> type, int primary, int secondary, Item.Properties props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type.type;
        this.mob = Mob.class.isAssignableFrom(type.clss);
        this.onInit(type.type);
    }

    private static Map<EntityType<? extends Mob>, SpawnEggItem> fetchMapFromSpawnEgg() {
        for (Field f : SpawnEggItem.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Map.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                Object obj = f.get(null);
                if (!(obj instanceof IdentityHashMap)) continue;
                return (Map)f.get(null);
            }
            catch (IllegalAccessException e) {
                TenshiLib.LOGGER.error((Object)e);
            }
        }
        throw new RuntimeException("Couldn't find spawnegg map");
    }

    public static void resolveEggs() {
        if (resolved) {
            return;
        }
        resolved = true;
        EGGS_SUP.forEach((type, egg) -> {
            if (egg.addToDefaultSpawneggs() && egg.mob) {
                BY_ID.put((EntityType<? extends Mob>)((EntityType)type.get()), (SpawnEggItem)egg);
            }
            EGGS.put((EntityType<?>)((EntityType)type.get()), (SpawnEgg)((Object)egg));
        });
    }

    public static Iterable<SpawnEgg> getEggs() {
        return Iterables.unmodifiableIterable(EGGS_SUP.values());
    }

    public static Optional<SpawnEgg> fromType(EntityType<?> type) {
        SpawnEgg.resolveEggs();
        return Optional.ofNullable(EGGS.get(type));
    }

    public static Optional<SpawnEgg> fromID(ResourceLocation id) {
        return BuiltInRegistries.ENTITY_TYPE.getOptional(id).flatMap(SpawnEgg::fromType);
    }

    protected void onInit(Supplier<? extends EntityType<?>> type) {
        EGGS_SUP.put(type, this);
    }

    public boolean onEntitySpawned(Entity e, ItemStack stack, @Nullable Player player) {
        return true;
    }

    public Component getEntityName(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_NAME) ? stack.getHoverName() : null;
    }

    public DispenseItemBehavior dispenser() {
        return DEF;
    }

    public boolean addToDefaultSpawneggs() {
        return true;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack), (Object[])new Object[]{Component.translatable((String)this.getType(stack).getDescriptionId())});
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity blockEntity;
        Level level = ctx.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.getItemInHand();
        BlockPos blockpos = ctx.getClickedPos();
        Direction direction = ctx.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        InteractionResult onBlock = this.onBlockUse(stack, blockpos, blockstate, blockEntity = level.getBlockEntity(blockpos));
        if (onBlock != InteractionResult.PASS) {
            return onBlock;
        }
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            CompoundTag nbt = new CompoundTag();
            spawner.getSpawner().save(nbt);
            nbt.remove("SpawnPotentials");
            nbt.remove("SpawnData");
            SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new SpawnData(((CustomData)stack.get(DataComponents.ENTITY_DATA)).copyTag(), Optional.empty(), Optional.empty())).resultOrPartial(string -> TenshiLib.LOGGER.warn("Invalid SpawnData: {}", string)).ifPresent(t -> nbt.put("SpawnData", t));
            spawner.getSpawner().load(blockEntity.getLevel(), blockEntity.getBlockPos(), nbt);
            spawner.setChanged();
            ctx.getLevel().sendBlockUpdated(ctx.getClickedPos(), blockstate, blockstate, 3);
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        Entity entity = SpawnEgg.spawnEntity((ServerLevel)level, ctx.getPlayer(), stack, blockPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockPos) && direction == Direction.UP);
        if (entity != null) {
            stack.shrink(1);
            if (ctx.getPlayer() != null) {
                ctx.getPlayer().awardStat(Stats.ITEM_USED.get((Object)this));
            }
            level.gameEvent((Entity)ctx.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, entity.position());
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult onBlockUse(ItemStack stack, BlockPos pos, BlockState state, @Nullable BlockEntity tile) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = SpawnEgg.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockpos = hitResult.getBlockPos();
        if (!(level.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, hitResult.getDirection(), stack)) {
            Entity entity = SpawnEgg.spawnEntity(serverLevel, player, stack, blockpos, MobSpawnType.SPAWN_EGG, true, false);
            if (entity != null) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public EntityType<?> getType(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return !customData.isEmpty() ? customData.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.type.get()) : this.type.get();
    }

    public FeatureFlagSet requiredFeatures() {
        return this.type.get().requiredFeatures();
    }

    public static Entity spawnEntity(ServerLevel level, Player player, ItemStack stack, BlockPos pos, MobSpawnType reason, boolean updateLocation, boolean doCollisionOffset) {
        Item item = stack.getItem();
        if (!(item instanceof SpawnEgg)) {
            return null;
        }
        SpawnEgg item2 = (SpawnEgg)item;
        EntityType<?> type = item2.getType(stack);
        Entity entity = type.create(level, EntityType.createDefaultStackConfig((ServerLevel)level, (ItemStack)stack, (Player)player), pos, reason, updateLocation, doCollisionOffset);
        if (entity != null) {
            if (!item2.onEntitySpawned(entity, stack, player)) {
                return null;
            }
            level.addFreshEntityWithPassengers(entity);
        }
        return entity;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return this.getColor(tintIndex);
    }

    static {
        ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
        DEF = (blockSource, stack) -> {
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            SpawnEgg.spawnEntity(blockSource.level(), null, stack, blockSource.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
            stack.shrink(1);
            blockSource.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, blockSource.pos(), GameEvent.Context.of((BlockState)blockSource.state()));
            return stack;
        };
    }

    public record EntityTypeHolder<T extends Entity>(Class<T> clss, Supplier<? extends EntityType<? extends T>> type) {
    }
}

