/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.mixin.dual;

import io.github.flemmli97.tenshilib.common.item.DualWeapon;
import io.github.flemmli97.tenshilib.mixinhelper.LastSwungHand;
import io.github.flemmli97.tenshilib.mixinhelper.MixinUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements LastSwungHand {
    @Unique
    private InteractionHand tenshilib$prevSwungHand = InteractionHand.OFF_HAND;

    @Inject(method={"getOffhandItem()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void offhandItem(CallbackInfoReturnable<ItemStack> info) {
        Item item;
        if (((LivingEntity)this).level().isClientSide && (item = ((LivingEntity)this).getMainHandItem().getItem()) instanceof DualWeapon) {
            DualWeapon dual = (DualWeapon)item;
            info.setReturnValue((Object)dual.offHandStack((LivingEntity)this));
            info.cancel();
        }
    }

    @Inject(method={"getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void offhandItemGeneric(InteractionHand hand, CallbackInfoReturnable<ItemStack> info) {
        Item item;
        if (hand == InteractionHand.OFF_HAND && ((LivingEntity)this).level().isClientSide && (item = ((LivingEntity)this).getMainHandItem().getItem()) instanceof DualWeapon) {
            DualWeapon dual = (DualWeapon)item;
            info.setReturnValue((Object)dual.offHandStack((LivingEntity)this));
            info.cancel();
        }
    }

    @ModifyVariable(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(value="HEAD"), argsOnly=true)
    private InteractionHand swingHook(InteractionHand hand) {
        return MixinUtils.get((LivingEntity)this, hand, this.tenshilib$prevSwungHand, v -> {
            this.tenshilib$prevSwungHand = v;
        });
    }

    @Override
    public InteractionHand tenshilib$lastSwungHand() {
        return this.tenshilib$prevSwungHand;
    }

    @Override
    public void tenshilib$SetLastSwungHand(InteractionHand hand) {
        this.tenshilib$prevSwungHand = hand;
    }
}

