/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.tenshilib.patreon.PatreonPlayerSetting;
import io.github.flemmli97.tenshilib.patreon.TenshiLibPatreonPlatform;
import io.github.flemmli97.tenshilib.patreon.client.PatreonModelProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PatreonLayer<T extends Player, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public PatreonLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInvisible()) {
            return;
        }
        PatreonPlayerSetting setting = TenshiLibPatreonPlatform.INSTANCE.playerSettings((Player)entity);
        if (entity.isInvisibleTo((Player)Minecraft.getInstance().player) || setting.effect() == null || !setting.shouldRender()) {
            return;
        }
        PatreonModelProvider.EffectRenderer<?> renderer = PatreonModelProvider.get(setting.effect());
        if (renderer == null) {
            return;
        }
        stack.pushPose();
        if (this.getParentModel().young) {
            stack.translate(0.0f, 0.75f, 0.0f);
            stack.scale(0.5f, 0.5f, 0.5f);
        }
        switch (setting.getRenderLocation()) {
            case CIRCLING: {
                stack.scale(0.7f, 0.7f, 0.7f);
                float tick = (float)((Player)entity).tickCount + partialTicks;
                stack.translate((double)Mth.cos((float)((float)Math.PI / 180 * tick * 5.0f)), (double)Mth.sin((float)((float)Math.PI / 180 * tick * 1.25f)) * 1.4 - 1.0, (double)Mth.sin((float)((float)Math.PI / 180 * tick * 5.0f)));
                break;
            }
            case CIRCLINGREVERSE: {
                stack.scale(0.7f, 0.7f, 0.7f);
                float tick = (float)((Player)entity).tickCount + partialTicks;
                stack.translate((double)(-Mth.cos((float)((float)Math.PI / 180 * tick * 5.0f))), (double)Mth.sin((float)((float)Math.PI / 180 * tick * 1.25f)) * 1.4 - 1.0, (double)(-Mth.sin((float)((float)Math.PI / 180 * tick * 5.0f))));
                break;
            }
            case HATNOARMOR: 
            case HAT: {
                if (!((HeadedModel)this.getParentModel()).getHead().visible) {
                    return;
                }
                ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(stack);
                stack.translate(0.0, -2.0, 0.0);
                break;
            }
            case LEFTSHOULDER: {
                EntityModel entityModel = this.getParentModel();
                if (entityModel instanceof HumanoidModel) {
                    HumanoidModel model = (HumanoidModel)entityModel;
                    if (!model.body.visible) {
                        return;
                    }
                }
                stack.translate(0.4, entity.isCrouching() ? -1.3 : -1.5, 0.0);
                break;
            }
            case RIGHTSHOULDER: {
                EntityModel entityModel = this.getParentModel();
                if (entityModel instanceof HumanoidModel) {
                    HumanoidModel model = (HumanoidModel)entityModel;
                    if (!model.body.visible) {
                        return;
                    }
                }
                stack.translate(-0.4, entity.isCrouching() ? -1.3 : -1.5, 0.0);
                break;
            }
            case BACK: {
                EntityModel entityModel = this.getParentModel();
                if (entityModel instanceof HumanoidModel) {
                    HumanoidModel model = (HumanoidModel)entityModel;
                    if (!model.body.visible) {
                        return;
                    }
                    model.body.translateAndRotate(stack);
                    stack.translate(0.0, -0.8, 0.8);
                    break;
                }
                stack.translate(0.0, entity.isCrouching() ? -0.6 : -0.8, 0.8);
            }
        }
        int hexColor = setting.getColor();
        renderer.render(stack, buffer, packedLight, (Player)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, hexColor, setting.getRenderLocation());
        stack.popPose();
    }
}

